/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.Variable;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;

public class Osyczka2
extends Problem {
    public Osyczka2(String solutionType) throws ClassNotFoundException {
        this.numberOfVariables_ = 6;
        this.numberOfObjectives_ = 2;
        this.numberOfConstraints_ = 6;
        this.problemName_ = "Osyczka2";
        this.lowerLimit_ = new double[this.numberOfVariables_];
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_[0] = 0.0;
        this.lowerLimit_[1] = 0.0;
        this.lowerLimit_[2] = 1.0;
        this.lowerLimit_[3] = 0.0;
        this.lowerLimit_[4] = 1.0;
        this.lowerLimit_[5] = 0.0;
        this.upperLimit_[0] = 10.0;
        this.upperLimit_[1] = 10.0;
        this.upperLimit_[2] = 5.0;
        this.upperLimit_[3] = 6.0;
        this.upperLimit_[4] = 5.0;
        this.upperLimit_[5] = 10.0;
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        Variable[] decisionVariables = solution.getDecisionVariables();
        double[] f = new double[this.numberOfObjectives_];
        double x1 = decisionVariables[0].getValue();
        double x2 = decisionVariables[1].getValue();
        double x3 = decisionVariables[2].getValue();
        double x4 = decisionVariables[3].getValue();
        double x5 = decisionVariables[4].getValue();
        double x6 = decisionVariables[5].getValue();
        f[0] = -(25.0 * (x1 - 2.0) * (x1 - 2.0) + (x2 - 2.0) * (x2 - 2.0) + (x3 - 1.0) * (x3 - 1.0) + (x4 - 4.0) * (x4 - 4.0) + (x5 - 1.0) * (x5 - 1.0));
        f[1] = x1 * x1 + x2 * x2 + x3 * x3 + x4 * x4 + x5 * x5 + x6 * x6;
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
    }

    @Override
    public void evaluateConstraints(Solution solution) throws JMException {
        double[] constraint = new double[this.getNumberOfConstraints()];
        Variable[] decisionVariables = solution.getDecisionVariables();
        double x1 = decisionVariables[0].getValue();
        double x2 = decisionVariables[1].getValue();
        double x3 = decisionVariables[2].getValue();
        double x4 = decisionVariables[3].getValue();
        double x5 = decisionVariables[4].getValue();
        double x6 = decisionVariables[5].getValue();
        constraint[0] = (x1 + x2) / 2.0 - 1.0;
        constraint[1] = (6.0 - x1 - x2) / 6.0;
        constraint[2] = (2.0 - x2 + x1) / 2.0;
        constraint[3] = (2.0 - x1 + 3.0 * x2) / 2.0;
        constraint[4] = (4.0 - (x3 - 3.0) * (x3 - 3.0) - x4) / 4.0;
        constraint[5] = ((x5 - 3.0) * (x5 - 3.0) + x6 - 4.0) / 4.0;
        double total = 0.0;
        int number = 0;
        for (int i = 0; i < this.getNumberOfConstraints(); ++i) {
            if (!(constraint[i] < 0.0)) continue;
            total += constraint[i];
            ++number;
        }
        solution.setOverallConstraintViolation(total);
        solution.setNumberOfViolatedConstraint(number);
    }
}

