/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.Variable;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;

public class Tanaka
extends Problem {
    public Tanaka(String solutionType) throws ClassNotFoundException {
        this.numberOfVariables_ = 2;
        this.numberOfObjectives_ = 2;
        this.numberOfConstraints_ = 2;
        this.problemName_ = "Tanaka";
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_ = new double[this.numberOfVariables_];
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = 1.0E-4;
            this.upperLimit_[var] = Math.PI;
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        Variable[] variable = solution.getDecisionVariables();
        double[] f = new double[this.numberOfObjectives_];
        f[0] = variable[0].getValue();
        f[1] = variable[1].getValue();
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
    }

    @Override
    public void evaluateConstraints(Solution solution) throws JMException {
        double[] constraint = new double[this.getNumberOfConstraints()];
        double x1 = solution.getDecisionVariables()[0].getValue();
        double x2 = solution.getDecisionVariables()[1].getValue();
        constraint[0] = x1 * x1 + x2 * x2 - 1.0 - 0.1 * Math.cos(16.0 * Math.atan(x1 / x2));
        constraint[1] = -2.0 * ((x1 - 0.5) * (x1 - 0.5) + (x2 - 0.5) * (x2 - 0.5) - 0.5);
        int number = 0;
        double total = 0.0;
        for (int i = 0; i < this.getNumberOfConstraints(); ++i) {
            if (!(constraint[i] < 0.0)) continue;
            ++number;
            total += constraint[i];
        }
        solution.setOverallConstraintViolation(total);
        solution.setNumberOfViolatedConstraint(number);
    }
}

