/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;

public class Viennet3
extends Problem {
    public Viennet3(String solutionType) throws ClassNotFoundException {
        this.numberOfVariables_ = 2;
        this.numberOfObjectives_ = 3;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "Viennet3";
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_ = new double[this.numberOfVariables_];
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = -3.0;
            this.upperLimit_[var] = 3.0;
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        double[] x = new double[this.numberOfVariables_];
        double[] f = new double[this.numberOfObjectives_];
        for (int i = 0; i < this.numberOfVariables_; ++i) {
            x[i] = solution.getDecisionVariables()[i].getValue();
        }
        f[0] = 0.5 * (x[0] * x[0] + x[1] * x[1]) + Math.sin(x[0] * x[0] + x[1] * x[1]);
        double value1 = 3.0 * x[0] - 2.0 * x[1] + 4.0;
        double value2 = x[0] - x[1] + 1.0;
        f[1] = value1 * value1 / 8.0 + value2 * value2 / 27.0 + 15.0;
        f[2] = 1.0 / (x[0] * x[0] + x[1] * x[1] + 1.0) - 1.1 * Math.exp(-(x[0] * x[0]) - x[1] * x[1]);
        for (int i = 0; i < this.numberOfObjectives_; ++i) {
            solution.setObjective(i, f[i]);
        }
    }
}

