/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.WFG;

import java.util.Random;
import jmetal.core.Problem;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;

public abstract class WFG
extends Problem {
    private final float epsilon = 1.0E-7f;
    protected int k_;
    protected int M_;
    protected int l_;
    protected int[] A_;
    protected int[] S_;
    protected int D_ = 1;
    protected Random random = new Random();

    public WFG(String solutionType, Integer k, Integer l, Integer M) throws ClassNotFoundException {
        this.k_ = k;
        this.l_ = l;
        this.M_ = M;
        this.numberOfVariables_ = this.k_ + this.l_;
        this.numberOfObjectives_ = this.M_;
        this.numberOfConstraints_ = 0;
        this.lowerLimit_ = new double[this.numberOfVariables_];
        this.upperLimit_ = new double[this.numberOfVariables_];
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = 0.0;
            this.upperLimit_[var] = 2 * (var + 1);
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    public float[] calculate_x(float[] t) {
        float[] x = new float[this.M_];
        for (int i = 0; i < this.M_ - 1; ++i) {
            x[i] = Math.max(t[this.M_ - 1], (float)this.A_[i]) * (t[i] - 0.5f) + 0.5f;
        }
        x[this.M_ - 1] = t[this.M_ - 1];
        return x;
    }

    public float[] normalise(float[] z) {
        float[] result = new float[z.length];
        for (int i = 0; i < z.length; ++i) {
            float bound = 2.0f * (float)(i + 1);
            result[i] = z[i] / bound;
            result[i] = this.correct_to_01(result[i]);
        }
        return result;
    }

    public float correct_to_01(float a) {
        float min = 0.0f;
        float max = 1.0f;
        float min_epsilon = min - 1.0E-7f;
        float max_epsilon = max + 1.0E-7f;
        if (a <= min && a >= min_epsilon || a >= min && a <= min_epsilon) {
            return min;
        }
        if (a >= max && a <= max_epsilon || a <= max && a >= max_epsilon) {
            return max;
        }
        return a;
    }

    public float[] subVector(float[] z, int head, int tail) {
        int size = tail - head + 1;
        float[] result = new float[size];
        for (int i = head; i <= tail; ++i) {
            result[i - head] = z[i];
        }
        return result;
    }

    public abstract float[] evaluate(float[] var1);
}

