/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.ZDT;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.ArrayRealSolutionType;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;
import jmetal.util.wrapper.XReal;

public class ZDT2
extends Problem {
    public ZDT2(String solutionType) throws ClassNotFoundException {
        this(solutionType, 30);
    }

    public ZDT2(String solutionType, Integer numberOfVariables) throws ClassNotFoundException {
        this.numberOfVariables_ = numberOfVariables;
        this.numberOfObjectives_ = 2;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "ZDT2";
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_ = new double[this.numberOfVariables_];
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = 0.0;
            this.upperLimit_[var] = 1.0;
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else if (solutionType.compareTo("ArrayReal") == 0) {
            this.solutionType_ = new ArrayRealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        XReal x = new XReal(solution);
        double[] fx = new double[this.numberOfObjectives_];
        fx[0] = x.getValue(0);
        double g = this.evalG(x);
        double h = this.evalH(fx[0], g);
        fx[1] = h * g;
        solution.setObjective(0, fx[0]);
        solution.setObjective(1, fx[1]);
    }

    private double evalG(XReal x) throws JMException {
        double g = 0.0;
        for (int i = 1; i < x.getNumberOfDecisionVariables(); ++i) {
            g += x.getValue(i);
        }
        double constante = 9.0 / (double)(this.numberOfVariables_ - 1);
        g = constante * g;
        return g += 1.0;
    }

    public double evalH(double f, double g) {
        double h = 0.0;
        h = 1.0 - Math.pow(f / g, 2.0);
        return h;
    }
}

