/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.ZDT;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.encodings.solutionType.ArrayRealSolutionType;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;
import jmetal.util.wrapper.XReal;

public class ZDT6
extends Problem {
    public ZDT6(String solutionType) throws ClassNotFoundException {
        this(solutionType, 10);
    }

    public ZDT6(String solutionType, Integer numberOfVariables) throws ClassNotFoundException {
        this.numberOfVariables_ = numberOfVariables;
        this.numberOfObjectives_ = 2;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "ZDT6";
        this.lowerLimit_ = new double[this.numberOfVariables_];
        this.upperLimit_ = new double[this.numberOfVariables_];
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = 0.0;
            this.upperLimit_[var] = 1.0;
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else if (solutionType.compareTo("ArrayReal") == 0) {
            this.solutionType_ = new ArrayRealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        XReal x = new XReal(solution);
        double x1 = x.getValue(0);
        double[] f = new double[this.numberOfObjectives_];
        f[0] = 1.0 - Math.exp(-4.0 * x1) * Math.pow(Math.sin(Math.PI * 6 * x1), 6.0);
        double g = this.evalG(x);
        double h = this.evalH(f[0], g);
        f[1] = h * g;
        solution.setObjective(0, f[0]);
        solution.setObjective(1, f[1]);
    }

    public double evalG(XReal x) throws JMException {
        double g = 0.0;
        for (int var = 1; var < this.numberOfVariables_; ++var) {
            g += x.getValue(var);
        }
        g /= (double)(this.numberOfVariables_ - 1);
        g = Math.pow(g, 0.25);
        g = 9.0 * g;
        g = 1.0 + g;
        return g;
    }

    public double evalH(double f, double g) {
        return 1.0 - Math.pow(f / g, 2.0);
    }
}

