/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.cec2009Competition;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.Variable;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;

public class CEC2009_UF9
extends Problem {
    double epsilon_;

    public CEC2009_UF9(String solutionType) throws ClassNotFoundException {
        this(solutionType, 30, 0.1);
    }

    public CEC2009_UF9(String solutionType, Integer numberOfVariables, double epsilon) throws ClassNotFoundException {
        this.numberOfVariables_ = numberOfVariables;
        this.numberOfObjectives_ = 3;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "CEC2009_UF9";
        this.epsilon_ = epsilon;
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_[0] = 0.0;
        this.upperLimit_[0] = 1.0;
        this.lowerLimit_[1] = 0.0;
        this.upperLimit_[1] = 1.0;
        for (int var = 2; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = -2.0;
            this.upperLimit_[var] = 2.0;
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        double yj;
        Variable[] decisionVariables = solution.getDecisionVariables();
        double[] x = new double[this.numberOfVariables_];
        for (int i = 0; i < this.numberOfVariables_; ++i) {
            x[i] = decisionVariables[i].getValue();
        }
        double sum3 = 0.0;
        double sum2 = 0.0;
        double sum1 = 0.0;
        int count3 = 0;
        int count2 = 0;
        int count1 = 0;
        for (int j = 3; j <= this.numberOfVariables_; ++j) {
            yj = x[j - 1] - 2.0 * x[1] * Math.sin(Math.PI * 2 * x[0] + (double)j * Math.PI / (double)this.numberOfVariables_);
            if (j % 3 == 1) {
                sum1 += yj * yj;
                ++count1;
                continue;
            }
            if (j % 3 == 2) {
                sum2 += yj * yj;
                ++count2;
                continue;
            }
            sum3 += yj * yj;
            ++count3;
        }
        yj = (1.0 + this.epsilon_) * (1.0 - 4.0 * (2.0 * x[0] - 1.0) * (2.0 * x[0] - 1.0));
        if (yj < 0.0) {
            yj = 0.0;
        }
        solution.setObjective(0, 0.5 * (yj + 2.0 * x[0]) * x[1] + 2.0 * sum1 / (double)count1);
        solution.setObjective(1, 0.5 * (yj - 2.0 * x[0] + 2.0) * x[1] + 2.0 * sum2 / (double)count2);
        solution.setObjective(2, 1.0 - x[1] + 2.0 * sum3 / (double)count3);
    }
}

