/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.singleObjective;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.Variable;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;

public class Griewank
extends Problem {
    public Griewank(String solutionType, Integer numberOfVariables) throws ClassNotFoundException {
        this.numberOfVariables_ = numberOfVariables;
        this.numberOfObjectives_ = 1;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "Sphere";
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_ = new double[this.numberOfVariables_];
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = -600.0;
            this.upperLimit_[var] = 600.0;
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        Variable[] decisionVariables = solution.getDecisionVariables();
        double sum = 0.0;
        double mult = 1.0;
        double d = 4000.0;
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            sum += decisionVariables[var].getValue() * decisionVariables[var].getValue();
            mult *= Math.cos(decisionVariables[var].getValue() / Math.sqrt(var + 1));
        }
        solution.setObjective(0, 1.0 / d * sum - mult + 1.0);
    }
}

