/*
 * Decompiled with CFR 0.152.
 */
package jmetal.problems.singleObjective;

import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.core.Variable;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.util.JMException;

public class Sphere
extends Problem {
    public Sphere(String solutionType, Integer numberOfVariables) throws ClassNotFoundException {
        this.numberOfVariables_ = numberOfVariables;
        this.numberOfObjectives_ = 1;
        this.numberOfConstraints_ = 0;
        this.problemName_ = "Sphere";
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.lowerLimit_ = new double[this.numberOfVariables_];
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            this.lowerLimit_[var] = -5.12;
            this.upperLimit_[var] = 5.12;
        }
        if (solutionType.compareTo("BinaryReal") == 0) {
            this.solutionType_ = new BinaryRealSolutionType(this);
        } else if (solutionType.compareTo("Real") == 0) {
            this.solutionType_ = new RealSolutionType(this);
        } else {
            System.out.println("Error: solution type " + solutionType + " invalid");
            System.exit(-1);
        }
    }

    @Override
    public void evaluate(Solution solution) throws JMException {
        Variable[] decisionVariables = solution.getDecisionVariables();
        double sum = 0.0;
        for (int var = 0; var < this.numberOfVariables_; ++var) {
            sum += StrictMath.pow(decisionVariables[var].getValue(), 2.0);
        }
        solution.setObjective(0, sum);
    }
}

