/*
 * Decompiled with CFR 0.152.
 */
package jmetal.qualityIndicator;

import jmetal.qualityIndicator.util.MetricsUtil;

public class GenerationalDistance {
    public MetricsUtil utils_ = new MetricsUtil();
    static final double pow_ = 2.0;

    public double generationalDistance(double[][] front, double[][] trueParetoFront, int numberOfObjectives) {
        double[] maximumValue = this.utils_.getMaximumValues(trueParetoFront, numberOfObjectives);
        double[] minimumValue = this.utils_.getMinimumValues(trueParetoFront, numberOfObjectives);
        double[][] normalizedFront = this.utils_.getNormalizedFront(front, maximumValue, minimumValue);
        double[][] normalizedParetoFront = this.utils_.getNormalizedFront(trueParetoFront, maximumValue, minimumValue);
        double sum = 0.0;
        for (int i = 0; i < front.length; ++i) {
            sum += Math.pow(this.utils_.distanceToClosedPoint(normalizedFront[i], normalizedParetoFront), 2.0);
        }
        sum = Math.pow(sum, 0.5);
        double generationalDistance = sum / (double)normalizedFront.length;
        return generationalDistance;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("GenerationalDistance::Main: Usage: java GenerationalDistance <FrontFile> <TrueFrontFile>  <numberOfObjectives>");
            System.exit(1);
        }
        GenerationalDistance qualityIndicator = new GenerationalDistance();
        double[][] solutionFront = qualityIndicator.utils_.readFront(args[0]);
        double[][] trueFront = qualityIndicator.utils_.readFront(args[1]);
        double value = qualityIndicator.generationalDistance(solutionFront, trueFront, new Integer(args[2]));
        System.out.println(value);
    }
}

