/*
 * Decompiled with CFR 0.152.
 */
package jmetal.qualityIndicator;

import jmetal.qualityIndicator.util.MetricsUtil;

public class Hypervolume {
    public MetricsUtil utils_ = new MetricsUtil();

    boolean dominates(double[] point1, double[] point2, int noObjectives) {
        int i;
        int betterInAnyObjective = 0;
        for (i = 0; i < noObjectives && point1[i] >= point2[i]; ++i) {
            if (!(point1[i] > point2[i])) continue;
            betterInAnyObjective = 1;
        }
        return i >= noObjectives && betterInAnyObjective > 0;
    }

    void swap(double[][] front, int i, int j) {
        double[] temp = front[i];
        front[i] = front[j];
        front[j] = temp;
    }

    int filterNondominatedSet(double[][] front, int noPoints, int noObjectives) {
        int n = noPoints;
        block0: for (int i = 0; i < n; ++i) {
            int j = i + 1;
            while (j < n) {
                if (this.dominates(front[i], front[j], noObjectives)) {
                    this.swap(front, j, --n);
                    continue;
                }
                if (this.dominates(front[j], front[i], noObjectives)) {
                    this.swap(front, i, --n);
                    --i;
                    continue block0;
                }
                ++j;
            }
        }
        return n;
    }

    double surfaceUnchangedTo(double[][] front, int noPoints, int objective) {
        if (noPoints < 1) {
            System.err.println("run-time error");
        }
        double minValue = front[0][objective];
        for (int i = 1; i < noPoints; ++i) {
            double value = front[i][objective];
            if (!(value < minValue)) continue;
            minValue = value;
        }
        return minValue;
    }

    int reduceNondominatedSet(double[][] front, int noPoints, int objective, double threshold) {
        int n = noPoints;
        for (int i = 0; i < n; ++i) {
            if (!(front[i][objective] <= threshold)) continue;
            this.swap(front, i, --n);
        }
        return n;
    }

    public double calculateHypervolume(double[][] front, int noPoints, int noObjectives) {
        double volume = 0.0;
        double distance = 0.0;
        int n = noPoints;
        while (n > 0) {
            int noNondominatedPoints = this.filterNondominatedSet(front, n, noObjectives - 1);
            double tempVolume = 0.0;
            if (noObjectives < 3) {
                if (noNondominatedPoints < 1) {
                    System.err.println("run-time error");
                }
                tempVolume = front[0][0];
            } else {
                tempVolume = this.calculateHypervolume(front, noNondominatedPoints, noObjectives - 1);
            }
            double tempDistance = this.surfaceUnchangedTo(front, n, noObjectives - 1);
            volume += tempVolume * (tempDistance - distance);
            distance = tempDistance;
            n = this.reduceNondominatedSet(front, n, noObjectives - 1, distance);
        }
        return volume;
    }

    double[][] mergeFronts(double[][] front1, int sizeFront1, double[][] front2, int sizeFront2, int noObjectives) {
        int j;
        int i;
        int noPoints = sizeFront1 + sizeFront2;
        double[][] frontPtr = new double[noPoints][noObjectives];
        noPoints = 0;
        for (i = 0; i < sizeFront1; ++i) {
            for (j = 0; j < noObjectives; ++j) {
                frontPtr[noPoints][j] = front1[i][j];
            }
            ++noPoints;
        }
        for (i = 0; i < sizeFront2; ++i) {
            for (j = 0; j < noObjectives; ++j) {
                frontPtr[noPoints][j] = front2[i][j];
            }
            ++noPoints;
        }
        return frontPtr;
    }

    public double hypervolume(double[][] paretoFront, double[][] paretoTrueFront, int numberOfObjectives) {
        double[] maximumValues = this.utils_.getMaximumValues(paretoTrueFront, numberOfObjectives);
        double[] minimumValues = this.utils_.getMinimumValues(paretoTrueFront, numberOfObjectives);
        double[][] normalizedFront = this.utils_.getNormalizedFront(paretoFront, maximumValues, minimumValues);
        double[][] invertedFront = this.utils_.invertedFront(normalizedFront);
        return this.calculateHypervolume(invertedFront, invertedFront.length, numberOfObjectives);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Error using Hypervolume. Usage: \n java jmetal.qualityIndicator.Hypervolume <SolutionFrontFile> <TrueFrontFile> <numberOfObjectives>");
            System.exit(1);
        }
        Hypervolume qualityIndicator = new Hypervolume();
        double[][] solutionFront = qualityIndicator.utils_.readFront(args[0]);
        double[][] trueFront = qualityIndicator.utils_.readFront(args[1]);
        double value = qualityIndicator.hypervolume(solutionFront, trueFront, new Integer(args[2]));
        System.out.println(value);
    }
}

