/*
 * Decompiled with CFR 0.152.
 */
package jmetal.qualityIndicator;

import jmetal.qualityIndicator.util.MetricsUtil;

public class InvertedGenerationalDistance {
    public MetricsUtil utils_ = new MetricsUtil();
    static final double pow_ = 2.0;

    public double invertedGenerationalDistance(double[][] front, double[][] trueParetoFront, int numberOfObjectives) {
        double[] maximumValue = this.utils_.getMaximumValues(trueParetoFront, numberOfObjectives);
        double[] minimumValue = this.utils_.getMinimumValues(trueParetoFront, numberOfObjectives);
        double[][] normalizedFront = this.utils_.getNormalizedFront(front, maximumValue, minimumValue);
        double[][] normalizedParetoFront = this.utils_.getNormalizedFront(trueParetoFront, maximumValue, minimumValue);
        double sum = 0.0;
        for (int i = 0; i < normalizedParetoFront.length; ++i) {
            sum += Math.pow(this.utils_.distanceToClosedPoint(normalizedParetoFront[i], normalizedFront), 2.0);
        }
        sum = Math.pow(sum, 0.5);
        double generationalDistance = sum / (double)normalizedParetoFront.length;
        return generationalDistance;
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("InvertedGenerationalDistance::Main: Usage: java InvertedGenerationalDistance <FrontFile> <TrueFrontFile>  <numberOfObjectives>");
            System.exit(1);
        }
        InvertedGenerationalDistance qualityIndicator = new InvertedGenerationalDistance();
        double[][] solutionFront = qualityIndicator.utils_.readFront(args[0]);
        double[][] trueFront = qualityIndicator.utils_.readFront(args[1]);
        double value = qualityIndicator.invertedGenerationalDistance(solutionFront, trueFront, new Integer(args[2]));
        System.out.println(value);
    }
}

