/*
 * Decompiled with CFR 0.152.
 */
package jmetal.qualityIndicator.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.util.NonDominatedSolutionList;

public class MetricsUtil {
    public double[][] readFront(String path) {
        try {
            int i;
            FileInputStream fis = new FileInputStream(path);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            ArrayList<double[]> list = new ArrayList<double[]>();
            int numberOfObjectives = 0;
            String aux = br.readLine();
            while (aux != null) {
                StringTokenizer st = new StringTokenizer(aux);
                i = 0;
                numberOfObjectives = st.countTokens();
                double[] vector = new double[st.countTokens()];
                while (st.hasMoreTokens()) {
                    double value;
                    vector[i] = value = new Double(st.nextToken()).doubleValue();
                    ++i;
                }
                list.add(vector);
                aux = br.readLine();
            }
            br.close();
            double[][] front = new double[list.size()][numberOfObjectives];
            for (i = 0; i < list.size(); ++i) {
                front[i] = (double[])list.get(i);
            }
            return front;
        }
        catch (Exception e) {
            System.out.println("InputFacilities crashed reading for file: " + path);
            e.printStackTrace();
            return null;
        }
    }

    public double[] getMaximumValues(double[][] front, int noObjectives) {
        int i;
        double[] maximumValue = new double[noObjectives];
        for (i = 0; i < noObjectives; ++i) {
            maximumValue[i] = Double.NEGATIVE_INFINITY;
        }
        for (i = 0; i < front.length; ++i) {
            for (int j = 0; j < front[i].length; ++j) {
                if (!(front[i][j] > maximumValue[j])) continue;
                maximumValue[j] = front[i][j];
            }
        }
        return maximumValue;
    }

    public double[] getMinimumValues(double[][] front, int noObjectives) {
        int i;
        double[] minimumValue = new double[noObjectives];
        for (i = 0; i < noObjectives; ++i) {
            minimumValue[i] = Double.MAX_VALUE;
        }
        for (i = 0; i < front.length; ++i) {
            for (int j = 0; j < front[i].length; ++j) {
                if (!(front[i][j] < minimumValue[j])) continue;
                minimumValue[j] = front[i][j];
            }
        }
        return minimumValue;
    }

    public double distance(double[] a, double[] b) {
        double distance = 0.0;
        for (int i = 0; i < a.length; ++i) {
            distance += Math.pow(a[i] - b[i], 2.0);
        }
        return Math.sqrt(distance);
    }

    public double distanceToClosedPoint(double[] point, double[][] front) {
        double minDistance = this.distance(point, front[0]);
        for (int i = 1; i < front.length; ++i) {
            double aux = this.distance(point, front[i]);
            if (!(aux < minDistance)) continue;
            minDistance = aux;
        }
        return minDistance;
    }

    public double distanceToNearestPoint(double[] point, double[][] front) {
        double minDistance = Double.MAX_VALUE;
        for (int i = 0; i < front.length; ++i) {
            double aux = this.distance(point, front[i]);
            if (!(aux < minDistance) || !(aux > 0.0)) continue;
            minDistance = aux;
        }
        return minDistance;
    }

    public double[][] getNormalizedFront(double[][] front, double[] maximumValue, double[] minimumValue) {
        double[][] normalizedFront = new double[front.length][];
        for (int i = 0; i < front.length; ++i) {
            normalizedFront[i] = new double[front[i].length];
            for (int j = 0; j < front[i].length; ++j) {
                normalizedFront[i][j] = (front[i][j] - minimumValue[j]) / (maximumValue[j] - minimumValue[j]);
            }
        }
        return normalizedFront;
    }

    public double[][] invertedFront(double[][] front) {
        double[][] invertedFront = new double[front.length][];
        for (int i = 0; i < front.length; ++i) {
            invertedFront[i] = new double[front[i].length];
            for (int j = 0; j < front[i].length; ++j) {
                if (front[i][j] <= 1.0 && front[i][j] >= 0.0) {
                    invertedFront[i][j] = 1.0 - front[i][j];
                    continue;
                }
                if (front[i][j] > 1.0) {
                    invertedFront[i][j] = 0.0;
                    continue;
                }
                if (!(front[i][j] < 0.0)) continue;
                invertedFront[i][j] = 1.0;
            }
        }
        return invertedFront;
    }

    public SolutionSet readNonDominatedSolutionSet(String path) {
        try {
            FileInputStream fis = new FileInputStream(path);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            NonDominatedSolutionList solutionSet = new NonDominatedSolutionList();
            String aux = br.readLine();
            while (aux != null) {
                StringTokenizer st = new StringTokenizer(aux);
                int i = 0;
                Solution solution = new Solution(st.countTokens());
                while (st.hasMoreTokens()) {
                    double value = new Double(st.nextToken());
                    solution.setObjective(i, value);
                    ++i;
                }
                ((SolutionSet)solutionSet).add(solution);
                aux = br.readLine();
            }
            br.close();
            return solutionSet;
        }
        catch (Exception e) {
            System.out.println("jmetal.qualityIndicator.util.readNonDominatedSolutionSet: " + path);
            e.printStackTrace();
            return null;
        }
    }

    public void readNonDominatedSolutionSet(String path, NonDominatedSolutionList solutionSet) {
        try {
            FileInputStream fis = new FileInputStream(path);
            InputStreamReader isr = new InputStreamReader(fis);
            BufferedReader br = new BufferedReader(isr);
            String aux = br.readLine();
            while (aux != null) {
                StringTokenizer st = new StringTokenizer(aux);
                int i = 0;
                Solution solution = new Solution(st.countTokens());
                while (st.hasMoreTokens()) {
                    double value = new Double(st.nextToken());
                    solution.setObjective(i, value);
                    ++i;
                }
                solutionSet.add(solution);
                aux = br.readLine();
            }
            br.close();
        }
        catch (Exception e) {
            System.out.println("jmetal.qualityIndicator.util.readNonDominatedSolutionSet: " + path);
            e.printStackTrace();
        }
    }
}

