/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util;

import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.util.PseudoRandom;

public class AdaptiveGrid {
    private int bisections_;
    private int objectives_;
    private int[] hypercubes_;
    private double[] lowerLimits_;
    private double[] upperLimits_;
    private double[] divisionSize_;
    private int mostPopulated_;
    private int[] occupied_;

    public AdaptiveGrid(int bisections, int objetives) {
        this.bisections_ = bisections;
        this.objectives_ = objetives;
        this.lowerLimits_ = new double[this.objectives_];
        this.upperLimits_ = new double[this.objectives_];
        this.divisionSize_ = new double[this.objectives_];
        this.hypercubes_ = new int[(int)Math.pow(2.0, this.bisections_ * this.objectives_)];
        for (int i = 0; i < this.hypercubes_.length; ++i) {
            this.hypercubes_[i] = 0;
        }
    }

    private void updateLimits(SolutionSet solutionSet) {
        for (int obj = 0; obj < this.objectives_; ++obj) {
            this.lowerLimits_[obj] = Double.MAX_VALUE;
            this.upperLimits_[obj] = Double.MIN_VALUE;
        }
        for (int ind = 0; ind < solutionSet.size(); ++ind) {
            Solution tmpIndividual = solutionSet.get(ind);
            for (int obj = 0; obj < this.objectives_; ++obj) {
                if (tmpIndividual.getObjective(obj) < this.lowerLimits_[obj]) {
                    this.lowerLimits_[obj] = tmpIndividual.getObjective(obj);
                }
                if (!(tmpIndividual.getObjective(obj) > this.upperLimits_[obj])) continue;
                this.upperLimits_[obj] = tmpIndividual.getObjective(obj);
            }
        }
    }

    private void addSolutionSet(SolutionSet solutionSet) {
        this.mostPopulated_ = 0;
        for (int ind = 0; ind < solutionSet.size(); ++ind) {
            int location;
            int n = location = this.location(solutionSet.get(ind));
            this.hypercubes_[n] = this.hypercubes_[n] + 1;
            if (this.hypercubes_[location] <= this.hypercubes_[this.mostPopulated_]) continue;
            this.mostPopulated_ = location;
        }
        this.calculateOccupied();
    }

    public void updateGrid(SolutionSet solutionSet) {
        this.updateLimits(solutionSet);
        for (int obj = 0; obj < this.objectives_; ++obj) {
            this.divisionSize_[obj] = this.upperLimits_[obj] - this.lowerLimits_[obj];
        }
        for (int i = 0; i < this.hypercubes_.length; ++i) {
            this.hypercubes_[i] = 0;
        }
        this.addSolutionSet(solutionSet);
    }

    public void updateGrid(Solution solution, SolutionSet solutionSet) {
        int location = this.location(solution);
        if (location == -1) {
            int obj;
            this.updateLimits(solutionSet);
            for (obj = 0; obj < this.objectives_; ++obj) {
                if (solution.getObjective(obj) < this.lowerLimits_[obj]) {
                    this.lowerLimits_[obj] = solution.getObjective(obj);
                }
                if (!(solution.getObjective(obj) > this.upperLimits_[obj])) continue;
                this.upperLimits_[obj] = solution.getObjective(obj);
            }
            for (obj = 0; obj < this.objectives_; ++obj) {
                this.divisionSize_[obj] = this.upperLimits_[obj] - this.lowerLimits_[obj];
            }
            for (int i = 0; i < this.hypercubes_.length; ++i) {
                this.hypercubes_[i] = 0;
            }
            this.addSolutionSet(solutionSet);
        }
    }

    public int location(Solution solution) {
        int[] position = new int[this.objectives_];
        for (int obj = 0; obj < this.objectives_; ++obj) {
            if (solution.getObjective(obj) > this.upperLimits_[obj] || solution.getObjective(obj) < this.lowerLimits_[obj]) {
                return -1;
            }
            if (solution.getObjective(obj) == this.lowerLimits_[obj]) {
                position[obj] = 0;
                continue;
            }
            if (solution.getObjective(obj) == this.upperLimits_[obj]) {
                position[obj] = (int)Math.pow(2.0, this.bisections_) - 1;
                continue;
            }
            double tmpSize = this.divisionSize_[obj];
            double value = solution.getObjective(obj);
            double account = this.lowerLimits_[obj];
            int ranges = (int)Math.pow(2.0, this.bisections_);
            for (int b = 0; b < this.bisections_; ++b) {
                tmpSize /= 2.0;
                ranges /= 2;
                if (!(value > account + tmpSize)) continue;
                int n = obj;
                position[n] = position[n] + ranges;
                account += tmpSize;
            }
        }
        int location = 0;
        for (int obj = 0; obj < this.objectives_; ++obj) {
            location = (int)((double)location + (double)position[obj] * Math.pow(2.0, obj * this.bisections_));
        }
        return location;
    }

    public int getMostPopulated() {
        return this.mostPopulated_;
    }

    public int getLocationDensity(int location) {
        return this.hypercubes_[location];
    }

    public void removeSolution(int location) {
        int n = location;
        this.hypercubes_[n] = this.hypercubes_[n] - 1;
        if (location == this.mostPopulated_) {
            for (int i = 0; i < this.hypercubes_.length; ++i) {
                if (this.hypercubes_[i] <= this.hypercubes_[this.mostPopulated_]) continue;
                this.mostPopulated_ = i;
            }
        }
        if (this.hypercubes_[location] == 0) {
            this.calculateOccupied();
        }
    }

    public void addSolution(int location) {
        int n = location;
        this.hypercubes_[n] = this.hypercubes_[n] + 1;
        if (this.hypercubes_[location] > this.hypercubes_[this.mostPopulated_]) {
            this.mostPopulated_ = location;
        }
        if (this.hypercubes_[location] == 1) {
            this.calculateOccupied();
        }
    }

    public int getBisections() {
        return this.bisections_;
    }

    public String toString() {
        String result = "Grid\n";
        for (int obj = 0; obj < this.objectives_; ++obj) {
            result = result + "Objective " + obj + " " + this.lowerLimits_[obj] + " " + this.upperLimits_[obj] + "\n";
        }
        return result;
    }

    public int rouletteWheel() {
        int hypercube;
        double inverseSum = 0.0;
        for (int i = 0; i < this.hypercubes_.length; ++i) {
            if (this.hypercubes_[i] <= 0) continue;
            inverseSum += 1.0 / (double)this.hypercubes_[i];
        }
        double random = PseudoRandom.randDouble(0.0, inverseSum);
        double accumulatedSum = 0.0;
        for (hypercube = 0; hypercube < this.hypercubes_.length; ++hypercube) {
            if (this.hypercubes_[hypercube] > 0) {
                accumulatedSum += 1.0 / (double)this.hypercubes_[hypercube];
            }
            if (!(accumulatedSum > random)) continue;
            return hypercube;
        }
        return hypercube;
    }

    public int calculateOccupied() {
        int total = 0;
        for (int i = 0; i < this.hypercubes_.length; ++i) {
            if (this.hypercubes_[i] <= 0) continue;
            ++total;
        }
        this.occupied_ = new int[total];
        int base = 0;
        for (int i = 0; i < this.hypercubes_.length; ++i) {
            if (this.hypercubes_[i] <= 0) continue;
            this.occupied_[base] = i;
            ++base;
        }
        return total;
    }

    public int occupiedHypercubes() {
        return this.occupied_.length;
    }

    public int randomOccupiedHypercube() {
        int rand = PseudoRandom.randInt(0, this.occupied_.length - 1);
        return this.occupied_[rand];
    }
}

