/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util;

import jmetal.core.Solution;
import jmetal.core.SolutionSet;
import jmetal.core.Variable;
import jmetal.util.JMException;
import jmetal.util.comparators.ObjectiveComparator;

public class Distance {
    public double[][] distanceMatrix(SolutionSet solutionSet) {
        double[][] distance = new double[solutionSet.size()][solutionSet.size()];
        for (int i = 0; i < solutionSet.size(); ++i) {
            distance[i][i] = 0.0;
            Solution solutionI = solutionSet.get(i);
            for (int j = i + 1; j < solutionSet.size(); ++j) {
                Solution solutionJ = solutionSet.get(j);
                distance[i][j] = this.distanceBetweenObjectives(solutionI, solutionJ);
                distance[j][i] = distance[i][j];
            }
        }
        return distance;
    }

    public double distanceToSolutionSetInObjectiveSpace(Solution solution, SolutionSet solutionSet) throws JMException {
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < solutionSet.size(); ++i) {
            double aux = this.distanceBetweenObjectives(solution, solutionSet.get(i));
            if (!(aux < distance)) continue;
            distance = aux;
        }
        return distance;
    }

    public double distanceToSolutionSetInSolutionSpace(Solution solution, SolutionSet solutionSet) throws JMException {
        double distance = Double.MAX_VALUE;
        for (int i = 0; i < solutionSet.size(); ++i) {
            double aux = this.distanceBetweenSolutions(solution, solutionSet.get(i));
            if (!(aux < distance)) continue;
            distance = aux;
        }
        return distance;
    }

    public double distanceBetweenSolutions(Solution solutionI, Solution solutionJ) throws JMException {
        double distance = 0.0;
        if (solutionI.getDecisionVariables() != null && solutionJ.getDecisionVariables() != null) {
            Variable[] decisionVariableI = solutionI.getDecisionVariables();
            Variable[] decisionVariableJ = solutionJ.getDecisionVariables();
            for (int i = 0; i < decisionVariableI.length; ++i) {
                double diff = decisionVariableI[i].getValue() - decisionVariableJ[i].getValue();
                distance += Math.pow(diff, 2.0);
            }
        }
        return Math.sqrt(distance);
    }

    public double distanceBetweenObjectives(Solution solutionI, Solution solutionJ) {
        double distance = 0.0;
        for (int nObj = 0; nObj < solutionI.numberOfObjectives(); ++nObj) {
            double diff = solutionI.getObjective(nObj) - solutionJ.getObjective(nObj);
            distance += Math.pow(diff, 2.0);
        }
        return Math.sqrt(distance);
    }

    public void crowdingDistanceAssignment(SolutionSet solutionSet, int nObjs) {
        int i;
        int size = solutionSet.size();
        if (size == 0) {
            return;
        }
        if (size == 1) {
            solutionSet.get(0).setCrowdingDistance(Double.POSITIVE_INFINITY);
            return;
        }
        if (size == 2) {
            solutionSet.get(0).setCrowdingDistance(Double.POSITIVE_INFINITY);
            solutionSet.get(1).setCrowdingDistance(Double.POSITIVE_INFINITY);
            return;
        }
        SolutionSet front = new SolutionSet(size);
        for (i = 0; i < size; ++i) {
            front.add(solutionSet.get(i));
        }
        for (i = 0; i < size; ++i) {
            front.get(i).setCrowdingDistance(0.0);
        }
        for (int i2 = 0; i2 < nObjs; ++i2) {
            front.sort(new ObjectiveComparator(i2));
            double objetiveMinn = front.get(0).getObjective(i2);
            double objetiveMaxn = front.get(front.size() - 1).getObjective(i2);
            front.get(0).setCrowdingDistance(Double.POSITIVE_INFINITY);
            front.get(size - 1).setCrowdingDistance(Double.POSITIVE_INFINITY);
            for (int j = 1; j < size - 1; ++j) {
                double distance = front.get(j + 1).getObjective(i2) - front.get(j - 1).getObjective(i2);
                distance /= objetiveMaxn - objetiveMinn;
                front.get(j).setCrowdingDistance(distance += front.get(j).getCrowdingDistance());
            }
        }
    }
}

