/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.StringTokenizer;

public class ExtractParetoFront {
    String fileName_;
    int dimensions_;
    List<Point> points_ = new LinkedList<Point>();

    public ExtractParetoFront(String name, int dimensions) {
        this.fileName_ = name;
        this.dimensions_ = dimensions;
        this.loadInstance();
    }

    public void loadInstance() {
        try {
            File archivo = new File(this.fileName_);
            FileReader fr = null;
            BufferedReader br = null;
            fr = new FileReader(archivo);
            br = new BufferedReader(fr);
            int lineCnt = 0;
            String line = br.readLine();
            while (line != null) {
                StringTokenizer st = new StringTokenizer(line);
                try {
                    Point auxPoint = new Point(this.dimensions_);
                    for (int i = 0; i < this.dimensions_; ++i) {
                        auxPoint.vector_[i] = new Double(st.nextToken());
                    }
                    this.add(auxPoint);
                    line = br.readLine();
                    ++lineCnt;
                }
                catch (NumberFormatException e) {
                    System.err.println("Number in a wrong format in line " + lineCnt);
                    System.err.println(line);
                    line = br.readLine();
                    ++lineCnt;
                }
                catch (NoSuchElementException e2) {
                    System.err.println("Line " + lineCnt + " does not have the right number of objectives");
                    System.err.println(line);
                    line = br.readLine();
                    ++lineCnt;
                }
            }
            br.close();
        }
        catch (FileNotFoundException e3) {
            System.err.println("The file " + this.fileName_ + " has not been found in your file system");
        }
        catch (IOException e3) {
            System.err.println("The file " + this.fileName_ + " has not been found in your file system");
        }
    }

    public void add(Point point) {
        Iterator<Point> iterator = this.points_.iterator();
        while (iterator.hasNext()) {
            Point auxPoint = iterator.next();
            int flag = this.compare(point, auxPoint);
            if (flag == -1) {
                iterator.remove();
                continue;
            }
            if (flag != 1) continue;
            return;
        }
        this.points_.add(point);
    }

    public int compare(Point one, Point two) {
        boolean flag1 = false;
        boolean flag2 = false;
        for (int i = 0; i < this.dimensions_; ++i) {
            if (one.vector_[i] < two.vector_[i]) {
                flag1 = true;
            }
            if (!(one.vector_[i] > two.vector_[i])) continue;
            flag2 = true;
        }
        if (flag1 > flag2) {
            return -1;
        }
        if (flag2 > flag1) {
            return 1;
        }
        return 0;
    }

    public void writeParetoFront() {
        try {
            FileOutputStream fos = new FileOutputStream(this.fileName_ + ".pf");
            OutputStreamWriter osw = new OutputStreamWriter(fos);
            BufferedWriter bw = new BufferedWriter(osw);
            for (Point auxPoint : this.points_) {
                String aux = "";
                for (int i = 0; i < auxPoint.vector_.length; ++i) {
                    aux = aux + auxPoint.vector_[i] + " ";
                }
                bw.write(aux);
                bw.newLine();
            }
            bw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.out.println("Wrong number of arguments: ");
            System.out.println("Sintaxt: java ExtractParetoFront <file> <dimensions>");
            System.out.println("\t<file> is a file containing points");
            System.out.println("\t<dimensions> represents the number of dimensions of the problem");
            System.exit(-1);
        }
        ExtractParetoFront epf = new ExtractParetoFront(args[0], new Integer(args[1]));
        epf.writeParetoFront();
    }

    private class Point {
        double[] vector_;

        public Point(double[] vector) {
            this.vector_ = vector;
        }

        public Point(int size) {
            this.vector_ = new double[size];
            for (int i = 0; i < size; ++i) {
                this.vector_[i] = 0.0;
            }
        }
    }
}

