/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util;

import java.util.Comparator;
import jmetal.core.Problem;
import jmetal.core.SolutionSet;
import jmetal.util.comparators.DominanceComparator;

public class FPGAFitness {
    private SolutionSet solutionSet_ = null;
    private Problem problem_ = null;
    private static final Comparator dominance_ = new DominanceComparator();

    public FPGAFitness(SolutionSet solutionSet, Problem problem) {
        this.solutionSet_ = solutionSet;
        this.problem_ = problem;
        for (int i = 0; i < this.solutionSet_.size(); ++i) {
            this.solutionSet_.get(i).setLocation(i);
        }
    }

    public void fitnessAssign() {
        int i;
        double[] strength = new double[this.solutionSet_.size()];
        double[] rawFitness = new double[this.solutionSet_.size()];
        for (i = 0; i < this.solutionSet_.size(); ++i) {
            if (this.solutionSet_.get(i).getRank() != 0) continue;
            this.solutionSet_.get(i).setFitness(this.solutionSet_.get(i).getCrowdingDistance());
        }
        for (i = 0; i < this.solutionSet_.size(); ++i) {
            for (int j = 0; j < this.solutionSet_.size(); ++j) {
                if (dominance_.compare(this.solutionSet_.get(i), this.solutionSet_.get(j)) != -1) continue;
                int n = i;
                strength[n] = strength[n] + 1.0;
            }
        }
        for (i = 0; i < this.solutionSet_.size(); ++i) {
            double fitness = 0.0;
            for (int j = 0; j < this.solutionSet_.size(); ++j) {
                int flag = dominance_.compare(this.solutionSet_.get(i), this.solutionSet_.get(j));
                if (flag == -1) {
                    fitness += strength[j];
                    continue;
                }
                if (flag != 1) continue;
                fitness -= strength[j];
            }
        }
    }
}

