/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util;

import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import jmetal.core.SolutionSet;
import jmetal.util.comparators.DominanceComparator;
import jmetal.util.comparators.OverallConstraintViolationComparator;

public class Ranking {
    private SolutionSet solutionSet_;
    private SolutionSet[] ranking_;
    private static final Comparator dominance_ = new DominanceComparator();
    private static final Comparator constraint_ = new OverallConstraintViolationComparator();

    public Ranking(SolutionSet solutionSet) {
        int p;
        int i;
        this.solutionSet_ = solutionSet;
        int[] dominateMe = new int[this.solutionSet_.size()];
        List[] iDominate = new List[this.solutionSet_.size()];
        List[] front = new List[this.solutionSet_.size() + 1];
        for (i = 0; i < front.length; ++i) {
            front[i] = new LinkedList();
        }
        for (p = 0; p < this.solutionSet_.size(); ++p) {
            iDominate[p] = new LinkedList();
            dominateMe[p] = 0;
        }
        for (p = 0; p < this.solutionSet_.size() - 1; ++p) {
            for (int q = p + 1; q < this.solutionSet_.size(); ++q) {
                int flagDominate = constraint_.compare(solutionSet.get(p), solutionSet.get(q));
                if (flagDominate == 0) {
                    flagDominate = dominance_.compare(solutionSet.get(p), solutionSet.get(q));
                }
                if (flagDominate == -1) {
                    iDominate[p].add(new Integer(q));
                    int n = q;
                    dominateMe[n] = dominateMe[n] + 1;
                    continue;
                }
                if (flagDominate != 1) continue;
                iDominate[q].add(new Integer(p));
                int n = p;
                dominateMe[n] = dominateMe[n] + 1;
            }
        }
        for (p = 0; p < this.solutionSet_.size(); ++p) {
            if (dominateMe[p] != 0) continue;
            front[0].add(new Integer(p));
            solutionSet.get(p).setRank(0);
        }
        i = 0;
        while (front[i].size() != 0) {
            Iterator it1 = front[++i - 1].iterator();
            while (it1.hasNext()) {
                Iterator it2 = iDominate[(Integer)it1.next()].iterator();
                while (it2.hasNext()) {
                    int index;
                    int n = index = ((Integer)it2.next()).intValue();
                    dominateMe[n] = dominateMe[n] - 1;
                    if (dominateMe[index] != 0) continue;
                    front[i].add(new Integer(index));
                    this.solutionSet_.get(index).setRank(i);
                }
            }
        }
        this.ranking_ = new SolutionSet[i];
        for (int j = 0; j < i; ++j) {
            this.ranking_[j] = new SolutionSet(front[j].size());
            Iterator it1 = front[j].iterator();
            while (it1.hasNext()) {
                this.ranking_[j].add(solutionSet.get((Integer)it1.next()));
            }
        }
    }

    public SolutionSet getSubfront(int rank) {
        return this.ranking_[rank];
    }

    public int getNumberOfSubfronts() {
        return this.ranking_.length;
    }
}

