/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util.comparators;

import java.util.Comparator;
import jmetal.core.Solution;
import jmetal.util.comparators.OverallConstraintViolationComparator;

public class DominanceComparator
implements Comparator {
    private static final Comparator overallConstraintViolationComparator_ = new OverallConstraintViolationComparator();

    public int compare(Object object1, Object object2) {
        if (object1 == null) {
            return 1;
        }
        if (object2 == null) {
            return -1;
        }
        Solution solution1 = (Solution)object1;
        Solution solution2 = (Solution)object2;
        boolean dominate1 = false;
        boolean dominate2 = false;
        if (solution1.getOverallConstraintViolation() != solution2.getOverallConstraintViolation() && solution1.getOverallConstraintViolation() < 0.0 || solution2.getOverallConstraintViolation() < 0.0) {
            return overallConstraintViolationComparator_.compare(solution1, solution2);
        }
        for (int i = 0; i < solution1.numberOfObjectives(); ++i) {
            double value2;
            double value1 = solution1.getObjective(i);
            int flag = value1 < (value2 = solution2.getObjective(i)) ? -1 : (value1 > value2 ? 1 : 0);
            if (flag == -1) {
                dominate1 = true;
            }
            if (flag != 1) continue;
            dominate2 = true;
        }
        if (dominate1 == dominate2) {
            return 0;
        }
        if (dominate1) {
            return -1;
        }
        return 1;
    }
}

