/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util.comparators;

import java.util.Comparator;
import jmetal.core.Solution;
import jmetal.util.Configuration;
import jmetal.util.Distance;
import jmetal.util.JMException;

public class SolutionComparator
implements Comparator {
    private static final double EPSILON = 1.0E-10;

    public int compare(Object o1, Object o2) {
        Solution solution1 = (Solution)o1;
        Solution solution2 = (Solution)o2;
        if (solution1.getDecisionVariables() != null && solution1.getDecisionVariables() != null && solution1.numberOfVariables() != solution2.numberOfVariables()) {
            return -1;
        }
        try {
            Distance distance = new Distance();
            if (distance.distanceBetweenSolutions(solution1, solution2) < 1.0E-10) {
                return 0;
            }
        }
        catch (JMException e) {
            Configuration.logger_.severe("SolutionComparator.compare: JMException ");
        }
        return -1;
    }
}

