/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util.parallel;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import jmetal.core.Problem;
import jmetal.core.Solution;
import jmetal.util.Configuration;
import jmetal.util.parallel.IParallelEvaluator;

public class MultithreadedEvaluator
implements IParallelEvaluator {
    private int numberOfThreads_;
    private Problem problem_;
    private ExecutorService executor_;
    private Collection<Callable<Solution>> taskList_;

    public MultithreadedEvaluator(int threads) {
        this.numberOfThreads_ = threads;
        if (threads == 0) {
            this.numberOfThreads_ = Runtime.getRuntime().availableProcessors();
        } else if (threads < 0) {
            Configuration.logger_.severe("MultithreadedEvaluator: the number of threads cannot be negative number " + threads);
        } else {
            this.numberOfThreads_ = threads;
        }
    }

    @Override
    public void startEvaluator(Problem problem) {
        this.executor_ = Executors.newFixedThreadPool(this.numberOfThreads_);
        System.out.println("Cores: " + this.numberOfThreads_);
        this.taskList_ = null;
        this.problem_ = problem;
    }

    @Override
    public void addSolutionForEvaluation(Solution solution) {
        if (this.taskList_ == null) {
            this.taskList_ = new ArrayList<Callable<Solution>>();
        }
        this.taskList_.add(new EvaluationTask(this.problem_, solution));
    }

    @Override
    public List<Solution> parallelEvaluation() {
        List<Future<Solution>> future = null;
        try {
            future = this.executor_.invokeAll(this.taskList_);
        }
        catch (InterruptedException e1) {
            e1.printStackTrace();
        }
        Vector<Solution> solutionList = new Vector<Solution>();
        for (Future<Solution> result : future) {
            Solution solution = null;
            try {
                solution = result.get();
                solutionList.add(solution);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
            catch (ExecutionException e) {
                e.printStackTrace();
            }
        }
        this.taskList_ = null;
        return solutionList;
    }

    @Override
    public void stopEvaluator() {
        this.executor_.shutdown();
    }

    private class EvaluationTask
    implements Callable<Solution> {
        private Problem problem_;
        private Solution solution_;

        public EvaluationTask(Problem problem, Solution solution) {
            this.problem_ = problem;
            this.solution_ = solution;
        }

        @Override
        public Solution call() throws Exception {
            long initTime = System.currentTimeMillis();
            this.problem_.evaluate(this.solution_);
            this.problem_.evaluateConstraints(this.solution_);
            long estimatedTime = System.currentTimeMillis() - initTime;
            return this.solution_;
        }
    }
}

