/*
 * Decompiled with CFR 0.152.
 */
package jmetal.util.wrapper;

import jmetal.core.Solution;
import jmetal.core.SolutionType;
import jmetal.encodings.solutionType.ArrayRealAndBinarySolutionType;
import jmetal.encodings.solutionType.ArrayRealSolutionType;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.encodings.variable.ArrayReal;
import jmetal.util.Configuration;
import jmetal.util.JMException;

public class XReal {
    Solution solution_;
    SolutionType type_;

    public XReal() {
    }

    public XReal(Solution solution) {
        this();
        this.type_ = solution.getType();
        this.solution_ = solution;
    }

    public double getValue(int index) throws JMException {
        if (this.type_.getClass() == RealSolutionType.class || this.type_.getClass() == BinaryRealSolutionType.class) {
            return this.solution_.getDecisionVariables()[index].getValue();
        }
        if (this.type_.getClass() == ArrayRealSolutionType.class) {
            return ((ArrayReal)this.solution_.getDecisionVariables()[0]).array_[index];
        }
        if (this.type_.getClass() == ArrayRealAndBinarySolutionType.class) {
            return ((ArrayReal)this.solution_.getDecisionVariables()[0]).array_[index];
        }
        Configuration.logger_.severe("jmetal.util.wrapper.XReal.getValue, solution type " + this.type_ + "+ invalid");
        return 0.0;
    }

    public void setValue(int index, double value) throws JMException {
        if (this.type_.getClass() == RealSolutionType.class) {
            this.solution_.getDecisionVariables()[index].setValue(value);
        } else if (this.type_.getClass() == ArrayRealSolutionType.class) {
            ((ArrayReal)this.solution_.getDecisionVariables()[0]).array_[index] = value;
        } else if (this.type_.getClass() == ArrayRealAndBinarySolutionType.class) {
            ((ArrayReal)this.solution_.getDecisionVariables()[0]).array_[index] = value;
        } else {
            Configuration.logger_.severe("jmetal.util.wrapper.XReal.setValue, solution type " + this.type_ + "+ invalid");
        }
    }

    public double getLowerBound(int index) throws JMException {
        if (this.type_.getClass() == RealSolutionType.class || this.type_.getClass() == BinaryRealSolutionType.class) {
            return this.solution_.getDecisionVariables()[index].getLowerBound();
        }
        if (this.type_.getClass() == ArrayRealSolutionType.class) {
            return ((ArrayReal)this.solution_.getDecisionVariables()[0]).getLowerBound(index);
        }
        if (this.type_.getClass() == ArrayRealAndBinarySolutionType.class) {
            return ((ArrayReal)this.solution_.getDecisionVariables()[0]).getLowerBound(index);
        }
        Configuration.logger_.severe("jmetal.util.wrapper.XReal.getLowerBound, solution type " + this.type_ + "+ invalid");
        return 0.0;
    }

    public double getUpperBound(int index) throws JMException {
        if (this.type_.getClass() == RealSolutionType.class || this.type_.getClass() == BinaryRealSolutionType.class) {
            return this.solution_.getDecisionVariables()[index].getUpperBound();
        }
        if (this.type_.getClass() == ArrayRealSolutionType.class) {
            return ((ArrayReal)this.solution_.getDecisionVariables()[0]).getUpperBound(index);
        }
        if (this.type_.getClass() == ArrayRealAndBinarySolutionType.class) {
            return ((ArrayReal)this.solution_.getDecisionVariables()[0]).getUpperBound(index);
        }
        Configuration.logger_.severe("jmetal.util.wrapper.XReal.getUpperBound, solution type " + this.type_ + "+ invalid");
        return 0.0;
    }

    public int getNumberOfDecisionVariables() {
        if (this.type_.getClass() == RealSolutionType.class || this.type_.getClass() == BinaryRealSolutionType.class) {
            return this.solution_.getDecisionVariables().length;
        }
        if (this.type_.getClass() == ArrayRealSolutionType.class) {
            return ((ArrayReal)this.solution_.getDecisionVariables()[0]).getLength();
        }
        Configuration.logger_.severe("jmetal.util.wrapper.XReal.size, solution type " + this.type_ + "+ invalid");
        return 0;
    }

    public int size() {
        if (this.type_.getClass().equals(RealSolutionType.class) || this.type_.getClass().equals(BinaryRealSolutionType.class)) {
            return this.solution_.getDecisionVariables().length;
        }
        if (this.type_.getClass().equals(ArrayRealSolutionType.class)) {
            return ((ArrayReal)this.solution_.getDecisionVariables()[0]).getLength();
        }
        Configuration.logger_.severe("jmetal.util.wrapper.XReal.size, solution type " + this.type_ + "+ invalid");
        return 0;
    }
}

