/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.math3.stat.descriptive.UnivariateStatistic;
import org.apache.commons.math3.stat.descriptive.rank.Max;
import org.apache.commons.math3.stat.descriptive.rank.Median;
import org.apache.commons.math3.stat.descriptive.rank.Min;
import org.moeaframework.ProblemBuilder;
import org.moeaframework.analysis.sensitivity.ResultEntry;
import org.moeaframework.analysis.sensitivity.ResultFileReader;
import org.moeaframework.analysis.sensitivity.ResultFileWriter;
import org.moeaframework.core.Indicator;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.PopulationIO;
import org.moeaframework.core.Problem;
import org.moeaframework.core.indicator.AdditiveEpsilonIndicator;
import org.moeaframework.core.indicator.Contribution;
import org.moeaframework.core.indicator.GenerationalDistance;
import org.moeaframework.core.indicator.Hypervolume;
import org.moeaframework.core.indicator.InvertedGenerationalDistance;
import org.moeaframework.core.indicator.MaximumParetoFrontError;
import org.moeaframework.core.indicator.R1Indicator;
import org.moeaframework.core.indicator.R2Indicator;
import org.moeaframework.core.indicator.R3Indicator;
import org.moeaframework.core.indicator.Spacing;
import org.moeaframework.core.spi.ProblemFactory;
import org.moeaframework.util.io.FileUtils;
import org.moeaframework.util.statistics.KruskalWallisTest;
import org.moeaframework.util.statistics.MannWhitneyUTest;

public class Analyzer
extends ProblemBuilder {
    private boolean includeHypervolume;
    private boolean includeGenerationalDistance;
    private boolean includeInvertedGenerationalDistance;
    private boolean includeAdditiveEpsilonIndicator;
    private boolean includeSpacing;
    private boolean includeMaximumParetoFrontError;
    private boolean includeContribution;
    private boolean includeR1;
    private boolean includeR2;
    private boolean includeR3;
    private boolean showIndividualValues;
    private boolean showAggregate;
    private boolean showStatisticalSignificance;
    private double significanceLevel = 0.05;
    private List<UnivariateStatistic> statistics = new ArrayList<UnivariateStatistic>();
    private double[] idealPoint;
    private double[] referencePoint;
    private Map<String, List<NondominatedPopulation>> data = new HashMap<String, List<NondominatedPopulation>>();

    @Override
    public Analyzer withSameProblemAs(ProblemBuilder builder) {
        return (Analyzer)super.withSameProblemAs(builder);
    }

    @Override
    public Analyzer usingProblemFactory(ProblemFactory problemFactory) {
        return (Analyzer)super.usingProblemFactory(problemFactory);
    }

    @Override
    public Analyzer withProblem(String problemName) {
        return (Analyzer)super.withProblem(problemName);
    }

    @Override
    public Analyzer withProblem(Problem problemInstance) {
        return (Analyzer)super.withProblem(problemInstance);
    }

    @Override
    public Analyzer withProblemClass(Class<?> problemClass, Object ... problemArguments) {
        return (Analyzer)super.withProblemClass(problemClass, problemArguments);
    }

    @Override
    public Analyzer withProblemClass(String problemClassName, Object ... problemArguments) throws ClassNotFoundException {
        return (Analyzer)super.withProblemClass(problemClassName, problemArguments);
    }

    @Override
    public Analyzer withEpsilon(double ... epsilon) {
        return (Analyzer)super.withEpsilon(epsilon);
    }

    @Override
    public Analyzer withReferenceSet(File referenceSetFile) {
        return (Analyzer)super.withReferenceSet(referenceSetFile);
    }

    public Analyzer includeHypervolume() {
        this.includeHypervolume = true;
        return this;
    }

    public Analyzer includeGenerationalDistance() {
        this.includeGenerationalDistance = true;
        return this;
    }

    public Analyzer includeInvertedGenerationalDistance() {
        this.includeInvertedGenerationalDistance = true;
        return this;
    }

    public Analyzer includeAdditiveEpsilonIndicator() {
        this.includeAdditiveEpsilonIndicator = true;
        return this;
    }

    public Analyzer includeMaximumParetoFrontError() {
        this.includeMaximumParetoFrontError = true;
        return this;
    }

    public Analyzer includeSpacing() {
        this.includeSpacing = true;
        return this;
    }

    public Analyzer includeContribution() {
        this.includeContribution = true;
        return this;
    }

    public Analyzer includeR1() {
        this.includeR1 = true;
        return this;
    }

    public Analyzer includeR2() {
        this.includeR2 = true;
        return this;
    }

    public Analyzer includeR3() {
        this.includeR3 = true;
        return this;
    }

    public Analyzer includeAllMetrics() {
        this.includeHypervolume();
        this.includeGenerationalDistance();
        this.includeInvertedGenerationalDistance();
        this.includeAdditiveEpsilonIndicator();
        this.includeMaximumParetoFrontError();
        this.includeSpacing();
        this.includeContribution();
        this.includeR1();
        this.includeR2();
        this.includeR3();
        return this;
    }

    public Analyzer showAll() {
        this.showIndividualValues();
        this.showAggregate();
        this.showStatisticalSignificance();
        return this;
    }

    public Analyzer showIndividualValues() {
        this.showIndividualValues = true;
        return this;
    }

    public Analyzer showAggregate() {
        this.showAggregate = true;
        return this;
    }

    public Analyzer showStatisticalSignificance() {
        this.showStatisticalSignificance = true;
        return this;
    }

    public Analyzer showStatistic(UnivariateStatistic statistic) {
        this.statistics.add(statistic);
        return this;
    }

    public Analyzer withSignifianceLevel(double significanceLevel) {
        this.significanceLevel = significanceLevel;
        return this;
    }

    public Analyzer withIdealPoint(double ... idealPoint) {
        this.idealPoint = idealPoint;
        return this;
    }

    public Analyzer withReferencePoint(double ... referencePoint) {
        this.referencePoint = referencePoint;
        return this;
    }

    public Analyzer addAll(String name, Collection<NondominatedPopulation> results) {
        for (NondominatedPopulation result : results) {
            this.add(name, result);
        }
        return this;
    }

    public Analyzer add(String name, NondominatedPopulation result) {
        List<NondominatedPopulation> list = this.data.get(name);
        if (list == null) {
            list = new ArrayList<NondominatedPopulation>();
            this.data.put(name, list);
        }
        list.add(result);
        return this;
    }

    public Analyzer saveData(File directory, String prefix, String suffix) throws IOException {
        FileUtils.mkdir(directory);
        for (String algorithm : this.data.keySet()) {
            this.saveAs(algorithm, new File(directory, prefix + algorithm + suffix));
        }
        return this;
    }

    public Analyzer loadData(File directory, String prefix, String suffix) throws IOException {
        for (File file : directory.listFiles()) {
            String filename = file.getName();
            if (!filename.startsWith(prefix) || !filename.endsWith(suffix)) continue;
            String name = filename.substring(prefix.length(), filename.length() - suffix.length());
            this.loadAs(name, file);
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Analyzer loadAs(String name, File resultFile) throws IOException {
        Problem problem = null;
        ResultFileReader reader = null;
        try {
            problem = this.getProblemInstance();
            try {
                reader = new ResultFileReader(problem, resultFile);
                while (reader.hasNext()) {
                    this.add(name, reader.next().getPopulation());
                }
            }
            finally {
                if (reader != null) {
                    reader.close();
                }
            }
        }
        finally {
            if (problem != null && problem != this.problemInstance) {
                problem.close();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Analyzer saveAs(String name, File resultFile) throws IOException {
        Problem problem = null;
        ResultFileWriter writer = null;
        try {
            problem = this.getProblemInstance();
            FileUtils.delete(resultFile);
            try {
                writer = new ResultFileWriter(problem, resultFile);
                if (name == null) {
                    writer.append(new ResultEntry(this.getReferenceSet()));
                } else {
                    for (NondominatedPopulation result : this.data.get(name)) {
                        writer.append(new ResultEntry(result));
                    }
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        finally {
            if (problem != null && problem != this.problemInstance) {
                problem.close();
            }
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Analyzer saveAnalysis(File file) throws IOException {
        PrintStream ps = null;
        try {
            ps = new PrintStream(new BufferedOutputStream(new FileOutputStream(file)));
            this.printAnalysis(ps);
        }
        finally {
            if (ps != null) {
                ps.close();
            }
        }
        return this;
    }

    public Analyzer printAnalysis() {
        this.printAnalysis(System.out);
        return this;
    }

    public Analyzer saveReferenceSet(File file) throws IOException {
        PopulationIO.writeObjectives(file, this.getReferenceSet());
        return this;
    }

    @Override
    public NondominatedPopulation getReferenceSet() {
        try {
            return super.getReferenceSet();
        }
        catch (IllegalArgumentException e) {
            if (this.referenceSetFile == null) {
                NondominatedPopulation referenceSet = this.newArchive();
                for (List<NondominatedPopulation> entry : this.data.values()) {
                    for (NondominatedPopulation set : entry) {
                        referenceSet.addAll(set);
                    }
                }
                return referenceSet;
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AnalyzerResults getAnalysis() {
        if (this.data.isEmpty()) {
            return new AnalyzerResults();
        }
        Problem problem = null;
        try {
            double[] values;
            problem = this.getProblemInstance();
            NondominatedPopulation referenceSet = this.getReferenceSet();
            ArrayList<Indicator> indicators = new ArrayList<Indicator>();
            if (this.includeHypervolume) {
                if (this.idealPoint != null && this.referencePoint != null) {
                    indicators.add(new Hypervolume(problem, this.idealPoint, this.referencePoint));
                } else if (this.referencePoint != null) {
                    indicators.add(new Hypervolume(problem, referenceSet, this.referencePoint));
                } else {
                    indicators.add(new Hypervolume(problem, referenceSet));
                }
            }
            if (this.includeGenerationalDistance) {
                indicators.add(new GenerationalDistance(problem, referenceSet));
            }
            if (this.includeInvertedGenerationalDistance) {
                indicators.add(new InvertedGenerationalDistance(problem, referenceSet));
            }
            if (this.includeAdditiveEpsilonIndicator) {
                indicators.add(new AdditiveEpsilonIndicator(problem, referenceSet));
            }
            if (this.includeMaximumParetoFrontError) {
                indicators.add(new MaximumParetoFrontError(problem, referenceSet));
            }
            if (this.includeSpacing) {
                indicators.add(new Spacing(problem));
            }
            if (this.includeContribution) {
                if (this.epsilon == null) {
                    indicators.add(new Contribution(referenceSet));
                } else {
                    indicators.add(new Contribution(referenceSet, this.epsilon));
                }
            }
            if (this.includeR1) {
                indicators.add(new R1Indicator(problem, R1Indicator.getDefaultSubdivisions(problem), referenceSet));
            }
            if (this.includeR2) {
                indicators.add(new R2Indicator(problem, R2Indicator.getDefaultSubdivisions(problem), referenceSet));
            }
            if (this.includeR3) {
                indicators.add(new R3Indicator(problem, R3Indicator.getDefaultSubdivisions(problem), referenceSet));
            }
            if (indicators.isEmpty()) {
                System.err.println("no indicators selected");
                AnalyzerResults analyzerResults = new AnalyzerResults();
                return analyzerResults;
            }
            HashMap<String, NondominatedPopulation> aggregateSets = new HashMap<String, NondominatedPopulation>();
            if (this.showAggregate) {
                for (String algorithm : this.data.keySet()) {
                    NondominatedPopulation aggregateSet = this.newArchive();
                    for (NondominatedPopulation set : this.data.get(algorithm)) {
                        aggregateSet.addAll(set);
                    }
                    aggregateSets.put(algorithm, aggregateSet);
                }
            }
            AnalyzerResults analyzerResults = new AnalyzerResults();
            for (String algorithm : this.data.keySet()) {
                AlgorithmResult algorithmResult = new AlgorithmResult(algorithm);
                for (Indicator indicator : indicators) {
                    String indicatorName = indicator.getClass().getSimpleName();
                    List<NondominatedPopulation> sets = this.data.get(algorithm);
                    values = new double[sets.size()];
                    for (int i = 0; i < sets.size(); ++i) {
                        values[i] = indicator.evaluate(sets.get(i));
                    }
                    algorithmResult.add(new IndicatorResult(indicatorName, values));
                    if (!this.showAggregate) continue;
                    algorithmResult.get(indicatorName).setAggregateValue(indicator.evaluate((NondominatedPopulation)aggregateSets.get(algorithm)));
                }
                analyzerResults.add(algorithmResult);
            }
            if (this.showStatisticalSignificance) {
                ArrayList<String> algorithms = new ArrayList<String>(this.data.keySet());
                for (Indicator indicator : indicators) {
                    int i;
                    String indicatorName = indicator.getClass().getSimpleName();
                    if (algorithms.size() < 2) continue;
                    KruskalWallisTest kwTest = new KruskalWallisTest(algorithms.size());
                    for (i = 0; i < algorithms.size(); ++i) {
                        String algorithm = (String)algorithms.get(i);
                        values = analyzerResults.get(algorithm).get(indicatorName).getValues();
                        kwTest.addAll(values, i);
                    }
                    try {
                        if (!kwTest.test(this.significanceLevel)) {
                            for (i = 0; i < algorithms.size() - 1; ++i) {
                                for (int j = i + 1; j < algorithms.size(); ++j) {
                                    analyzerResults.get((String)algorithms.get(i)).get(indicatorName).addIndifferentAlgorithm((String)algorithms.get(j));
                                    analyzerResults.get((String)algorithms.get(j)).get(indicatorName).addIndifferentAlgorithm((String)algorithms.get(i));
                                }
                            }
                            continue;
                        }
                        for (i = 0; i < algorithms.size() - 1; ++i) {
                            for (int j = i + 1; j < algorithms.size(); ++j) {
                                MannWhitneyUTest mwTest = new MannWhitneyUTest();
                                mwTest.addAll(analyzerResults.get((String)algorithms.get(i)).get(indicatorName).getValues(), 0);
                                mwTest.addAll(analyzerResults.get((String)algorithms.get(j)).get(indicatorName).getValues(), 1);
                                if (mwTest.test(this.significanceLevel)) continue;
                                analyzerResults.get((String)algorithms.get(i)).get(indicatorName).addIndifferentAlgorithm((String)algorithms.get(j));
                                analyzerResults.get((String)algorithms.get(j)).get(indicatorName).addIndifferentAlgorithm((String)algorithms.get(i));
                            }
                        }
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            }
            AnalyzerResults analyzerResults2 = analyzerResults;
            return analyzerResults2;
        }
        finally {
            if (problem != null && problem != this.problemInstance) {
                problem.close();
            }
        }
    }

    public Analyzer printAnalysis(PrintStream ps) {
        this.getAnalysis().print(ps);
        return this;
    }

    public Analyzer clear() {
        this.data.clear();
        return this;
    }

    public class IndicatorResult {
        private final String indicator;
        private final double[] values;
        private List<String> indifferentAlgorithms;
        private Double aggregateValue;

        public IndicatorResult(String indicator, double[] values) {
            this.indicator = indicator;
            this.values = values;
            this.indifferentAlgorithms = new ArrayList<String>();
        }

        public double[] getValues() {
            return (double[])this.values.clone();
        }

        public double getMin() {
            return this.getStatistic((UnivariateStatistic)new Min());
        }

        public double getMedian() {
            return this.getStatistic((UnivariateStatistic)new Median());
        }

        public double getMax() {
            return this.getStatistic((UnivariateStatistic)new Max());
        }

        public double getStatistic(UnivariateStatistic statistic) {
            return statistic.evaluate(this.values);
        }

        public int getCount() {
            return this.values.length;
        }

        public List<String> getIndifferentAlgorithms() {
            return new ArrayList<String>(this.indifferentAlgorithms);
        }

        void addIndifferentAlgorithm(String algorithm) {
            this.indifferentAlgorithms.add(algorithm);
        }

        public Double getAggregateValue() {
            return this.aggregateValue;
        }

        void setAggregateValue(Double aggregateValue) {
            this.aggregateValue = aggregateValue;
        }

        public String getIndicator() {
            return this.indicator;
        }

        void print(PrintStream ps) {
            double[] values = this.getValues();
            ps.print("    ");
            ps.print(this.getIndicator());
            ps.print(": ");
            if (values.length == 0) {
                ps.print("null");
            } else if (values.length == 1) {
                ps.print(values[0]);
            } else {
                ps.println();
                if (Analyzer.this.showAggregate) {
                    ps.print("        Aggregate: ");
                    ps.println(this.getAggregateValue());
                }
                if (Analyzer.this.statistics.isEmpty()) {
                    ps.print("        Min: ");
                    ps.println(this.getMin());
                    ps.print("        Median: ");
                    ps.println(this.getMedian());
                    ps.print("        Max: ");
                    ps.println(this.getMax());
                } else {
                    for (UnivariateStatistic statistic : Analyzer.this.statistics) {
                        ps.print("        ");
                        ps.print(statistic.getClass().getSimpleName());
                        ps.print(": ");
                        ps.println(this.getStatistic(statistic));
                    }
                }
                ps.print("        Count: ");
                ps.print(this.getCount());
                if (Analyzer.this.showStatisticalSignificance) {
                    ps.println();
                    ps.print("        Indifferent: ");
                    ps.print(this.getIndifferentAlgorithms());
                }
                if (Analyzer.this.showIndividualValues) {
                    ps.println();
                    ps.print("        Values: ");
                    ps.print(Arrays.toString(values));
                }
            }
            ps.println();
        }
    }

    public class AlgorithmResult {
        private final String algorithm;
        private final List<IndicatorResult> indicatorResults;

        public AlgorithmResult(String algorithm) {
            this.algorithm = algorithm;
            this.indicatorResults = new ArrayList<IndicatorResult>();
        }

        public String getAlgorithm() {
            return this.algorithm;
        }

        public List<String> getIndicators() {
            ArrayList<String> indicators = new ArrayList<String>();
            for (IndicatorResult result : this.indicatorResults) {
                indicators.add(result.getIndicator());
            }
            return indicators;
        }

        public IndicatorResult get(String indicator) {
            for (IndicatorResult result : this.indicatorResults) {
                if (!result.getIndicator().equals(indicator)) continue;
                return result;
            }
            return null;
        }

        void add(IndicatorResult result) {
            this.indicatorResults.add(result);
        }

        void print(PrintStream ps) {
            ps.print(this.getAlgorithm());
            ps.println(':');
            for (IndicatorResult indicatorResult : this.indicatorResults) {
                indicatorResult.print(ps);
            }
        }
    }

    public class AnalyzerResults {
        private final List<AlgorithmResult> algorithmResults = new ArrayList<AlgorithmResult>();

        AnalyzerResults() {
        }

        public List<String> getAlgorithms() {
            ArrayList<String> algorithms = new ArrayList<String>();
            for (AlgorithmResult result : this.algorithmResults) {
                algorithms.add(result.getAlgorithm());
            }
            return algorithms;
        }

        public AlgorithmResult get(String algorithm) {
            for (AlgorithmResult result : this.algorithmResults) {
                if (!result.getAlgorithm().equals(algorithm)) continue;
                return result;
            }
            return null;
        }

        void add(AlgorithmResult result) {
            this.algorithmResults.add(result);
        }

        public void print() {
            this.print(System.out);
        }

        public void print(PrintStream ps) {
            for (AlgorithmResult algorithmResult : this.algorithmResults) {
                algorithmResult.print(ps);
            }
        }
    }
}

