/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicBoolean;
import org.moeaframework.Instrumenter;
import org.moeaframework.ProblemBuilder;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.TerminationCondition;
import org.moeaframework.core.spi.AlgorithmFactory;
import org.moeaframework.core.spi.ProblemFactory;
import org.moeaframework.core.termination.CompoundTerminationCondition;
import org.moeaframework.core.termination.MaxElapsedTime;
import org.moeaframework.core.termination.MaxFunctionEvaluations;
import org.moeaframework.util.TypedProperties;
import org.moeaframework.util.io.FileUtils;
import org.moeaframework.util.progress.ProgressHelper;
import org.moeaframework.util.progress.ProgressListener;

public class Executor
extends ProblemBuilder {
    private String algorithmName;
    private TypedProperties properties;
    private int numberOfThreads = 1;
    private ExecutorService executorService;
    private File checkpointFile;
    private int checkpointFrequency;
    private AlgorithmFactory algorithmFactory;
    private Instrumenter instrumenter;
    private ProgressHelper progress;
    private AtomicBoolean isCanceled = new AtomicBoolean();
    private List<TerminationCondition> terminationConditions;

    public Executor() {
        this.progress = new ProgressHelper(this);
        this.properties = new TypedProperties();
        this.terminationConditions = new ArrayList<TerminationCondition>();
    }

    public void cancel() {
        this.isCanceled.set(true);
    }

    public boolean isCanceled() {
        return this.isCanceled.get();
    }

    public Executor withInstrumenter(Instrumenter instrumenter) {
        this.instrumenter = instrumenter;
        return this;
    }

    public Instrumenter getInstrumenter() {
        return this.instrumenter;
    }

    public Executor usingAlgorithmFactory(AlgorithmFactory algorithmFactory) {
        this.algorithmFactory = algorithmFactory;
        return this;
    }

    @Override
    public Executor withSameProblemAs(ProblemBuilder builder) {
        return (Executor)super.withSameProblemAs(builder);
    }

    @Override
    public Executor usingProblemFactory(ProblemFactory problemFactory) {
        return (Executor)super.usingProblemFactory(problemFactory);
    }

    @Override
    public Executor withProblem(String problemName) {
        return (Executor)super.withProblem(problemName);
    }

    @Override
    public Executor withProblem(Problem problemInstance) {
        return (Executor)super.withProblem(problemInstance);
    }

    @Override
    public Executor withProblemClass(Class<?> problemClass, Object ... problemArguments) {
        return (Executor)super.withProblemClass(problemClass, problemArguments);
    }

    @Override
    public Executor withProblemClass(String problemClassName, Object ... problemArguments) throws ClassNotFoundException {
        return (Executor)super.withProblemClass(problemClassName, problemArguments);
    }

    public Executor withTerminationCondition(TerminationCondition condition) {
        this.terminationConditions.add(condition);
        return this;
    }

    public Executor withAlgorithm(String algorithmName) {
        this.algorithmName = algorithmName;
        return this;
    }

    public Executor distributeWith(ExecutorService executorService) {
        this.executorService = executorService;
        return this;
    }

    public Executor distributeOn(int numberOfThreads) {
        if (numberOfThreads <= 0) {
            throw new IllegalArgumentException("invalid number of threads");
        }
        this.numberOfThreads = numberOfThreads;
        return this;
    }

    public Executor distributeOnAllCores() {
        return this.distributeOn(Runtime.getRuntime().availableProcessors());
    }

    public Executor withCheckpointFile(File checkpointFile) {
        this.checkpointFile = checkpointFile;
        return this;
    }

    public Executor withCheckpointFrequency(int checkpointFrequency) {
        this.checkpointFrequency = checkpointFrequency;
        return this;
    }

    public Executor checkpointEveryIteration() {
        return this.withCheckpointFrequency(1);
    }

    public Executor resetCheckpointFile() throws IOException {
        if (this.checkpointFile != null) {
            FileUtils.delete(this.checkpointFile);
        }
        return this;
    }

    @Override
    public Executor withEpsilon(double ... epsilon) {
        super.withEpsilon(epsilon);
        if (epsilon == null || epsilon.length == 0) {
            this.properties.remove("epsilon");
        } else {
            this.withProperty("epsilon", epsilon);
        }
        return this;
    }

    public Executor withMaxEvaluations(int maxEvaluations) {
        this.withProperty("maxEvaluations", maxEvaluations);
        return this;
    }

    public Executor withMaxTime(long maxTime) {
        this.withProperty("maxTime", maxTime);
        return this;
    }

    public Executor removeProperty(String key) {
        this.properties.remove(key);
        return this;
    }

    public Executor withProperty(String key, String value) {
        this.properties.setString(key, value);
        return this;
    }

    public Executor withProperty(String key, float value) {
        this.properties.setFloat(key, value);
        return this;
    }

    public Executor withProperty(String key, double value) {
        this.properties.setDouble(key, value);
        return this;
    }

    public Executor withProperty(String key, byte value) {
        this.properties.setByte(key, value);
        return this;
    }

    public Executor withProperty(String key, short value) {
        this.properties.setShort(key, value);
        return this;
    }

    public Executor withProperty(String key, int value) {
        this.properties.setInt(key, value);
        return this;
    }

    public Executor withProperty(String key, long value) {
        this.properties.setLong(key, value);
        return this;
    }

    public Executor withProperty(String key, boolean value) {
        this.properties.setBoolean(key, value);
        return this;
    }

    public Executor withProperty(String key, String[] values) {
        this.properties.setStringArray(key, values);
        return this;
    }

    public Executor withProperty(String key, float[] values) {
        this.properties.setFloatArray(key, values);
        return this;
    }

    public Executor withProperty(String key, double[] values) {
        this.properties.setDoubleArray(key, values);
        return this;
    }

    public Executor withProperty(String key, byte[] values) {
        this.properties.setByteArray(key, values);
        return this;
    }

    public Executor withProperty(String key, short[] values) {
        this.properties.setShortArray(key, values);
        return this;
    }

    public Executor withProperty(String key, int[] values) {
        this.properties.setIntArray(key, values);
        return this;
    }

    public Executor withProperty(String key, long[] values) {
        this.properties.setLongArray(key, values);
        return this;
    }

    public Executor clearProperties() {
        this.properties.clear();
        return this;
    }

    public Executor withProperties(Properties properties) {
        this.properties.clear();
        this.properties.addAll(properties);
        return this;
    }

    public Executor withProgressListener(ProgressListener listener) {
        this.progress.addProgressListener(listener);
        return this;
    }

    protected TerminationCondition createTerminationCondition() {
        int maxEvaluations = (int)this.properties.getDouble("maxEvaluations", -1.0);
        long maxTime = (long)this.properties.getDouble("maxTime", -1.0);
        ArrayList<TerminationCondition> conditions = new ArrayList<TerminationCondition>();
        if (maxEvaluations >= 0) {
            conditions.add(new MaxFunctionEvaluations(maxEvaluations));
        }
        if (maxTime >= 0L) {
            conditions.add(new MaxElapsedTime(maxTime));
        }
        conditions.addAll(this.terminationConditions);
        if (conditions.size() == 0) {
            System.err.println("no termination conditions set, setting to 25,000 max evaluations");
            return new MaxFunctionEvaluations(25000);
        }
        if (conditions.size() == 1) {
            return (TerminationCondition)conditions.get(0);
        }
        return new CompoundTerminationCondition(conditions.toArray(new TerminationCondition[conditions.size()]));
    }

    public List<NondominatedPopulation> runSeeds(int numberOfSeeds) {
        this.isCanceled.set(false);
        if (this.checkpointFile != null && numberOfSeeds > 1) {
            System.err.println("checkpoints not supported when running multiple seeds");
            this.checkpointFile = null;
        }
        int maxEvaluations = this.properties.getInt("maxEvaluations", -1);
        long maxTime = this.properties.getLong("maxTime", -1L);
        ArrayList<NondominatedPopulation> results = new ArrayList<NondominatedPopulation>();
        this.progress.start(numberOfSeeds, maxEvaluations, maxTime);
        for (int i = 0; i < numberOfSeeds && !this.isCanceled.get(); ++i) {
            NondominatedPopulation result = this.runSingleSeed(i + 1, numberOfSeeds, this.createTerminationCondition());
            if (result == null) continue;
            results.add(result);
            this.progress.nextSeed();
        }
        this.progress.stop();
        return results;
    }

    public NondominatedPopulation run() {
        this.isCanceled.set(false);
        return this.runSingleSeed(1, 1, this.createTerminationCondition());
    }

    /*
     * Exception decompiling
     */
    protected NondominatedPopulation runSingleSeed(int seed, int numberOfSeeds, TerminationCondition terminationCondition) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[TRYBLOCK], 1[TRYBLOCK]], but top level block is 11[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }
}

