/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework;

import java.io.File;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import org.moeaframework.ProblemBuilder;
import org.moeaframework.analysis.collector.Accumulator;
import org.moeaframework.analysis.collector.AdaptiveMultimethodVariationCollector;
import org.moeaframework.analysis.collector.AdaptiveTimeContinuationCollector;
import org.moeaframework.analysis.collector.ApproximationSetCollector;
import org.moeaframework.analysis.collector.Collector;
import org.moeaframework.analysis.collector.ElapsedTimeCollector;
import org.moeaframework.analysis.collector.EpsilonProgressCollector;
import org.moeaframework.analysis.collector.IndicatorCollector;
import org.moeaframework.analysis.collector.InstrumentedAlgorithm;
import org.moeaframework.analysis.collector.PopulationSizeCollector;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.indicator.AdditiveEpsilonIndicator;
import org.moeaframework.core.indicator.Contribution;
import org.moeaframework.core.indicator.GenerationalDistance;
import org.moeaframework.core.indicator.Hypervolume;
import org.moeaframework.core.indicator.InvertedGenerationalDistance;
import org.moeaframework.core.indicator.R1Indicator;
import org.moeaframework.core.indicator.R2Indicator;
import org.moeaframework.core.indicator.R3Indicator;
import org.moeaframework.core.indicator.Spacing;
import org.moeaframework.core.spi.ProblemFactory;

public class Instrumenter
extends ProblemBuilder {
    private boolean includeHypervolume;
    private boolean includeGenerationalDistance;
    private boolean includeInvertedGenerationalDistance;
    private boolean includeSpacing;
    private boolean includeAdditiveEpsilonIndicator;
    private boolean includeContribution;
    private boolean includeR1;
    private boolean includeR2;
    private boolean includeR3;
    private boolean includeEpsilonProgress;
    private boolean includeAdaptiveMultimethodVariation;
    private boolean includeAdaptiveTimeContinuation;
    private boolean includeElapsedTime;
    private boolean includeApproximationSet;
    private boolean includePopulationSize;
    private int frequency = 100;
    private final List<Collector> customCollectors = new ArrayList<Collector>();
    private Accumulator lastAccumulator;

    public Accumulator getLastAccumulator() {
        return this.lastAccumulator;
    }

    @Deprecated
    public Instrumenter addAllowedPackage(String packageName) {
        return this;
    }

    @Deprecated
    public Instrumenter removeAllowedPackage(String packageName) {
        return this;
    }

    @Deprecated
    public List<String> getAllowedPackages() {
        return new ArrayList<String>();
    }

    public Instrumenter withFrequency(int frequency) {
        this.frequency = frequency;
        return this;
    }

    public Instrumenter attach(Collector collector) {
        this.customCollectors.add(collector);
        return this;
    }

    public Instrumenter attachHypervolumeCollector() {
        this.includeHypervolume = true;
        return this;
    }

    public Instrumenter attachGenerationalDistanceCollector() {
        this.includeGenerationalDistance = true;
        return this;
    }

    public Instrumenter attachInvertedGenerationalDistanceCollector() {
        this.includeInvertedGenerationalDistance = true;
        return this;
    }

    public Instrumenter attachSpacingCollector() {
        this.includeSpacing = true;
        return this;
    }

    public Instrumenter attachAdditiveEpsilonIndicatorCollector() {
        this.includeAdditiveEpsilonIndicator = true;
        return this;
    }

    public Instrumenter attachContributionCollector() {
        this.includeContribution = true;
        return this;
    }

    public Instrumenter attachR1Collector() {
        this.includeR1 = true;
        return this;
    }

    public Instrumenter attachR2Collector() {
        this.includeR2 = true;
        return this;
    }

    public Instrumenter attachR3Collector() {
        this.includeR3 = true;
        return this;
    }

    public Instrumenter attachAllMetricCollectors() {
        this.attachHypervolumeCollector();
        this.attachGenerationalDistanceCollector();
        this.attachInvertedGenerationalDistanceCollector();
        this.attachSpacingCollector();
        this.attachAdditiveEpsilonIndicatorCollector();
        this.attachContributionCollector();
        this.attachR1Collector();
        this.attachR2Collector();
        this.attachR3Collector();
        return this;
    }

    public Instrumenter attachEpsilonProgressCollector() {
        this.includeEpsilonProgress = true;
        return this;
    }

    public Instrumenter attachAdaptiveMultimethodVariationCollector() {
        this.includeAdaptiveMultimethodVariation = true;
        return this;
    }

    public Instrumenter attachAdaptiveTimeContinuationCollector() {
        this.includeAdaptiveTimeContinuation = true;
        return this;
    }

    public Instrumenter attachElapsedTimeCollector() {
        this.includeElapsedTime = true;
        return this;
    }

    public Instrumenter attachApproximationSetCollector() {
        this.includeApproximationSet = true;
        return this;
    }

    public Instrumenter attachPopulationSizeCollector() {
        this.includePopulationSize = true;
        return this;
    }

    public Instrumenter attachAll() {
        this.attachAllMetricCollectors();
        this.attachEpsilonProgressCollector();
        this.attachAdaptiveMultimethodVariationCollector();
        this.attachAdaptiveTimeContinuationCollector();
        this.attachElapsedTimeCollector();
        this.attachApproximationSetCollector();
        this.attachPopulationSizeCollector();
        return this;
    }

    @Override
    public Instrumenter withSameProblemAs(ProblemBuilder builder) {
        return (Instrumenter)super.withSameProblemAs(builder);
    }

    @Override
    public Instrumenter usingProblemFactory(ProblemFactory problemFactory) {
        return (Instrumenter)super.usingProblemFactory(problemFactory);
    }

    @Override
    public Instrumenter withProblem(String problemName) {
        return (Instrumenter)super.withProblem(problemName);
    }

    @Override
    public Instrumenter withProblem(Problem problemInstance) {
        return (Instrumenter)super.withProblem(problemInstance);
    }

    @Override
    public Instrumenter withProblemClass(Class<?> problemClass, Object ... problemArguments) {
        return (Instrumenter)super.withProblemClass(problemClass, problemArguments);
    }

    @Override
    public Instrumenter withProblemClass(String problemClassName, Object ... problemArguments) throws ClassNotFoundException {
        return (Instrumenter)super.withProblemClass(problemClassName, problemArguments);
    }

    @Override
    public Instrumenter withReferenceSet(File referenceSetFile) {
        return (Instrumenter)super.withReferenceSet(referenceSetFile);
    }

    @Override
    public Instrumenter withEpsilon(double ... epsilon) {
        return (Instrumenter)super.withEpsilon(epsilon);
    }

    @Override
    public NondominatedPopulation getReferenceSet() {
        return super.getReferenceSet();
    }

    protected void instrument(InstrumentedAlgorithm algorithm, List<Collector> collectors, Set<Object> visited, Stack<Object> parents, Object object, Class<?> type) {
        Class<?> superclass;
        if (object == null) {
            return;
        }
        if (type == null || type.equals(object.getClass())) {
            try {
                if (visited.contains(object)) {
                    return;
                }
            }
            catch (NullPointerException e) {
                return;
            }
            type = object.getClass();
        }
        if (type.isAnnotation() || type.isEnum() || type.isPrimitive()) {
            return;
        }
        if (object instanceof Instrumenter) {
            return;
        }
        if (type.isArray()) {
            for (int i = 0; i < Array.getLength(object); ++i) {
                this.instrument(algorithm, collectors, visited, parents, Array.get(object, i), null);
            }
        } else if (object instanceof Collection) {
            for (Object element : (Collection)object) {
                this.instrument(algorithm, collectors, visited, parents, element, null);
            }
        } else if (type.getPackage() != null && type.getPackage().getName().startsWith("java.")) {
            return;
        }
        if (!visited.contains(object)) {
            for (Collector collector : collectors) {
                if (!collector.getAttachPoint().matches(parents, object)) continue;
                algorithm.addCollector(collector.attach(object));
            }
            visited.add(object);
        }
        if ((superclass = type.getSuperclass()) != null) {
            this.instrument(algorithm, collectors, visited, parents, object, superclass);
        }
        parents.push(object);
        for (Field field : type.getDeclaredFields()) {
            field.setAccessible(true);
            try {
                this.instrument(algorithm, collectors, visited, parents, field.get(object), null);
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
        parents.pop();
    }

    public InstrumentedAlgorithm instrument(Algorithm algorithm) {
        ArrayList<Collector> collectors = new ArrayList<Collector>();
        if (this.includeHypervolume || this.includeGenerationalDistance || this.includeInvertedGenerationalDistance || this.includeSpacing || this.includeAdditiveEpsilonIndicator || this.includeContribution || this.includeR1 || this.includeR2 || this.includeR3) {
            Problem problem = algorithm.getProblem();
            NondominatedPopulation referenceSet = this.getReferenceSet();
            EpsilonBoxDominanceArchive archive = null;
            if (this.epsilon != null) {
                archive = (EpsilonBoxDominanceArchive)this.newArchive();
            }
            if (this.includeHypervolume) {
                collectors.add(new IndicatorCollector(new Hypervolume(problem, referenceSet), archive));
            }
            if (this.includeGenerationalDistance) {
                collectors.add(new IndicatorCollector(new GenerationalDistance(problem, referenceSet), archive));
            }
            if (this.includeInvertedGenerationalDistance) {
                collectors.add(new IndicatorCollector(new InvertedGenerationalDistance(problem, referenceSet), archive));
            }
            if (this.includeSpacing) {
                collectors.add(new IndicatorCollector(new Spacing(problem), archive));
            }
            if (this.includeAdditiveEpsilonIndicator) {
                collectors.add(new IndicatorCollector(new AdditiveEpsilonIndicator(problem, referenceSet), archive));
            }
            if (this.includeContribution) {
                collectors.add(new IndicatorCollector(archive == null ? new Contribution(referenceSet) : new Contribution(referenceSet, archive.getComparator()), archive));
            }
            if (this.includeR1) {
                collectors.add(new IndicatorCollector(new R1Indicator(problem, R1Indicator.getDefaultSubdivisions(problem), referenceSet), archive));
            }
            if (this.includeR2) {
                collectors.add(new IndicatorCollector(new R2Indicator(problem, R2Indicator.getDefaultSubdivisions(problem), referenceSet), archive));
            }
            if (this.includeR3) {
                collectors.add(new IndicatorCollector(new R3Indicator(problem, R3Indicator.getDefaultSubdivisions(problem), referenceSet), archive));
            }
        }
        if (this.includeEpsilonProgress) {
            collectors.add(new EpsilonProgressCollector());
        }
        if (this.includeAdaptiveMultimethodVariation) {
            collectors.add(new AdaptiveMultimethodVariationCollector());
        }
        if (this.includeAdaptiveTimeContinuation) {
            collectors.add(new AdaptiveTimeContinuationCollector());
        }
        if (this.includeElapsedTime) {
            collectors.add(new ElapsedTimeCollector());
        }
        if (this.includeApproximationSet) {
            if (this.epsilon == null) {
                collectors.add(new ApproximationSetCollector());
            } else {
                collectors.add(new ApproximationSetCollector(this.epsilon));
            }
        }
        if (this.includePopulationSize) {
            collectors.add(new PopulationSizeCollector());
        }
        collectors.addAll(this.customCollectors);
        InstrumentedAlgorithm instrumentedAlgorithm = new InstrumentedAlgorithm(algorithm, this.frequency);
        this.instrument(instrumentedAlgorithm, collectors, new HashSet<Object>(), new Stack<Object>(), algorithm, null);
        this.lastAccumulator = instrumentedAlgorithm.getAccumulator();
        return instrumentedAlgorithm;
    }
}

