/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang3.reflect.ConstructorUtils;
import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.PopulationIO;
import org.moeaframework.core.Problem;
import org.moeaframework.core.comparator.ParetoDominanceComparator;
import org.moeaframework.core.spi.ProblemFactory;

class ProblemBuilder {
    String problemName;
    Class<?> problemClass;
    Problem problemInstance;
    Object[] problemArguments;
    ProblemFactory problemFactory;
    double[] epsilon;
    File referenceSetFile;

    ProblemBuilder() {
    }

    ProblemBuilder withSameProblemAs(ProblemBuilder builder) {
        this.problemName = builder.problemName;
        this.problemClass = builder.problemClass;
        this.problemInstance = builder.problemInstance;
        this.problemArguments = builder.problemArguments;
        this.problemFactory = builder.problemFactory;
        this.epsilon = builder.epsilon;
        this.referenceSetFile = builder.referenceSetFile;
        return this;
    }

    ProblemBuilder usingProblemFactory(ProblemFactory problemFactory) {
        this.problemFactory = problemFactory;
        return this;
    }

    ProblemBuilder withProblem(String problemName) {
        this.problemName = problemName;
        this.problemClass = null;
        this.problemInstance = null;
        return this;
    }

    ProblemBuilder withProblem(Problem problemInstance) {
        this.problemInstance = problemInstance;
        this.problemName = null;
        this.problemClass = null;
        return this;
    }

    ProblemBuilder withProblemClass(Class<?> problemClass, Object ... problemArguments) {
        this.problemClass = problemClass;
        this.problemArguments = problemArguments;
        this.problemName = null;
        this.problemInstance = null;
        return this;
    }

    ProblemBuilder withProblemClass(String problemClassName, Object ... problemArguments) throws ClassNotFoundException {
        this.withProblemClass(Class.forName(problemClassName), problemArguments);
        return this;
    }

    ProblemBuilder withEpsilon(double ... epsilon) {
        this.epsilon = (double[])(epsilon == null || epsilon.length == 0 ? null : epsilon);
        return this;
    }

    ProblemBuilder withReferenceSet(File referenceSetFile) {
        this.referenceSetFile = referenceSetFile;
        return this;
    }

    NondominatedPopulation newArchive() {
        if (this.epsilon == null) {
            return new NondominatedPopulation(new ParetoDominanceComparator());
        }
        return new EpsilonBoxDominanceArchive(this.epsilon);
    }

    NondominatedPopulation getReferenceSet() {
        NondominatedPopulation referenceSet = this.newArchive();
        if (this.referenceSetFile == null) {
            NondominatedPopulation factorySet = null;
            if (this.problemName != null) {
                factorySet = this.problemFactory == null ? ProblemFactory.getInstance().getReferenceSet(this.problemName) : this.problemFactory.getReferenceSet(this.problemName);
            }
            if (factorySet == null) {
                throw new IllegalArgumentException("no reference set available");
            }
            referenceSet.addAll(factorySet);
        } else {
            try {
                referenceSet.addAll(PopulationIO.readObjectives(this.referenceSetFile));
            }
            catch (IOException e) {
                throw new IllegalArgumentException("unable to load reference set", e);
            }
        }
        return referenceSet;
    }

    Problem getProblemInstance() {
        if (this.problemName == null && this.problemClass == null && this.problemInstance == null) {
            throw new IllegalArgumentException("no problem specified");
        }
        if (this.problemInstance != null) {
            return this.problemInstance;
        }
        if (this.problemClass != null) {
            try {
                return (Problem)ConstructorUtils.invokeConstructor(this.problemClass, (Object[])this.problemArguments);
            }
            catch (InstantiationException e) {
                throw new FrameworkException(e);
            }
            catch (IllegalAccessException e) {
                throw new FrameworkException(e);
            }
            catch (InvocationTargetException e) {
                throw new FrameworkException(e);
            }
            catch (NoSuchMethodException e) {
                throw new FrameworkException(e);
            }
        }
        if (this.problemFactory == null) {
            return ProblemFactory.getInstance().getProblem(this.problemName);
        }
        return this.problemFactory.getProblem(this.problemName);
    }
}

