/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.Arrays;
import org.moeaframework.algorithm.AlgorithmInitializationException;
import org.moeaframework.algorithm.AlgorithmTerminationException;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;

public abstract class AbstractAlgorithm
implements Algorithm {
    protected final Problem problem;
    protected int numberOfEvaluations;
    protected boolean initialized;
    protected boolean terminated;

    public AbstractAlgorithm(Problem problem) {
        this.problem = problem;
    }

    public void evaluateAll(Iterable<Solution> solutions) {
        for (Solution solution : solutions) {
            this.evaluate(solution);
        }
    }

    public void evaluateAll(Solution[] solutions) {
        this.evaluateAll(Arrays.asList(solutions));
    }

    @Override
    public void evaluate(Solution solution) {
        this.problem.evaluate(solution);
        ++this.numberOfEvaluations;
    }

    @Override
    public int getNumberOfEvaluations() {
        return this.numberOfEvaluations;
    }

    @Override
    public Problem getProblem() {
        return this.problem;
    }

    protected void initialize() {
        if (this.initialized) {
            throw new AlgorithmInitializationException((Algorithm)this, "algorithm already initialized");
        }
        this.initialized = true;
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    @Override
    public void step() {
        if (this.isTerminated()) {
            throw new AlgorithmTerminationException((Algorithm)this, "algorithm already terminated");
        }
        if (!this.isInitialized()) {
            this.initialize();
        } else {
            this.iterate();
        }
    }

    protected abstract void iterate();

    @Override
    public boolean isTerminated() {
        return this.terminated;
    }

    @Override
    public void terminate() {
        if (this.terminated) {
            throw new AlgorithmTerminationException((Algorithm)this, "algorithm already terminated");
        }
        this.terminated = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finalize() throws Throwable {
        try {
            if (!this.isTerminated()) {
                this.terminate();
            }
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public Serializable getState() throws NotSerializableException {
        throw new NotSerializableException(this.getClass().getName());
    }

    @Override
    public void setState(Object state) throws NotSerializableException {
        throw new NotSerializableException(this.getClass().getName());
    }
}

