/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.moeaframework.algorithm.AbstractAlgorithm;
import org.moeaframework.algorithm.AlgorithmInitializationException;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.EvolutionaryAlgorithm;
import org.moeaframework.core.Initialization;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;

public abstract class AbstractEvolutionaryAlgorithm
extends AbstractAlgorithm
implements EvolutionaryAlgorithm {
    protected final Population population;
    protected final NondominatedPopulation archive;
    protected final Initialization initialization;

    public AbstractEvolutionaryAlgorithm(Problem problem, Population population, NondominatedPopulation archive, Initialization initialization) {
        super(problem);
        this.population = population;
        this.archive = archive;
        this.initialization = initialization;
    }

    @Override
    public NondominatedPopulation getResult() {
        Population population = this.getPopulation();
        NondominatedPopulation archive = this.getArchive();
        NondominatedPopulation result = new NondominatedPopulation();
        result.addAll(population);
        if (archive != null) {
            result.addAll(archive);
        }
        return result;
    }

    @Override
    protected void initialize() {
        super.initialize();
        Population population = this.getPopulation();
        NondominatedPopulation archive = this.getArchive();
        Solution[] initialSolutions = this.initialization.initialize();
        this.evaluateAll(initialSolutions);
        population.addAll(initialSolutions);
        if (archive != null) {
            archive.addAll(population);
        }
    }

    @Override
    public NondominatedPopulation getArchive() {
        return this.archive;
    }

    @Override
    public Population getPopulation() {
        return this.population;
    }

    @Override
    public Serializable getState() throws NotSerializableException {
        if (!this.isInitialized()) {
            throw new AlgorithmInitializationException((Algorithm)this, "algorithm not initialized");
        }
        ArrayList<Solution> populationList = new ArrayList<Solution>();
        ArrayList<Solution> archiveList = new ArrayList<Solution>();
        for (Solution solution : this.population) {
            populationList.add(solution);
        }
        if (this.archive != null) {
            for (Solution solution : this.archive) {
                archiveList.add(solution);
            }
        }
        return new EvolutionaryAlgorithmState(this.getNumberOfEvaluations(), populationList, archiveList);
    }

    @Override
    public void setState(Object objState) throws NotSerializableException {
        super.initialize();
        EvolutionaryAlgorithmState state = (EvolutionaryAlgorithmState)objState;
        this.numberOfEvaluations = state.getNumberOfEvaluations();
        this.population.addAll(state.getPopulation());
        if (this.archive != null) {
            this.archive.addAll(state.getArchive());
        }
    }

    private static class EvolutionaryAlgorithmState
    implements Serializable {
        private static final long serialVersionUID = -6186688380313335557L;
        private final int numberOfEvaluations;
        private final List<Solution> population;
        private final List<Solution> archive;

        public EvolutionaryAlgorithmState(int numberOfEvaluations, List<Solution> population, List<Solution> archive) {
            this.numberOfEvaluations = numberOfEvaluations;
            this.population = population;
            this.archive = archive;
        }

        public int getNumberOfEvaluations() {
            return this.numberOfEvaluations;
        }

        public List<Solution> getPopulation() {
            return this.population;
        }

        public List<Solution> getArchive() {
            return this.archive;
        }
    }
}

