/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.apache.commons.lang3.event.EventListenerSupport;
import org.moeaframework.algorithm.PeriodicAction;
import org.moeaframework.algorithm.RestartEvent;
import org.moeaframework.algorithm.RestartListener;
import org.moeaframework.algorithm.RestartType;
import org.moeaframework.core.EvolutionaryAlgorithm;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Population;
import org.moeaframework.core.Selection;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;

public class AdaptiveTimeContinuation
extends PeriodicAction
implements EvolutionaryAlgorithm {
    private final int maxWindowSize;
    private final double populationRatio;
    private final int minimumPopulationSize;
    private final int maximumPopulationSize;
    private final Selection selection;
    private final Variation variation;
    private int iterationAtLastRestart;
    private final EventListenerSupport<RestartListener> listeners;

    public AdaptiveTimeContinuation(EvolutionaryAlgorithm algorithm, int windowSize, int maxWindowSize, double populationRatio, int minimumPopulationSize, int maximumPopulationSize, Selection selection, Variation variation) {
        super(algorithm, windowSize, PeriodicAction.FrequencyType.STEPS);
        this.maxWindowSize = maxWindowSize;
        this.populationRatio = populationRatio;
        this.minimumPopulationSize = minimumPopulationSize;
        this.maximumPopulationSize = maximumPopulationSize;
        this.selection = selection;
        this.variation = variation;
        this.listeners = EventListenerSupport.create(RestartListener.class);
    }

    public void addRestartListener(RestartListener listener) {
        this.listeners.addListener((Object)listener);
    }

    public void removeRestartListener(RestartListener listener) {
        this.listeners.removeListener((Object)listener);
    }

    protected RestartType check() {
        int populationSize = this.getPopulation().size();
        double targetSize = this.populationRatio * (double)this.getArchive().size();
        if (this.iteration - this.iterationAtLastRestart >= this.maxWindowSize) {
            return RestartType.HARD;
        }
        if (targetSize >= (double)this.minimumPopulationSize && targetSize <= (double)this.maximumPopulationSize && Math.abs((double)populationSize - targetSize) > 0.25 * targetSize) {
            return RestartType.HARD;
        }
        return RestartType.NONE;
    }

    protected void restart(RestartType type) {
        int newPopulationSize;
        Population population = this.getPopulation();
        NondominatedPopulation archive = this.getArchive();
        if (type.equals((Object)RestartType.HARD)) {
            population.clear();
            population.addAll(archive);
        }
        if ((newPopulationSize = (int)(this.populationRatio * (double)archive.size())) < this.minimumPopulationSize) {
            newPopulationSize = this.minimumPopulationSize;
        } else if (newPopulationSize > this.maximumPopulationSize) {
            newPopulationSize = this.maximumPopulationSize;
        }
        while (population.size() < newPopulationSize) {
            Solution[] children;
            Solution[] parents = this.selection.select(this.variation.getArity(), archive);
            for (Solution child : children = this.variation.evolve(parents)) {
                this.algorithm.evaluate(child);
                population.add(child);
                archive.add(child);
            }
        }
        if (type.equals((Object)RestartType.HARD)) {
            this.iterationAtLastRestart = this.iteration;
        }
        ((RestartListener)this.listeners.fire()).restarted(new RestartEvent(this, type));
    }

    @Override
    public void doAction() {
        RestartType type = this.check();
        if (type != null && !type.equals((Object)RestartType.NONE)) {
            this.restart(type);
        }
    }

    @Override
    public Population getPopulation() {
        return ((EvolutionaryAlgorithm)this.algorithm).getPopulation();
    }

    @Override
    public NondominatedPopulation getArchive() {
        return ((EvolutionaryAlgorithm)this.algorithm).getArchive();
    }

    @Override
    public Serializable getState() throws NotSerializableException {
        return new AdaptiveTimeContinuationState(super.getState(), this.iterationAtLastRestart);
    }

    @Override
    public void setState(Object objState) throws NotSerializableException {
        AdaptiveTimeContinuationState state = (AdaptiveTimeContinuationState)objState;
        super.setState(state.getAlgorithmState());
        this.iterationAtLastRestart = state.getIterationAtLastRestart();
    }

    private static class AdaptiveTimeContinuationState
    implements Serializable {
        private static final long serialVersionUID = -4773227519517581809L;
        private final Serializable algorithmState;
        private final int iterationAtLastRestart;

        public AdaptiveTimeContinuationState(Serializable algorithmState, int iterationAtLastRestart) {
            this.algorithmState = algorithmState;
            this.iterationAtLastRestart = iterationAtLastRestart;
        }

        public Serializable getAlgorithmState() {
            return this.algorithmState;
        }

        public int getIterationAtLastRestart() {
            return this.iterationAtLastRestart;
        }
    }
}

