/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.math3.stat.StatUtils;
import org.moeaframework.algorithm.AbstractAlgorithm;
import org.moeaframework.algorithm.AlgorithmInitializationException;
import org.moeaframework.algorithm.AlgorithmTerminationException;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.FastNondominatedSorting;
import org.moeaframework.core.FitnessEvaluator;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.comparator.AggregateConstraintComparator;
import org.moeaframework.core.comparator.ChainedComparator;
import org.moeaframework.core.comparator.FitnessComparator;
import org.moeaframework.core.comparator.NondominatedSortingComparator;
import org.moeaframework.core.comparator.ObjectiveComparator;
import org.moeaframework.core.comparator.RankComparator;
import org.moeaframework.core.variable.EncodingUtils;
import org.moeaframework.core.variable.RealVariable;

public class CMAES
extends AbstractAlgorithm {
    private final double[] initialSearchPoint;
    private final boolean checkConsistency;
    private final FitnessEvaluator fitnessEvaluator;
    private final NondominatedPopulation archive;
    private int iteration;
    private int diagonalIterations;
    private int lambda;
    private int mu;
    private double sigma;
    private double mueff;
    private double ccov;
    private double ccovsep;
    private double chiN;
    private double cs;
    private double cc;
    private double damps;
    private double[] weights;
    private double[] diagD;
    private double[] xmean;
    private double[] pc;
    private double[] ps;
    private double[][] B;
    private double[][] C;
    private Population population;
    private int lastEigenupdate;

    public CMAES(Problem problem, int lambda) {
        this(problem, lambda, null, new NondominatedPopulation());
    }

    public CMAES(Problem problem, int lambda, FitnessEvaluator fitnessEvaluator, NondominatedPopulation archive) {
        this(problem, lambda, fitnessEvaluator, archive, null, false, -1.0, -1.0, -1.0, -1.0, -1.0, -1.0, -1);
    }

    public CMAES(Problem problem, int lambda, FitnessEvaluator fitnessEvaluator, NondominatedPopulation archive, double[] initialSearchPoint, boolean checkConsistency, double cc, double cs, double damps, double ccov, double ccovsep, double sigma, int diagonalIterations) {
        super(problem);
        this.lambda = lambda;
        this.initialSearchPoint = initialSearchPoint;
        this.checkConsistency = checkConsistency;
        this.fitnessEvaluator = fitnessEvaluator;
        this.archive = archive;
        this.cc = cc;
        this.cs = cs;
        this.damps = damps;
        this.ccov = ccov;
        this.ccovsep = ccovsep;
        this.sigma = sigma;
        this.diagonalIterations = diagonalIterations;
        this.population = new Population();
    }

    private void preInitChecks(Solution prototypeSolution) {
        if (this.initialSearchPoint != null && this.initialSearchPoint.length != prototypeSolution.getNumberOfVariables()) {
            throw new IllegalArgumentException("initial search point is not the correct length (expected=" + prototypeSolution.getNumberOfVariables() + ", actual=" + this.initialSearchPoint.length + ")");
        }
        for (int i = 0; i < this.problem.getNumberOfVariables(); ++i) {
            if (prototypeSolution.getVariable(i) instanceof RealVariable) {
                RealVariable variable = (RealVariable)prototypeSolution.getVariable(i);
                if (this.initialSearchPoint == null) continue;
                if (this.initialSearchPoint[i] > variable.getUpperBound()) {
                    throw new IllegalArgumentException("initial search point is out of bounds (index=" + i + ", value=" + this.initialSearchPoint[i] + ", ub=" + variable.getUpperBound() + ")");
                }
                if (!(this.initialSearchPoint[i] < variable.getLowerBound())) continue;
                throw new IllegalArgumentException("initial search point is out of bounds (index=" + i + ", value=" + this.initialSearchPoint[i] + ", lb=" + variable.getLowerBound() + ")");
            }
            throw new IllegalArgumentException("CMA-ES is only applicable to real-valued decision variables");
        }
    }

    private void postInitChecks() {
        if (this.problem.getNumberOfVariables() == 0) {
            throw new IllegalArgumentException("dimension must be greater than zero");
        }
        if (this.lambda <= 1) {
            throw new IllegalArgumentException("offspring population size, lambda, must be greater than one (lambda=" + this.lambda + ")");
        }
        if (this.mu < 1) {
            throw new IllegalArgumentException("number of parents used in recombination, mu, must be smaller or equal to lambda (lambda=" + this.lambda + ", mu=" + this.mu + ")");
        }
        if (this.cs <= 0.0 || this.cs > 1.0) {
            throw new IllegalArgumentException("0 < cs <= 1 must hold for step-size cumulation parameter (cs=" + this.cs + ")");
        }
        if (this.damps <= 0.0) {
            throw new IllegalArgumentException("step size damping parameter, damps, must be greater than zero (damps=" + this.damps + ")");
        }
        if (this.cc <= 0.0 || this.cc > 1.0) {
            throw new IllegalArgumentException("0 < cc <= 1 must hold for cumulation parameter (cc=" + this.cc + ")");
        }
        if (this.mueff < 0.0) {
            throw new IllegalArgumentException("mueff >= 0 must hold (mueff=" + this.mueff + ")");
        }
        if (this.ccov < 0.0) {
            throw new IllegalArgumentException("ccov >= 0 must hold (ccov=" + this.ccov + ")");
        }
        if (this.ccovsep < 0.0) {
            throw new IllegalArgumentException("ccovsep >= 0 must hold (ccovsep=" + this.ccovsep + ")");
        }
        if (this.sigma <= 0.0) {
            throw new IllegalArgumentException("initial standard deviation, sigma, must be positive (sigma=" + this.sigma + ")");
        }
        if (StatUtils.min((double[])this.diagD) <= 0.0) {
            throw new IllegalArgumentException("initial standard deviations, diagD, must be positive");
        }
    }

    @Override
    public void initialize() {
        int i;
        super.initialize();
        int N = this.problem.getNumberOfVariables();
        Solution prototypeSolution = this.problem.newSolution();
        this.preInitChecks(prototypeSolution);
        if (this.sigma < 0.0) {
            this.sigma = 0.5;
        }
        if (this.diagonalIterations < 0) {
            this.diagonalIterations = 150 * N / this.lambda;
        }
        this.diagD = new double[N];
        this.pc = new double[N];
        this.ps = new double[N];
        this.B = new double[N][N];
        this.C = new double[N][N];
        for (i = 0; i < N; ++i) {
            int j;
            this.pc[i] = 0.0;
            this.ps[i] = 0.0;
            this.diagD[i] = 1.0;
            for (j = 0; j < N; ++j) {
                this.B[i][j] = 0.0;
            }
            for (j = 0; j < i; ++j) {
                this.C[i][j] = 0.0;
            }
            this.B[i][i] = 1.0;
            this.C[i][i] = this.diagD[i] * this.diagD[i];
        }
        if (this.xmean == null) {
            this.xmean = new double[N];
            if (this.initialSearchPoint == null) {
                for (i = 0; i < N; ++i) {
                    RealVariable variable = (RealVariable)prototypeSolution.getVariable(i);
                    double offset = this.sigma * this.diagD[i];
                    double range = variable.getUpperBound() - variable.getLowerBound() - 2.0 * this.sigma * this.diagD[i];
                    if (offset > 0.4 * (variable.getUpperBound() - variable.getLowerBound())) {
                        offset = 0.4 * (variable.getUpperBound() - variable.getLowerBound());
                        range = 0.2 * (variable.getUpperBound() - variable.getLowerBound());
                    }
                    this.xmean[i] = variable.getLowerBound() + offset + PRNG.nextDouble() * range;
                }
            } else {
                for (i = 0; i < N; ++i) {
                    this.xmean[i] = this.initialSearchPoint[i] + this.sigma * this.diagD[i] * PRNG.nextGaussian();
                }
            }
        }
        this.chiN = Math.sqrt(N) * (1.0 - 1.0 / (4.0 * (double)N) + 1.0 / (21.0 * (double)N * (double)N));
        this.mu = (int)Math.floor((double)this.lambda / 2.0);
        this.weights = new double[this.mu];
        for (i = 0; i < this.mu; ++i) {
            this.weights[i] = Math.log(this.mu + 1) - Math.log(i + 1);
        }
        double sum = StatUtils.sum((double[])this.weights);
        int i2 = 0;
        while (i2 < this.mu) {
            int n = i2++;
            this.weights[n] = this.weights[n] / sum;
        }
        double sumSq = StatUtils.sumSq((double[])this.weights);
        this.mueff = 1.0 / sumSq;
        if (this.cs < 0.0) {
            this.cs = (this.mueff + 2.0) / ((double)N + this.mueff + 3.0);
        }
        if (this.damps < 0.0) {
            this.damps = 1.0 + 2.0 * Math.max(0.0, Math.sqrt((this.mueff - 1.0) / (double)(N + 1)) - 1.0) + this.cs;
        }
        if (this.cc < 0.0) {
            this.cc = 4.0 / ((double)N + 4.0);
        }
        if (this.ccov < 0.0) {
            this.ccov = 2.0 / ((double)N + 1.41) / ((double)N + 1.41) / this.mueff + (1.0 - 1.0 / this.mueff) * Math.min(1.0, (2.0 * this.mueff - 1.0) / (this.mueff + (double)((N + 2) * (N + 2))));
        }
        if (this.ccovsep < 0.0) {
            this.ccovsep = Math.min(1.0, this.ccov * ((double)N + 1.5) / 3.0);
        }
        this.postInitChecks();
    }

    private void eigendecomposition() {
        int N = this.problem.getNumberOfVariables();
        this.lastEigenupdate = this.iteration;
        if (this.diagonalIterations >= this.iteration) {
            for (int i = 0; i < N; ++i) {
                this.diagD[i] = Math.sqrt(this.C[i][i]);
            }
        } else {
            for (int i = 0; i < N; ++i) {
                for (int j = 0; j <= i; ++j) {
                    double d = this.C[i][j];
                    this.B[j][i] = d;
                    this.B[i][j] = d;
                }
            }
            double[] offdiag = new double[N];
            CMAES.tred2(N, this.B, this.diagD, offdiag);
            CMAES.tql2(N, this.diagD, offdiag, this.B);
            if (this.checkConsistency) {
                CMAES.checkEigenSystem(N, this.C, this.diagD, this.B);
            }
            for (int i = 0; i < N; ++i) {
                if (this.diagD[i] < 0.0) {
                    System.err.println("an eigenvalue has become negative");
                    this.diagD[i] = 0.0;
                }
                this.diagD[i] = Math.sqrt(this.diagD[i]);
            }
        }
    }

    private void testAndCorrectNumerics() {
        if (this.population.size() > 0) {
            this.population.sort(new ObjectiveComparator(0));
            if (this.population.get(0).getObjective(0) == this.population.get(Math.min(this.lambda - 1, this.lambda / 2 + 1) - 1).getObjective(0)) {
                System.err.println("flat fitness landscape, consider reformulation of fitness, step size increased");
                this.sigma *= Math.exp(0.2 + this.cs / this.damps);
            }
        }
        double fac = 1.0;
        if (StatUtils.max((double[])this.diagD) < 1.0E-6) {
            fac = 1.0 / StatUtils.max((double[])this.diagD);
        } else if (StatUtils.min((double[])this.diagD) > 10000.0) {
            fac = 1.0 / StatUtils.min((double[])this.diagD);
        }
        if (fac != 1.0) {
            this.sigma /= fac;
            for (int i = 0; i < this.problem.getNumberOfVariables(); ++i) {
                int n = i;
                this.pc[n] = this.pc[n] * fac;
                int n2 = i;
                this.diagD[n2] = this.diagD[n2] * fac;
                int j = 0;
                while (j <= i) {
                    double[] dArray = this.C[i];
                    int n3 = j++;
                    dArray[n3] = dArray[n3] * (fac * fac);
                }
            }
        }
    }

    private void samplePopulation() {
        boolean feasible = true;
        int N = this.problem.getNumberOfVariables();
        if ((double)(this.iteration - this.lastEigenupdate) > 1.0 / this.ccov / (double)N / 5.0) {
            this.eigendecomposition();
        }
        if (this.checkConsistency) {
            this.testAndCorrectNumerics();
        }
        this.population.clear();
        for (int i = 0; i < this.lambda; ++i) {
            Solution solution = this.problem.newSolution();
            if (this.diagonalIterations >= this.iteration) {
                block1: do {
                    feasible = true;
                    for (int j = 0; j < N; ++j) {
                        RealVariable variable = (RealVariable)solution.getVariable(j);
                        double value = this.xmean[j] + this.sigma * this.diagD[j] * PRNG.nextGaussian();
                        if (value < variable.getLowerBound() || value > variable.getUpperBound()) {
                            feasible = false;
                            continue block1;
                        }
                        variable.setValue(value);
                    }
                } while (!feasible);
            } else {
                double[] artmp = new double[N];
                block3: do {
                    int j;
                    feasible = true;
                    for (j = 0; j < N; ++j) {
                        artmp[j] = this.diagD[j] * PRNG.nextGaussian();
                    }
                    for (j = 0; j < N; ++j) {
                        RealVariable variable = (RealVariable)solution.getVariable(j);
                        double sum = 0.0;
                        for (int k = 0; k < N; ++k) {
                            sum += this.B[j][k] * artmp[k];
                        }
                        double value = this.xmean[j] + this.sigma * sum;
                        if (value < variable.getLowerBound() || value > variable.getUpperBound()) {
                            feasible = false;
                            continue block3;
                        }
                        variable.setValue(value);
                    }
                } while (!feasible);
            }
            this.population.add(solution);
        }
        ++this.iteration;
    }

    private void updateDistribution() {
        int i;
        int i2;
        int N = this.problem.getNumberOfVariables();
        double[] xold = Arrays.copyOf(this.xmean, this.xmean.length);
        double[] BDz = new double[N];
        double[] artmp = new double[N];
        if (this.problem.getNumberOfObjectives() == 1) {
            this.population.sort(new SingleObjectiveComparator());
        } else if (this.fitnessEvaluator == null) {
            this.population.sort(new NondominatedSortingComparator());
        } else {
            this.population.sort(new NondominatedFitnessComparator());
        }
        for (i2 = 0; i2 < N; ++i2) {
            this.xmean[i2] = 0.0;
            for (int j = 0; j < this.mu; ++j) {
                int n = i2;
                this.xmean[n] = this.xmean[n] + this.weights[j] * EncodingUtils.getReal(this.population.get(j).getVariable(i2));
            }
            BDz[i2] = Math.sqrt(this.mueff) * (this.xmean[i2] - xold[i2]) / this.sigma;
        }
        if (this.diagonalIterations >= this.iteration) {
            for (i2 = 0; i2 < N; ++i2) {
                this.ps[i2] = (1.0 - this.cs) * this.ps[i2] + Math.sqrt(this.cs * (2.0 - this.cs)) * BDz[i2] / this.diagD[i2];
            }
        } else {
            int j;
            for (i2 = 0; i2 < N; ++i2) {
                double sum = 0.0;
                for (j = 0; j < N; ++j) {
                    sum += this.B[j][i2] * BDz[j];
                }
                artmp[i2] = sum / this.diagD[i2];
            }
            for (i2 = 0; i2 < N; ++i2) {
                double sum = 0.0;
                for (j = 0; j < N; ++j) {
                    sum += this.B[i2][j] * artmp[j];
                }
                this.ps[i2] = (1.0 - this.cs) * this.ps[i2] + Math.sqrt(this.cs * (2.0 - this.cs)) * sum;
            }
        }
        double psxps = 0.0;
        for (int i3 = 0; i3 < N; ++i3) {
            psxps += this.ps[i3] * this.ps[i3];
        }
        int hsig = 0;
        if (Math.sqrt(psxps) / Math.sqrt(1.0 - Math.pow(1.0 - this.cs, 2.0 * (double)this.iteration)) / this.chiN < 1.4 + 2.0 / (double)(N + 1)) {
            hsig = 1;
        }
        for (i = 0; i < N; ++i) {
            this.pc[i] = (1.0 - this.cc) * this.pc[i] + (double)hsig * Math.sqrt(this.cc * (2.0 - this.cc)) * BDz[i];
        }
        for (i = 0; i < N; ++i) {
            int j;
            int n = j = this.diagonalIterations >= this.iteration ? i : 0;
            while (j <= i) {
                this.C[i][j] = (1.0 - (this.diagonalIterations >= this.iteration ? this.ccovsep : this.ccov)) * this.C[i][j] + this.ccov * (1.0 / this.mueff) * (this.pc[i] * this.pc[j] + (double)(1 - hsig) * this.cc * (2.0 - this.cc) * this.C[i][j]);
                for (int k = 0; k < this.mu; ++k) {
                    double[] dArray = this.C[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] + this.ccov * (1.0 - 1.0 / this.mueff) * this.weights[k] * (EncodingUtils.getReal(this.population.get(k).getVariable(i)) - xold[i]) * (EncodingUtils.getReal(this.population.get(k).getVariable(j)) - xold[j]) / this.sigma / this.sigma;
                }
                ++j;
            }
        }
        this.sigma *= Math.exp((Math.sqrt(psxps) / this.chiN - 1.0) * this.cs / this.damps);
    }

    @Override
    protected void iterate() {
        this.samplePopulation();
        this.evaluateAll(this.population);
        if (this.problem.getNumberOfObjectives() > 1) {
            new FastNondominatedSorting().evaluate(this.population);
            if (this.fitnessEvaluator != null) {
                this.fitnessEvaluator.evaluate(this.population);
            }
        }
        this.archive.addAll(this.population);
        this.updateDistribution();
    }

    @Override
    public void step() {
        if (this.isTerminated()) {
            throw new AlgorithmTerminationException((Algorithm)this, "algorithm already terminated");
        }
        if (!this.isInitialized()) {
            this.initialize();
            this.iterate();
        } else {
            this.iterate();
        }
    }

    @Override
    public NondominatedPopulation getResult() {
        return this.archive;
    }

    public static void tred2(int n, double[][] V, double[] d, double[] e) {
        int i;
        int j;
        for (j = 0; j < n; ++j) {
            d[j] = V[n - 1][j];
        }
        for (i = n - 1; i > 0; --i) {
            int k;
            double scale = 0.0;
            double h = 0.0;
            for (k = 0; k < i; ++k) {
                scale += Math.abs(d[k]);
            }
            if (scale == 0.0) {
                e[i] = d[i - 1];
                for (int j2 = 0; j2 < i; ++j2) {
                    d[j2] = V[i - 1][j2];
                    V[i][j2] = 0.0;
                    V[j2][i] = 0.0;
                }
            } else {
                int j3;
                int j4;
                for (k = 0; k < i; ++k) {
                    int n2 = k;
                    d[n2] = d[n2] / scale;
                    h += d[k] * d[k];
                }
                double f = d[i - 1];
                double g = Math.sqrt(h);
                if (f > 0.0) {
                    g = -g;
                }
                e[i] = scale * g;
                h -= f * g;
                d[i - 1] = f - g;
                for (j4 = 0; j4 < i; ++j4) {
                    e[j4] = 0.0;
                }
                for (j4 = 0; j4 < i; ++j4) {
                    V[j4][i] = f = d[j4];
                    g = e[j4] + V[j4][j4] * f;
                    for (int k2 = j4 + 1; k2 <= i - 1; ++k2) {
                        g += V[k2][j4] * d[k2];
                        int n3 = k2;
                        e[n3] = e[n3] + V[k2][j4] * f;
                    }
                    e[j4] = g;
                }
                f = 0.0;
                for (j4 = 0; j4 < i; ++j4) {
                    int n4 = j4;
                    e[n4] = e[n4] / h;
                    f += e[j4] * d[j4];
                }
                double hh = f / (h + h);
                for (j3 = 0; j3 < i; ++j3) {
                    int n5 = j3;
                    e[n5] = e[n5] - hh * d[j3];
                }
                for (j3 = 0; j3 < i; ++j3) {
                    f = d[j3];
                    g = e[j3];
                    for (int k3 = j3; k3 <= i - 1; ++k3) {
                        double[] dArray = V[k3];
                        int n6 = j3;
                        dArray[n6] = dArray[n6] - (f * e[k3] + g * d[k3]);
                    }
                    d[j3] = V[i - 1][j3];
                    V[i][j3] = 0.0;
                }
            }
            d[i] = h;
        }
        for (i = 0; i < n - 1; ++i) {
            int k;
            V[n - 1][i] = V[i][i];
            V[i][i] = 1.0;
            double h = d[i + 1];
            if (h != 0.0) {
                for (k = 0; k <= i; ++k) {
                    d[k] = V[k][i + 1] / h;
                }
                for (int j5 = 0; j5 <= i; ++j5) {
                    int k4;
                    double g = 0.0;
                    for (k4 = 0; k4 <= i; ++k4) {
                        g += V[k4][i + 1] * V[k4][j5];
                    }
                    for (k4 = 0; k4 <= i; ++k4) {
                        double[] dArray = V[k4];
                        int n7 = j5;
                        dArray[n7] = dArray[n7] - g * d[k4];
                    }
                }
            }
            for (k = 0; k <= i; ++k) {
                V[k][i + 1] = 0.0;
            }
        }
        for (j = 0; j < n; ++j) {
            d[j] = V[n - 1][j];
            V[n - 1][j] = 0.0;
        }
        V[n - 1][n - 1] = 1.0;
        e[0] = 0.0;
    }

    public static void tql2(int n, double[] d, double[] e, double[][] V) {
        for (int i = 1; i < n; ++i) {
            e[i - 1] = e[i];
        }
        e[n - 1] = 0.0;
        double f = 0.0;
        double tst1 = 0.0;
        double eps = Math.pow(2.0, -52.0);
        for (int l = 0; l < n; ++l) {
            int m;
            tst1 = Math.max(tst1, Math.abs(d[l]) + Math.abs(e[l]));
            for (m = l; m < n && !(Math.abs(e[m]) <= eps * tst1); ++m) {
            }
            if (m > l) {
                int iter = 0;
                do {
                    double c;
                    ++iter;
                    double g = d[l];
                    double p = (d[l + 1] - g) / (2.0 * e[l]);
                    double r = CMAES.hypot(p, 1.0);
                    if (p < 0.0) {
                        r = -r;
                    }
                    d[l] = e[l] / (p + r);
                    d[l + 1] = e[l] * (p + r);
                    double dl1 = d[l + 1];
                    double h = g - d[l];
                    int i = l + 2;
                    while (i < n) {
                        int n2 = i++;
                        d[n2] = d[n2] - h;
                    }
                    f += h;
                    p = d[m];
                    double c2 = c = 1.0;
                    double c3 = c;
                    double el1 = e[l + 1];
                    double s = 0.0;
                    double s2 = 0.0;
                    for (int i2 = m - 1; i2 >= l; --i2) {
                        c3 = c2;
                        c2 = c;
                        s2 = s;
                        g = c * e[i2];
                        h = c * p;
                        r = CMAES.hypot(p, e[i2]);
                        e[i2 + 1] = s * r;
                        s = e[i2] / r;
                        c = p / r;
                        p = c * d[i2] - s * g;
                        d[i2 + 1] = h + s * (c * g + s * d[i2]);
                        for (int k = 0; k < n; ++k) {
                            h = V[k][i2 + 1];
                            V[k][i2 + 1] = s * V[k][i2] + c * h;
                            V[k][i2] = c * V[k][i2] - s * h;
                        }
                    }
                    p = -s * s2 * c3 * el1 * e[l] / dl1;
                    e[l] = s * p;
                    d[l] = c * p;
                } while (Math.abs(e[l]) > eps * tst1);
            }
            d[l] = d[l] + f;
            e[l] = 0.0;
        }
        for (int i = 0; i < n - 1; ++i) {
            int j;
            int k = i;
            double p = d[i];
            for (j = i + 1; j < n; ++j) {
                if (!(d[j] < p)) continue;
                k = j;
                p = d[j];
            }
            if (k == i) continue;
            d[k] = d[i];
            d[i] = p;
            for (j = 0; j < n; ++j) {
                p = V[j][i];
                V[j][i] = V[j][k];
                V[j][k] = p;
            }
        }
    }

    private static int checkEigenSystem(int N, double[][] C, double[] diag, double[][] Q) {
        int res = 0;
        for (int i = 0; i < N; ++i) {
            for (int j = 0; j < N; ++j) {
                double cc = 0.0;
                double dd = 0.0;
                for (int k = 0; k < N; ++k) {
                    cc += diag[k] * Q[i][k] * Q[j][k];
                    dd += Q[i][k] * Q[j][k];
                }
                double[] dArray = C[i > j ? i : j];
                int n = i > j ? j : i;
                if (Math.abs(cc - dArray[n]) / Math.sqrt(C[i][i] * C[j][j]) > 1.0E-10) {
                    double[] dArray2 = C[i > j ? i : j];
                    int n2 = i > j ? j : i;
                    if (Math.abs(cc - dArray2[n2]) > 1.0E-9) {
                        System.err.println("imprecise result detected " + i + " " + j + " " + cc + " " + C[i > j ? i : j][i > j ? j : i] + " " + (cc - C[i > j ? i : j][i > j ? j : i]));
                        ++res;
                    }
                }
                boolean bl = i == j;
                if (!(Math.abs(dd - (double)bl) > 1.0E-10)) continue;
                System.err.println("imprecise result detected (Q not orthog.) " + i + " " + j + " " + dd);
                ++res;
            }
        }
        return res;
    }

    private static double hypot(double a, double b) {
        double r = 0.0;
        if (Math.abs(a) > Math.abs(b)) {
            r = b / a;
            r = Math.abs(a) * Math.sqrt(1.0 + r * r);
        } else if (b != 0.0) {
            r = a / b;
            r = Math.abs(b) * Math.sqrt(1.0 + r * r);
        }
        return r;
    }

    @Override
    public Serializable getState() throws NotSerializableException {
        if (!this.isInitialized()) {
            throw new AlgorithmInitializationException((Algorithm)this, "algorithm not initialized");
        }
        ArrayList<Solution> populationList = new ArrayList<Solution>();
        ArrayList<Solution> archiveList = new ArrayList<Solution>();
        for (Solution solution : this.population) {
            populationList.add(solution);
        }
        if (this.archive != null) {
            for (Solution solution : this.archive) {
                archiveList.add(solution);
            }
        }
        return new CMAESState(populationList, archiveList, this.iteration, this.sigma, (double[])this.diagD.clone(), (double[])this.xmean.clone(), (double[])this.pc.clone(), (double[])this.ps.clone(), (double[][])this.B.clone(), (double[][])this.C.clone(), this.lastEigenupdate);
    }

    @Override
    public void setState(Object objState) throws NotSerializableException {
        CMAESState state = (CMAESState)objState;
        this.xmean = (double[])state.xmean.clone();
        this.initialize();
        this.population.addAll(state.population);
        if (this.archive != null) {
            this.archive.addAll(state.archive);
        }
        this.iteration = state.iteration;
        this.sigma = state.sigma;
        this.diagD = (double[])state.diagD.clone();
        this.pc = (double[])state.pc.clone();
        this.ps = (double[])state.ps.clone();
        this.B = (double[][])state.B.clone();
        this.C = (double[][])state.C.clone();
        this.lastEigenupdate = state.lastEigenupdate;
    }

    private static class CMAESState
    implements Serializable {
        private static final long serialVersionUID = 2634186176589891715L;
        private final List<Solution> population;
        private final List<Solution> archive;
        private int iteration;
        private double sigma;
        private double[] diagD;
        private double[] xmean;
        private double[] pc;
        private double[] ps;
        private double[][] B;
        private double[][] C;
        private int lastEigenupdate;

        public CMAESState(List<Solution> population, List<Solution> archive, int iteration, double sigma, double[] diagD, double[] xmean, double[] pc, double[] ps, double[][] B, double[][] C, int lastEigenupdate) {
            this.population = population;
            this.archive = archive;
            this.iteration = iteration;
            this.sigma = sigma;
            this.diagD = diagD;
            this.xmean = xmean;
            this.pc = pc;
            this.ps = ps;
            this.B = B;
            this.C = C;
            this.lastEigenupdate = lastEigenupdate;
        }
    }

    private class SingleObjectiveComparator
    extends ChainedComparator
    implements Comparator<Solution>,
    Serializable {
        private static final long serialVersionUID = 6182830776461513578L;

        public SingleObjectiveComparator() {
            super(new AggregateConstraintComparator(), new ObjectiveComparator(0));
        }
    }

    private class NondominatedFitnessComparator
    extends ChainedComparator
    implements Comparator<Solution>,
    Serializable {
        private static final long serialVersionUID = -4088873047790962685L;

        public NondominatedFitnessComparator() {
            super(new RankComparator(), new FitnessComparator(CMAES.this.fitnessEvaluator.areLargerValuesPreferred()));
        }
    }
}

