/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import org.moeaframework.algorithm.PeriodicAction;
import org.moeaframework.core.Algorithm;

public class Checkpoints
extends PeriodicAction {
    private final File stateFile;

    public Checkpoints(Algorithm algorithm, File stateFile, int checkpointFrequency) {
        super(algorithm, checkpointFrequency, PeriodicAction.FrequencyType.EVALUATIONS);
        this.stateFile = stateFile;
        if (stateFile.exists() && stateFile.length() != 0L) {
            try {
                algorithm.setState(this.loadState());
            }
            catch (Exception e) {
                e.printStackTrace();
                System.err.println("an error occurred while reading the state file");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveState(Serializable state) throws IOException {
        ObjectOutputStream oos = null;
        try {
            oos = new ObjectOutputStream(new BufferedOutputStream(new FileOutputStream(this.stateFile)));
            oos.writeObject(state);
        }
        finally {
            if (oos != null) {
                oos.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object loadState() throws IOException, ClassNotFoundException {
        ObjectInputStream ois = null;
        try {
            ois = new ObjectInputStream(new BufferedInputStream(new FileInputStream(this.stateFile)));
            Object object = ois.readObject();
            return object;
        }
        finally {
            if (ois != null) {
                ois.close();
            }
        }
    }

    @Override
    public void doAction() {
        try {
            this.saveState(this.algorithm.getState());
        }
        catch (IOException e) {
            System.err.println("an error occurred while writing the state file");
        }
    }
}

