/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.math3.linear.Array2DRowRealMatrix;
import org.apache.commons.math3.linear.LUDecomposition;
import org.apache.commons.math3.linear.MatrixUtils;
import org.apache.commons.math3.linear.RealMatrix;
import org.moeaframework.algorithm.AbstractEvolutionaryAlgorithm;
import org.moeaframework.core.Initialization;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;
import org.moeaframework.core.comparator.ObjectiveComparator;

public class DBEA
extends AbstractEvolutionaryAlgorithm {
    static boolean TESTING_MODE = false;
    double[] idealPoint;
    double[] intercepts;
    List<double[]> weights;
    Population corner;
    private final Variation variation;
    private final int divisionsOuter;
    private final int divisionsInner;

    public DBEA(Problem problem, Initialization initialization, Variation variation, int divisionsOuter, int divisionsInner) {
        super(problem, new Population(), null, initialization);
        this.variation = variation;
        this.divisionsOuter = divisionsOuter;
        this.divisionsInner = divisionsInner;
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.generateWeights();
        this.preserveCorner();
        this.initializeIdealPointAndIntercepts();
    }

    void generateWeights() {
        if (this.divisionsInner > 0) {
            if (this.divisionsOuter >= this.problem.getNumberOfObjectives()) {
                System.err.println("The specified number of outer divisions produces intermediate reference points, recommend setting divisionsOuter < numberOfObjectives.");
            }
            this.weights = this.generateWeights(this.divisionsOuter);
            List<double[]> inner = this.generateWeights(this.divisionsInner);
            for (int i = 0; i < inner.size(); ++i) {
                double[] weight = inner.get(i);
                for (int j = 0; j < weight.length; ++j) {
                    weight[j] = (1.0 / (double)this.problem.getNumberOfObjectives() + weight[j]) / 2.0;
                }
            }
            this.weights.addAll(inner);
        } else {
            if (this.divisionsOuter < this.problem.getNumberOfObjectives()) {
                System.err.println("No intermediate reference points will be generated for the specified number of divisions, recommend increasing divisions");
            }
            this.weights = this.generateWeights(this.divisionsOuter);
        }
    }

    void preserveCorner() {
        Population feasibleSolutions = this.getFeasibleSolutions(this.population);
        if (feasibleSolutions.size() >= 2 * this.problem.getNumberOfObjectives()) {
            this.corner = this.corner_sort(feasibleSolutions);
        }
    }

    int[] randomPermutation(int length) {
        int[] permutation = new int[length];
        for (int i = 0; i < length; ++i) {
            permutation[i] = i;
        }
        PRNG.shuffle(permutation);
        return permutation;
    }

    @Override
    protected void iterate() {
        int[] permutation = this.randomPermutation(this.population.size());
        for (int i = 0; i < this.population.size(); ++i) {
            int n = permutation[i];
            Solution[] parents = new Solution[]{this.population.get(i), this.population.get(n)};
            Solution[] children = this.variation.evolve(parents);
            this.evaluate(children[0]);
            if (this.checkDomination(children[0])) continue;
            this.updateIdealPointAndIntercepts(children[0]);
            this.updatePopulation(children[0]);
        }
        this.preserveCorner();
    }

    private Population getFeasibleSolutions(Population population) {
        Population feasibleSolutions = new Population();
        for (Solution solution : population) {
            if (solution.violatesConstraints()) continue;
            feasibleSolutions.add(solution);
        }
        return feasibleSolutions;
    }

    private Population getNondominatedFront(Population population) {
        NondominatedPopulation front = new NondominatedPopulation();
        front.addAll(population);
        return front;
    }

    void initializeIdealPointAndIntercepts() {
        this.idealPoint = new double[this.problem.getNumberOfObjectives()];
        this.intercepts = new double[this.problem.getNumberOfObjectives()];
        for (int i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            this.idealPoint[i] = Double.POSITIVE_INFINITY;
            this.intercepts[i] = Double.NEGATIVE_INFINITY;
        }
        Population feasibleSolutions = this.getFeasibleSolutions(this.population);
        if (!feasibleSolutions.isEmpty()) {
            for (int i = 0; i < feasibleSolutions.size(); ++i) {
                for (int j = 0; j < this.problem.getNumberOfObjectives(); ++j) {
                    this.idealPoint[j] = Math.min(this.idealPoint[j], feasibleSolutions.get(i).getObjective(j));
                    this.intercepts[j] = Math.max(this.intercepts[j], feasibleSolutions.get(i).getObjective(j));
                }
            }
        }
    }

    private Solution largestObjectiveValue(int objective, Population population) {
        Solution largest = null;
        double value = Double.NEGATIVE_INFINITY;
        for (Solution solution : population) {
            if (!(solution.getObjective(objective) > value)) continue;
            largest = solution;
            value = solution.getObjective(objective);
        }
        return largest;
    }

    private Population orderBySmallestObjective(int objective, Population population) {
        Population result = new Population();
        result.addAll(population);
        result.sort(new ObjectiveComparator(objective));
        return result;
    }

    private Population orderBySmallestSquaredValue(final int objective, Population population) {
        Population result = new Population();
        result.addAll(population);
        result.sort((Comparator<? super Solution>)new Comparator<Solution>(){

            @Override
            public int compare(Solution s1, Solution s2) {
                double sum1 = 0.0;
                double sum2 = 0.0;
                for (int i = 0; i < DBEA.this.problem.getNumberOfObjectives(); ++i) {
                    if (i == objective) continue;
                    sum1 += Math.pow(s1.getObjective(i), 2.0);
                    sum2 += Math.pow(s2.getObjective(i), 2.0);
                }
                return Double.compare(sum1, sum2);
            }
        });
        return result;
    }

    private int numberOfUniqueSolutions(Population population) {
        int count = 0;
        block0: for (int i = 0; i < population.size(); ++i) {
            boolean isDuplicate = false;
            for (int j = 0; j < i; ++j) {
                if (population.get(j) == population.get(i) || Arrays.equals(population.get(j).getObjectives(), population.get(i).getObjectives())) {
                    isDuplicate = true;
                    continue block0;
                }
                if (isDuplicate) continue;
                ++count;
            }
        }
        return count;
    }

    void updateIdealPointAndIntercepts(Solution solution) {
        block12: {
            if (solution.violatesConstraints()) break block12;
            for (int j = 0; j < this.problem.getNumberOfObjectives(); ++j) {
                this.idealPoint[j] = Math.min(this.idealPoint[j], solution.getObjective(j));
                this.intercepts[j] = Math.max(this.intercepts[j], solution.getObjective(j));
            }
            Population feasibleSolutions = this.getFeasibleSolutions(this.population);
            feasibleSolutions.add(solution);
            Population nondominatedSolutions = this.getNondominatedFront(feasibleSolutions);
            if (!nondominatedSolutions.isEmpty()) {
                int i;
                Population extremePoints = new Population();
                for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
                    extremePoints.add(this.largestObjectiveValue(i, nondominatedSolutions));
                }
                if (this.numberOfUniqueSolutions(extremePoints) != this.problem.getNumberOfObjectives()) {
                    for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
                        this.intercepts[i] = extremePoints.get(i).getObjective(i);
                    }
                } else {
                    try {
                        Array2DRowRealMatrix b = new Array2DRowRealMatrix(this.problem.getNumberOfObjectives(), 1);
                        Array2DRowRealMatrix A = new Array2DRowRealMatrix(this.problem.getNumberOfObjectives(), this.problem.getNumberOfObjectives());
                        for (int i2 = 0; i2 < this.problem.getNumberOfObjectives(); ++i2) {
                            b.setEntry(i2, 0, 1.0);
                            for (int j = 0; j < this.problem.getNumberOfObjectives(); ++j) {
                                A.setEntry(i2, j, extremePoints.get(i2).getObjective(j));
                            }
                        }
                        double numerator = new LUDecomposition((RealMatrix)A).getDeterminant();
                        b.scalarMultiply(numerator);
                        RealMatrix normal = MatrixUtils.inverse((RealMatrix)A).multiply((RealMatrix)b);
                        for (int i3 = 0; i3 < this.problem.getNumberOfObjectives(); ++i3) {
                            this.intercepts[i3] = numerator / normal.getEntry(i3, 0);
                            if (!(this.intercepts[i3] <= 0.0) && !Double.isNaN(this.intercepts[i3]) && !Double.isInfinite(this.intercepts[i3])) continue;
                            this.intercepts[i3] = extremePoints.get(i3).getObjective(i3);
                        }
                    }
                    catch (RuntimeException e) {
                        for (int i4 = 0; i4 < this.problem.getNumberOfObjectives(); ++i4) {
                            this.intercepts[i4] = extremePoints.get(i4).getObjective(i4);
                        }
                    }
                }
            }
        }
    }

    private double sumOfConstraintViolations(Solution solution) {
        double result = 0.0;
        for (int i = 0; i < solution.getNumberOfConstraints(); ++i) {
            result += Math.abs(solution.getConstraint(i));
        }
        return result;
    }

    double constraintApproach(Population population) {
        double feasible = 1.0;
        double violation = 0.0;
        for (int i = 0; i < population.size(); ++i) {
            if (population.get(i).violatesConstraints()) {
                violation += this.sumOfConstraintViolations(population.get(i));
                continue;
            }
            feasible += 1.0;
        }
        return feasible / (double)population.size() * (violation / (double)population.size());
    }

    void updatePopulation(Solution child) {
        int i;
        double eps = 0.0;
        double eps_con = this.constraintApproach(this.population);
        boolean success = false;
        if (this.corner != null && !child.violatesConstraints()) {
            this.corner.add(child);
            this.corner = this.corner_sort(this.corner);
        }
        double[] f2 = this.normalizedObjectives(child);
        int[] order = this.randomPermutation(this.population.size());
        if (TESTING_MODE) {
            for (i = 0; i < order.length; ++i) {
                order[i] = i;
            }
        }
        for (i = 0; i < this.population.size(); ++i) {
            int j = order[i];
            double[] weight = this.weights.get(j);
            double[] f1 = this.normalizedObjectives(this.population.get(j));
            double d1_parent = this.distanceD1(f1, weight);
            double d1_child = this.distanceD1(f2, weight);
            double d2_parent = this.distanceD2(f1, d1_parent);
            double d2_child = this.distanceD2(f2, d1_child);
            double cv_parent = this.sumOfConstraintViolations(this.population.get(j));
            double cv_child = this.sumOfConstraintViolations(child);
            if ((cv_child < eps_con && cv_parent < eps_con || cv_child == cv_parent) && this.compareSolution(d1_child, d2_child, d1_parent, d2_parent, eps)) {
                this.population.replace(j, child);
                success = true;
            }
            if (cv_child < cv_parent) {
                this.population.replace(j, child);
                success = true;
            }
            if (success) break;
        }
    }

    Population corner_sort(Population population) {
        int i;
        Population unique = new Population();
        Population duplicates = new Population();
        for (int i2 = 0; i2 < population.size(); ++i2) {
            if (unique.contains(population.get(i2))) {
                duplicates.add(population.get(i2));
                continue;
            }
            boolean isDuplicate = false;
            for (int j = 0; j < unique.size(); ++j) {
                if (!Arrays.equals(unique.get(j).getObjectives(), population.get(i2).getObjectives())) continue;
                duplicates.add(population.get(i2));
                isDuplicate = true;
                break;
            }
            if (isDuplicate) continue;
            unique.add(population.get(i2));
        }
        ArrayList<Population> sortedSets = new ArrayList<Population>();
        for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            sortedSets.add(this.orderBySmallestObjective(i, unique));
        }
        for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            sortedSets.add(this.orderBySmallestSquaredValue(i, unique));
        }
        Population result = new Population();
        int current_id = 0;
        int current_f = 0;
        while (result.size() < unique.size()) {
            Solution r = ((Population)sortedSets.get(current_f)).get(current_id);
            if (!result.contains(r)) {
                result.add(r);
            }
            if (++current_f < 2 * this.problem.getNumberOfObjectives()) continue;
            current_f = 0;
            ++current_id;
        }
        result.addAll(duplicates);
        Population prunedSet = new Population();
        for (int i3 = 0; i3 < 2 * this.problem.getNumberOfObjectives(); ++i3) {
            prunedSet.add(result.get(i3));
        }
        return prunedSet;
    }

    boolean checkDomination(Solution solution) {
        if (solution.violatesConstraints()) {
            return false;
        }
        Population combinedPopulation = new Population();
        combinedPopulation.addAll(this.population);
        if (this.corner != null) {
            combinedPopulation.addAll(this.corner);
        }
        for (Solution otherSolution : this.getFeasibleSolutions(combinedPopulation)) {
            int count = 0;
            for (int i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
                if (!(otherSolution.getObjective(i) < solution.getObjective(i))) continue;
                ++count;
            }
            if (count != this.problem.getNumberOfObjectives()) continue;
            return true;
        }
        return false;
    }

    private double distanceD1(double[] f, double[] w) {
        double dn = this.normVector(w);
        for (int j = 0; j < this.problem.getNumberOfObjectives(); ++j) {
            w[j] = w[j] / dn;
        }
        return this.innerproduct(f, w);
    }

    private double distanceD2(double[] f, double d1) {
        return Math.sqrt(Math.pow(this.normVector(f), 2.0) - Math.pow(d1, 2.0));
    }

    private double normVector(double[] z) {
        double sum = 0.0;
        for (int i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
            sum += z[i] * z[i];
        }
        return Math.sqrt(sum);
    }

    private double innerproduct(double[] vec1, double[] vec2) {
        double sum = 0.0;
        for (int i = 0; i < vec1.length; ++i) {
            sum += vec1[i] * vec2[i];
        }
        return sum;
    }

    private boolean compareSolution(double d1_child, double d2_child, double d1_parent, double d2_parent, double eps) {
        return d2_child == d2_parent || d2_child < eps && d2_parent < eps ? d1_child < d1_parent : d2_child < d2_parent;
    }

    private double[] normalizedObjectives(Solution solution) {
        double[] objectiveValues = new double[this.problem.getNumberOfObjectives()];
        for (int j = 0; j < this.problem.getNumberOfObjectives(); ++j) {
            objectiveValues[j] = (solution.getObjective(j) - this.idealPoint[j]) / (this.intercepts[j] - this.idealPoint[j]);
        }
        return objectiveValues;
    }

    private List<double[]> generateWeights(int divisions) {
        ArrayList<double[]> result = new ArrayList<double[]>();
        double[] weight = new double[this.problem.getNumberOfObjectives()];
        this.generateRecursive(result, weight, this.problem.getNumberOfObjectives(), divisions, divisions, 0);
        return result;
    }

    private void generateRecursive(List<double[]> weights, double[] weight, int numberOfObjectives, int left, int total, int index) {
        if (index == numberOfObjectives - 1) {
            weight[index] = (double)left / (double)total;
            weights.add((double[])weight.clone());
        } else {
            for (int i = 0; i <= left; ++i) {
                weight[index] = (double)i / (double)total;
                this.generateRecursive(weights, weight, numberOfObjectives, left - i, total, index + 1);
            }
        }
    }

    @Override
    public NondominatedPopulation getResult() {
        NondominatedPopulation result = super.getResult();
        result.addAll(this.corner);
        return result;
    }
}

