/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import java.util.ArrayList;
import org.apache.commons.lang3.ArrayUtils;
import org.moeaframework.algorithm.AbstractEvolutionaryAlgorithm;
import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.EpsilonBoxEvolutionaryAlgorithm;
import org.moeaframework.core.Initialization;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Selection;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;
import org.moeaframework.core.comparator.DominanceComparator;
import org.moeaframework.core.comparator.ParetoDominanceComparator;

public class EpsilonMOEA
extends AbstractEvolutionaryAlgorithm
implements EpsilonBoxEvolutionaryAlgorithm {
    private final DominanceComparator dominanceComparator;
    private final Selection selection;
    private final Variation variation;

    public EpsilonMOEA(Problem problem, Population population, EpsilonBoxDominanceArchive archive, Selection selection, Variation variation, Initialization initialization) {
        this(problem, population, archive, selection, variation, initialization, new ParetoDominanceComparator());
    }

    public EpsilonMOEA(Problem problem, Population population, EpsilonBoxDominanceArchive archive, Selection selection, Variation variation, Initialization initialization, DominanceComparator dominanceComparator) {
        super(problem, population, archive, initialization);
        this.variation = variation;
        this.selection = selection;
        this.dominanceComparator = dominanceComparator;
    }

    @Override
    public void iterate() {
        Solution[] children;
        Solution[] parents = null;
        parents = this.archive.size() <= 1 ? this.selection.select(this.variation.getArity(), this.population) : (Solution[])ArrayUtils.add((Object[])this.selection.select(this.variation.getArity() - 1, this.population), (Object)this.archive.get(PRNG.nextInt(this.archive.size())));
        PRNG.shuffle(parents);
        for (Solution child : children = this.variation.evolve(parents)) {
            this.evaluate(child);
            this.addToPopulation(child);
            this.archive.add(child);
        }
    }

    protected void addToPopulation(Solution newSolution) {
        ArrayList<Integer> dominates = new ArrayList<Integer>();
        boolean dominated = false;
        for (int i = 0; i < this.population.size(); ++i) {
            int flag = this.dominanceComparator.compare(newSolution, this.population.get(i));
            if (flag < 0) {
                dominates.add(i);
                continue;
            }
            if (flag <= 0) continue;
            dominated = true;
        }
        if (!dominates.isEmpty()) {
            this.population.remove((Integer)dominates.get(PRNG.nextInt(dominates.size())));
            this.population.add(newSolution);
        } else if (!dominated) {
            this.population.remove(PRNG.nextInt(this.population.size()));
            this.population.add(newSolution);
        }
    }

    @Override
    public EpsilonBoxDominanceArchive getArchive() {
        return (EpsilonBoxDominanceArchive)super.getArchive();
    }
}

