/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.moeaframework.algorithm.AdaptiveTimeContinuation;
import org.moeaframework.algorithm.RestartType;
import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.EpsilonBoxEvolutionaryAlgorithm;
import org.moeaframework.core.Selection;
import org.moeaframework.core.Variation;

public class EpsilonProgressContinuation
extends AdaptiveTimeContinuation {
    private int improvementsAtLastCheck;

    public EpsilonProgressContinuation(EpsilonBoxEvolutionaryAlgorithm algorithm, int windowSize, int maxWindowSize, double populationRatio, int minimumPopulationSize, int maximumPopulationSize, Selection selection, Variation variation) {
        super(algorithm, windowSize, maxWindowSize, populationRatio, minimumPopulationSize, maximumPopulationSize, selection, variation);
    }

    @Override
    public EpsilonBoxDominanceArchive getArchive() {
        return (EpsilonBoxDominanceArchive)super.getArchive();
    }

    @Override
    protected RestartType check() {
        RestartType superType = super.check();
        if (superType.equals((Object)RestartType.NONE) && this.getArchive().getNumberOfImprovements() <= this.improvementsAtLastCheck) {
            superType = RestartType.HARD;
        }
        this.improvementsAtLastCheck = this.getArchive().getNumberOfImprovements();
        return superType;
    }

    @Override
    protected void restart(RestartType type) {
        super.restart(type);
        this.improvementsAtLastCheck = this.getArchive().getNumberOfImprovements();
    }

    @Override
    public Serializable getState() throws NotSerializableException {
        return new EpsilonProgressContinuationState(super.getState(), this.improvementsAtLastCheck);
    }

    @Override
    public void setState(Object objState) throws NotSerializableException {
        EpsilonProgressContinuationState state = (EpsilonProgressContinuationState)objState;
        super.setState(state.getAlgorithmState());
        this.improvementsAtLastCheck = state.getImprovementsAtLastCheck();
    }

    private static class EpsilonProgressContinuationState
    implements Serializable {
        private static final long serialVersionUID = -4773227519517581809L;
        private final Serializable algorithmState;
        private final int improvementsAtLastCheck;

        public EpsilonProgressContinuationState(Serializable algorithmState, int improvementsAtLastCheck) {
            this.algorithmState = algorithmState;
            this.improvementsAtLastCheck = improvementsAtLastCheck;
        }

        public Serializable getAlgorithmState() {
            return this.algorithmState;
        }

        public int getImprovementsAtLastCheck() {
            return this.improvementsAtLastCheck;
        }
    }
}

