/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import org.moeaframework.algorithm.AbstractEvolutionaryAlgorithm;
import org.moeaframework.core.Initialization;
import org.moeaframework.core.NondominatedSortingPopulation;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.comparator.DominanceComparator;
import org.moeaframework.core.operator.real.DifferentialEvolution;
import org.moeaframework.core.operator.real.DifferentialEvolutionSelection;

public class GDE3
extends AbstractEvolutionaryAlgorithm {
    private final DominanceComparator comparator;
    private final DifferentialEvolutionSelection selection;
    private final DifferentialEvolution variation;

    public GDE3(Problem problem, NondominatedSortingPopulation population, DominanceComparator comparator, DifferentialEvolutionSelection selection, DifferentialEvolution variation, Initialization initialization) {
        super(problem, population, null, initialization);
        this.comparator = comparator;
        this.selection = selection;
        this.variation = variation;
    }

    @Override
    public void iterate() {
        NondominatedSortingPopulation population = this.getPopulation();
        Population children = new Population();
        int populationSize = population.size();
        for (int i = 0; i < populationSize; ++i) {
            this.selection.setCurrentIndex(i);
            Solution[] parents = this.selection.select(this.variation.getArity(), population);
            children.add(this.variation.evolve(parents)[0]);
        }
        this.evaluateAll(children);
        Population offspring = new Population();
        for (int i = 0; i < populationSize; ++i) {
            int result = this.comparator.compare(children.get(i), population.get(i));
            if (result < 0) {
                offspring.add(children.get(i));
                continue;
            }
            if (result > 0) {
                offspring.add(population.get(i));
                continue;
            }
            offspring.add(children.get(i));
            offspring.add(population.get(i));
        }
        population.clear();
        population.addAll(offspring);
        population.prune(populationSize);
    }

    @Override
    public NondominatedSortingPopulation getPopulation() {
        return (NondominatedSortingPopulation)super.getPopulation();
    }
}

