/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.math3.util.MathArrays;
import org.moeaframework.algorithm.AbstractAlgorithm;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.Initialization;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;
import org.moeaframework.util.weights.RandomGenerator;
import org.moeaframework.util.weights.WeightGenerator;

public class MOEAD
extends AbstractAlgorithm {
    private List<Individual> population;
    private double[] idealPoint;
    private final int neighborhoodSize;
    private final WeightGenerator weightGenerator;
    private final double delta;
    private final double eta;
    private final Initialization initialization;
    private final Variation variation;
    private final int updateUtility;
    private int generation;

    public MOEAD(Problem problem, int neighborhoodSize, Initialization initialization, Variation variation, double delta, double eta, int updateUtility) {
        this(problem, neighborhoodSize, null, initialization, variation, delta, eta, updateUtility);
    }

    public MOEAD(Problem problem, int neighborhoodSize, Initialization initialization, Variation variation, double delta, double eta) {
        this(problem, neighborhoodSize, initialization, variation, delta, eta, -1);
    }

    public MOEAD(Problem problem, int neighborhoodSize, WeightGenerator weightGenerator, Initialization initialization, Variation variation, double delta, double eta, int updateUtility) {
        super(problem);
        this.neighborhoodSize = neighborhoodSize;
        this.weightGenerator = weightGenerator;
        this.initialization = initialization;
        this.variation = variation;
        this.delta = delta;
        this.eta = eta;
        this.updateUtility = updateUtility;
    }

    public MOEAD(Problem problem, int neighborhoodSize, WeightGenerator weightGenerator, Initialization initialization, Variation variation, double delta, double eta) {
        this(problem, neighborhoodSize, weightGenerator, initialization, variation, delta, eta, -1);
    }

    @Override
    public void initialize() {
        int i;
        super.initialize();
        Solution[] initialSolutions = this.initialization.initialize();
        this.initializePopulation(initialSolutions.length);
        this.initializeNeighborhoods();
        this.initializeIdealPoint();
        this.evaluateAll(initialSolutions);
        for (i = 0; i < initialSolutions.length; ++i) {
            Solution solution = initialSolutions[i];
            this.updateIdealPoint(solution);
            this.population.get(i).setSolution(solution);
        }
        for (i = 0; i < initialSolutions.length; ++i) {
            this.population.get(i).setFitness(this.fitness(this.population.get(i).getSolution(), this.population.get(i).getWeights()));
        }
    }

    private void initializePopulation(int populationSize) {
        this.population = new ArrayList<Individual>(populationSize);
        if (this.weightGenerator == null) {
            List<double[]> weights = new RandomGenerator(this.problem.getNumberOfObjectives(), populationSize).generate();
            for (double[] weight : weights) {
                this.population.add(new Individual(weight));
            }
        } else {
            List<double[]> weights = this.weightGenerator.generate();
            if (weights.size() != populationSize) {
                throw new FrameworkException("weight generator must return " + populationSize + " weights");
            }
            for (double[] weight : weights) {
                this.population.add(new Individual(weight));
            }
        }
    }

    private void initializeNeighborhoods() {
        ArrayList<Individual> sortedPopulation = new ArrayList<Individual>(this.population);
        for (Individual individual : this.population) {
            Collections.sort(sortedPopulation, new WeightSorter(individual));
            for (int i = 0; i < this.neighborhoodSize; ++i) {
                individual.addNeighbor((Individual)sortedPopulation.get(i));
            }
        }
    }

    private void initializeIdealPoint() {
        this.idealPoint = new double[this.problem.getNumberOfObjectives()];
        Arrays.fill(this.idealPoint, Double.POSITIVE_INFINITY);
    }

    private void updateIdealPoint(Solution solution) {
        for (int i = 0; i < solution.getNumberOfObjectives(); ++i) {
            this.idealPoint[i] = Math.min(this.idealPoint[i], solution.getObjective(i));
        }
    }

    @Override
    public NondominatedPopulation getResult() {
        NondominatedPopulation result = new NondominatedPopulation();
        if (this.population != null) {
            for (Individual individual : this.population) {
                result.add(individual.getSolution());
            }
        }
        return result;
    }

    private List<Integer> getSubproblemsToSearch() {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        if (this.updateUtility < 0) {
            for (int i = 0; i < this.population.size(); ++i) {
                indices.add(i);
            }
        } else {
            int i;
            for (i = 0; i < this.problem.getNumberOfObjectives(); ++i) {
                indices.add(i);
            }
            for (i = this.problem.getNumberOfObjectives(); i < this.population.size() / 5; ++i) {
                int index = PRNG.nextInt(this.population.size());
                for (int j = 1; j < 10; ++j) {
                    int temp = PRNG.nextInt(this.population.size());
                    if (!(this.population.get(temp).getUtility() > this.population.get(index).getUtility())) continue;
                    index = temp;
                }
                indices.add(index);
            }
        }
        PRNG.shuffle(indices);
        return indices;
    }

    private List<Integer> getMatingIndices(int index) {
        ArrayList<Integer> matingIndices = new ArrayList<Integer>();
        if (PRNG.nextDouble() <= this.delta) {
            for (Individual individual : this.population.get(index).getNeighbors()) {
                matingIndices.add(this.population.indexOf(individual));
            }
        } else {
            for (int i = 0; i < this.population.size(); ++i) {
                matingIndices.add(i);
            }
        }
        return matingIndices;
    }

    private double fitness(Solution solution, double[] weights) {
        double max = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < solution.getNumberOfObjectives(); ++i) {
            max = Math.max(max, Math.max(weights[i], 1.0E-4) * Math.abs(solution.getObjective(i) - this.idealPoint[i]));
        }
        if (solution.violatesConstraints()) {
            max += 10000.0;
        }
        return max;
    }

    private double sumOfConstraintViolations(Solution solution) {
        double sum = 0.0;
        for (int i = 0; i < solution.getNumberOfConstraints(); ++i) {
            sum += Math.abs(solution.getConstraint(i));
        }
        return sum;
    }

    private void updateSolution(Solution solution, List<Integer> matingIndices) {
        int c = 0;
        PRNG.shuffle(matingIndices);
        for (int i = 0; i < matingIndices.size(); ++i) {
            Individual individual = this.population.get(matingIndices.get(i));
            boolean canReplace = false;
            if (solution.violatesConstraints() && individual.getSolution().violatesConstraints()) {
                double cv2;
                double cv1 = this.sumOfConstraintViolations(solution);
                if (cv1 < (cv2 = this.sumOfConstraintViolations(individual.getSolution()))) {
                    canReplace = true;
                }
            } else if (individual.getSolution().violatesConstraints()) {
                canReplace = true;
            } else if (!solution.violatesConstraints() && this.fitness(solution, individual.getWeights()) < this.fitness(individual.getSolution(), individual.getWeights())) {
                canReplace = true;
            }
            if (canReplace) {
                individual.setSolution(solution);
                ++c;
            }
            if ((double)c >= this.eta) break;
        }
    }

    protected void updateUtility() {
        for (Individual individual : this.population) {
            double newFitness;
            double oldFitness = individual.getFitness();
            double relativeDecrease = (oldFitness - (newFitness = this.fitness(individual.getSolution(), this.idealPoint))) / oldFitness;
            if (relativeDecrease > 0.001) {
                individual.setUtility(1.0);
            } else {
                double utility = Math.min(1.0, (0.95 + 0.05 * relativeDecrease / 0.001) * individual.getUtility());
                individual.setUtility(utility);
            }
            individual.setFitness(newFitness);
        }
    }

    @Override
    public void iterate() {
        List<Integer> indices = this.getSubproblemsToSearch();
        for (Integer index : indices) {
            Solution[] offspring;
            int i;
            List<Integer> matingIndices = this.getMatingIndices(index);
            Solution[] parents = new Solution[this.variation.getArity()];
            parents[0] = this.population.get(index).getSolution();
            if (this.variation.getArity() > 2) {
                PRNG.shuffle(matingIndices);
                for (i = 1; i < this.variation.getArity() - 1; ++i) {
                    parents[i] = this.population.get(matingIndices.get(i - 1)).getSolution();
                }
                parents[this.variation.getArity() - 1] = this.population.get(index).getSolution();
            } else {
                for (i = 1; i < this.variation.getArity(); ++i) {
                    parents[i] = this.population.get(PRNG.nextItem(matingIndices)).getSolution();
                }
            }
            for (Solution child : offspring = this.variation.evolve(parents)) {
                this.evaluate(child);
                this.updateIdealPoint(child);
                this.updateSolution(child, matingIndices);
            }
        }
        ++this.generation;
        if (this.updateUtility >= 0 && this.generation % this.updateUtility == 0) {
            this.updateUtility();
        }
    }

    @Override
    public Serializable getState() throws NotSerializableException {
        return new MOEADState(this.population, this.idealPoint, this.numberOfEvaluations, this.generation);
    }

    @Override
    public void setState(Object objState) throws NotSerializableException {
        super.initialize();
        MOEADState state = (MOEADState)objState;
        this.population = state.getPopulation();
        this.idealPoint = state.getIdealPoint();
        this.numberOfEvaluations = state.getNumberOfEvaluations();
        this.generation = state.getGeneration();
    }

    private static class MOEADState
    implements Serializable {
        private static final long serialVersionUID = 8694911146929397897L;
        private final List<Individual> population;
        private final double[] idealPoint;
        private final int numberOfEvaluations;
        private final int generation;

        public MOEADState(List<Individual> population, double[] idealPoint, int numberOfEvaluations, int generation) {
            this.population = population;
            this.idealPoint = idealPoint;
            this.numberOfEvaluations = numberOfEvaluations;
            this.generation = generation;
        }

        public List<Individual> getPopulation() {
            return this.population;
        }

        public double[] getIdealPoint() {
            return this.idealPoint;
        }

        public int getNumberOfEvaluations() {
            return this.numberOfEvaluations;
        }

        public int getGeneration() {
            return this.generation;
        }
    }

    private static class WeightSorter
    implements Comparator<Individual> {
        private final Individual individual;

        public WeightSorter(Individual individual) {
            this.individual = individual;
        }

        @Override
        public int compare(Individual o1, Individual o2) {
            double d1 = MathArrays.distance((double[])this.individual.getWeights(), (double[])o1.getWeights());
            double d2 = MathArrays.distance((double[])this.individual.getWeights(), (double[])o2.getWeights());
            return Double.compare(d1, d2);
        }
    }

    private static class Individual
    implements Serializable {
        private static final long serialVersionUID = 868794189268472009L;
        private Solution solution;
        private double[] weights;
        private List<Individual> neighbors;
        private double utility;
        private double fitness;

        public Individual(double[] weights) {
            this.weights = weights;
            this.neighbors = new ArrayList<Individual>();
            this.utility = 1.0;
        }

        public Solution getSolution() {
            return this.solution;
        }

        public void setSolution(Solution solution) {
            this.solution = solution;
        }

        public double[] getWeights() {
            return this.weights;
        }

        public List<Individual> getNeighbors() {
            return this.neighbors;
        }

        public void addNeighbor(Individual neighbor) {
            this.neighbors.add(neighbor);
        }

        public double getUtility() {
            return this.utility;
        }

        public void setUtility(double utility) {
            this.utility = utility;
        }

        public double getFitness() {
            return this.fitness;
        }

        public void setFitness(double fitness) {
            this.fitness = fitness;
        }
    }
}

