/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import org.apache.commons.math3.util.ArithmeticUtils;
import org.moeaframework.algorithm.AbstractEvolutionaryAlgorithm;
import org.moeaframework.algorithm.AlgorithmInitializationException;
import org.moeaframework.core.AdaptiveGridArchive;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;
import org.moeaframework.core.comparator.DominanceComparator;
import org.moeaframework.core.comparator.ParetoDominanceComparator;
import org.moeaframework.core.operator.RandomInitialization;

public class PAES
extends AbstractEvolutionaryAlgorithm {
    private final Variation variation;
    private final DominanceComparator comparator;

    public PAES(Problem problem, Variation variation, int bisections, int archiveSize) {
        super(problem, new Population(), new AdaptiveGridArchive(archiveSize, problem, ArithmeticUtils.pow((int)2, (int)bisections)), null);
        this.variation = variation;
        if (variation.getArity() != 1) {
            throw new IllegalArgumentException("PAES only supports mutation operators with 1 parent");
        }
        this.comparator = new ParetoDominanceComparator();
    }

    @Override
    public AdaptiveGridArchive getArchive() {
        return (AdaptiveGridArchive)super.getArchive();
    }

    @Override
    protected void initialize() {
        if (this.initialized) {
            throw new AlgorithmInitializationException((Algorithm)this, "algorithm already initialized");
        }
        this.initialized = true;
        Solution solution = new RandomInitialization(this.problem, 1).initialize()[0];
        this.evaluate(solution);
        this.population.add(solution);
        this.archive.add(solution);
    }

    public Solution test(Solution parent, Solution offspring) {
        AdaptiveGridArchive archive = this.getArchive();
        int parentIndex = archive.findIndex(parent);
        int offspringIndex = archive.findIndex(offspring);
        if (parentIndex == -1) {
            return offspring;
        }
        if (offspringIndex == -1) {
            return parent;
        }
        if (archive.getDensity(parentIndex) > archive.getDensity(offspringIndex)) {
            return offspring;
        }
        return parent;
    }

    @Override
    protected void iterate() {
        Solution parent = this.population.get(0);
        Solution offspring = this.variation.evolve(new Solution[]{parent})[0];
        this.evaluate(offspring);
        int flag = this.comparator.compare(parent, offspring);
        if (flag == 1) {
            this.population.replace(0, offspring);
            this.archive.add(offspring);
        } else if (flag == 0 && this.archive.add(offspring)) {
            this.population.replace(0, this.test(parent, offspring));
        }
    }
}

