/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.commons.math3.util.ArithmeticUtils;
import org.moeaframework.algorithm.AbstractEvolutionaryAlgorithm;
import org.moeaframework.core.AdaptiveGridArchive;
import org.moeaframework.core.Initialization;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Selection;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;

public class PESA2
extends AbstractEvolutionaryAlgorithm {
    protected final Selection selection;
    protected final Variation variation;
    protected Map<Integer, List<Solution>> gridMap;

    public PESA2(Problem problem, Variation variation, Initialization initialization, int bisections, int archiveSize) {
        super(problem, new Population(), new AdaptiveGridArchive(archiveSize, problem, ArithmeticUtils.pow((int)2, (int)bisections)), initialization);
        this.variation = variation;
        this.selection = new RegionBasedSelection();
    }

    @Override
    public AdaptiveGridArchive getArchive() {
        return (AdaptiveGridArchive)super.getArchive();
    }

    @Override
    protected void iterate() {
        int populationSize = this.population.size();
        this.population.clear();
        this.gridMap = this.createGridMap();
        while (this.population.size() < populationSize) {
            Solution[] parents = this.selection.select(this.variation.getArity(), this.archive);
            Solution[] children = this.variation.evolve(parents);
            this.population.addAll(children);
        }
        this.evaluateAll(this.population);
        this.archive.addAll(this.population);
    }

    protected Map<Integer, List<Solution>> createGridMap() {
        AdaptiveGridArchive archive = this.getArchive();
        HashMap<Integer, List<Solution>> result = new HashMap<Integer, List<Solution>>();
        for (Solution solution : archive) {
            int index = archive.findIndex(solution);
            ArrayList<Solution> solutions = (ArrayList<Solution>)result.get(index);
            if (solutions == null) {
                solutions = new ArrayList<Solution>();
                result.put(index, solutions);
            }
            solutions.add(solution);
        }
        return result;
    }

    public class RegionBasedSelection
    implements Selection {
        @Override
        public Solution[] select(int arity, Population population) {
            Solution[] result = new Solution[arity];
            for (int i = 0; i < arity; ++i) {
                result[i] = this.select();
            }
            return result;
        }

        protected Map.Entry<Integer, List<Solution>> draw() {
            int index = PRNG.nextInt(PESA2.this.gridMap.size());
            for (Map.Entry<Integer, List<Solution>> entry : PESA2.this.gridMap.entrySet()) {
                if (index == 0) {
                    return entry;
                }
                --index;
            }
            throw new NoSuchElementException();
        }

        protected Solution select() {
            AdaptiveGridArchive archive = PESA2.this.getArchive();
            Map.Entry<Integer, List<Solution>> entry1 = this.draw();
            Map.Entry<Integer, List<Solution>> entry2 = this.draw();
            Map.Entry<Integer, List<Solution>> selection = entry1;
            if (entry1 != entry2 && (archive.getDensity(entry2.getKey()) < archive.getDensity(entry1.getKey()) || archive.getDensity(entry2.getKey()) == archive.getDensity(entry1.getKey()) && PRNG.nextBoolean())) {
                selection = entry2;
            }
            return PRNG.nextItem(selection.getValue());
        }
    }
}

