/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import java.io.NotSerializableException;
import java.io.Serializable;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;

public abstract class PeriodicAction
implements Algorithm {
    protected final Algorithm algorithm;
    protected final int frequency;
    protected final FrequencyType frequencyType;
    protected int iteration;
    protected int lastInvocation;

    public PeriodicAction(Algorithm algorithm, int frequency, FrequencyType frequencyType) {
        this.algorithm = algorithm;
        this.frequency = frequency;
        this.frequencyType = frequencyType;
    }

    @Override
    public Problem getProblem() {
        return this.algorithm.getProblem();
    }

    @Override
    public NondominatedPopulation getResult() {
        return this.algorithm.getResult();
    }

    @Override
    public void step() {
        this.algorithm.step();
        if (this.frequencyType.equals((Object)FrequencyType.EVALUATIONS)) {
            if (this.getNumberOfEvaluations() - this.lastInvocation >= this.frequency) {
                this.doAction();
                this.lastInvocation = this.getNumberOfEvaluations();
            }
        } else if (this.frequencyType.equals((Object)FrequencyType.STEPS)) {
            ++this.iteration;
            if (this.iteration - this.lastInvocation >= this.frequency) {
                this.doAction();
                this.lastInvocation = this.iteration;
            }
        } else {
            throw new IllegalStateException();
        }
    }

    @Override
    public void evaluate(Solution solution) {
        this.algorithm.evaluate(solution);
    }

    @Override
    public int getNumberOfEvaluations() {
        return this.algorithm.getNumberOfEvaluations();
    }

    @Override
    public boolean isTerminated() {
        return this.algorithm.isTerminated();
    }

    @Override
    public void terminate() {
        this.algorithm.terminate();
    }

    public abstract void doAction();

    @Override
    public Serializable getState() throws NotSerializableException {
        return new PeriodicActionState(this.algorithm.getState(), this.iteration, this.lastInvocation);
    }

    @Override
    public void setState(Object state) throws NotSerializableException {
        PeriodicActionState periodicActionState = (PeriodicActionState)state;
        this.algorithm.setState(periodicActionState.getAlgorithmState());
        this.iteration = periodicActionState.getIteration();
        this.lastInvocation = periodicActionState.getLastInvocation();
    }

    private static class PeriodicActionState
    implements Serializable {
        private static final long serialVersionUID = -8654866332843263225L;
        private final Serializable algorithmState;
        private final int iteration;
        private final int lastInvocation;

        public PeriodicActionState(Serializable algorithmState, int iteration, int lastInvocation) {
            this.algorithmState = algorithmState;
            this.iteration = iteration;
            this.lastInvocation = lastInvocation;
        }

        public Serializable getAlgorithmState() {
            return this.algorithmState;
        }

        public int getIteration() {
            return this.iteration;
        }

        public int getLastInvocation() {
            return this.lastInvocation;
        }
    }

    public static enum FrequencyType {
        EVALUATIONS,
        STEPS;

    }
}

