/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import java.io.NotSerializableException;
import java.io.Serializable;
import java.util.ArrayList;
import org.moeaframework.algorithm.AbstractEvolutionaryAlgorithm;
import org.moeaframework.algorithm.AlgorithmInitializationException;
import org.moeaframework.algorithm.ReferenceVectorGuidedPopulation;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.Initialization;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;

public class RVEA
extends AbstractEvolutionaryAlgorithm {
    private final Variation variation;
    private int generation;
    private int maxGeneration = 1000;
    private int adaptFrequency = this.maxGeneration / 10;

    public RVEA(Problem problem, ReferenceVectorGuidedPopulation population, Variation variation, Initialization initialization, int maxGeneration, int adaptFrequency) {
        super(problem, population, null, initialization);
        this.variation = variation;
        if (variation.getArity() != 2) {
            throw new FrameworkException("RVEA only supports operators requiring 2 parents");
        }
    }

    @Override
    protected void iterate() {
        int i;
        ReferenceVectorGuidedPopulation population = this.getPopulation();
        Population offspring = new Population();
        int populationSize = population.size();
        population.setScalingFactor(Math.min((double)this.generation / (double)this.maxGeneration, 1.0));
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (i = 0; i < populationSize; ++i) {
            indices.add(i);
        }
        PRNG.shuffle(indices);
        if (indices.size() % 2 == 1) {
            indices.add((Integer)indices.get(0));
        }
        for (i = 0; i < indices.size(); i += 2) {
            Solution[] parents = new Solution[]{population.get((Integer)indices.get(i)), population.get((Integer)indices.get(i + 1))};
            Solution[] children = this.variation.evolve(parents);
            offspring.addAll(children);
        }
        this.evaluateAll(offspring);
        population.addAll(offspring);
        population.truncate();
        if (this.generation > 0 && this.generation % this.adaptFrequency == 0) {
            population.adapt();
        }
        ++this.generation;
    }

    @Override
    public ReferenceVectorGuidedPopulation getPopulation() {
        return (ReferenceVectorGuidedPopulation)super.getPopulation();
    }

    @Override
    public Serializable getState() throws NotSerializableException {
        if (!this.isInitialized()) {
            throw new AlgorithmInitializationException((Algorithm)this, "algorithm not initialized");
        }
        return new RVEAState(this.getNumberOfEvaluations(), this.generation, this.getPopulation().getState());
    }

    @Override
    public void setState(Object objState) throws NotSerializableException {
        RVEAState state = (RVEAState)objState;
        this.initialized = true;
        this.numberOfEvaluations = state.getNumberOfEvaluations();
        this.generation = state.getGeneration();
        this.getPopulation().setState(state.getPopulationState());
    }

    private static class RVEAState
    implements Serializable {
        private static final long serialVersionUID = 5341464818762163296L;
        private final int numberOfEvaluations;
        private final int generation;
        private final ReferenceVectorGuidedPopulation.ReferenceVectorGuidedPopulationState populationState;

        public RVEAState(int numberOfEvaluations, int generation, ReferenceVectorGuidedPopulation.ReferenceVectorGuidedPopulationState populationState) {
            this.numberOfEvaluations = numberOfEvaluations;
            this.generation = generation;
            this.populationState = populationState;
        }

        public int getNumberOfEvaluations() {
            return this.numberOfEvaluations;
        }

        public int getGeneration() {
            return this.generation;
        }

        public ReferenceVectorGuidedPopulation.ReferenceVectorGuidedPopulationState getPopulationState() {
            return this.populationState;
        }
    }
}

