/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.NondominatedSortingPopulation;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Population;
import org.moeaframework.core.Solution;
import org.moeaframework.core.comparator.DominanceComparator;
import org.moeaframework.core.comparator.RankComparator;
import org.moeaframework.util.Vector;
import org.moeaframework.util.weights.NormalBoundaryIntersectionGenerator;

public class ReferencePointNondominatedSortingPopulation
extends NondominatedSortingPopulation {
    static final String NORMALIZED_OBJECTIVES = "Normalized Objectives";
    private final int numberOfObjectives;
    private final int divisionsOuter;
    private final int divisionsInner;
    double[] idealPoint;
    private List<double[]> weights;

    public ReferencePointNondominatedSortingPopulation(int numberOfObjectives, int divisions) {
        this.numberOfObjectives = numberOfObjectives;
        this.divisionsOuter = divisions;
        this.divisionsInner = 0;
        this.initialize();
    }

    public ReferencePointNondominatedSortingPopulation(int numberOfObjectives, int divisions, DominanceComparator comparator, Iterable<? extends Solution> iterable) {
        super(comparator, iterable);
        this.numberOfObjectives = numberOfObjectives;
        this.divisionsOuter = divisions;
        this.divisionsInner = 0;
        this.initialize();
    }

    public ReferencePointNondominatedSortingPopulation(int numberOfObjectives, int divisions, DominanceComparator comparator) {
        super(comparator);
        this.numberOfObjectives = numberOfObjectives;
        this.divisionsOuter = divisions;
        this.divisionsInner = 0;
        this.initialize();
    }

    public ReferencePointNondominatedSortingPopulation(int numberOfObjectives, int divisions, Iterable<? extends Solution> iterable) {
        super(iterable);
        this.numberOfObjectives = numberOfObjectives;
        this.divisionsOuter = divisions;
        this.divisionsInner = 0;
        this.initialize();
    }

    public ReferencePointNondominatedSortingPopulation(int numberOfObjectives, int divisionsOuter, int divisionsInner) {
        this.numberOfObjectives = numberOfObjectives;
        this.divisionsOuter = divisionsOuter;
        this.divisionsInner = divisionsInner;
        this.initialize();
    }

    public ReferencePointNondominatedSortingPopulation(int numberOfObjectives, int divisionsOuter, int divisionsInner, DominanceComparator comparator, Iterable<? extends Solution> iterable) {
        super(comparator, iterable);
        this.numberOfObjectives = numberOfObjectives;
        this.divisionsOuter = divisionsOuter;
        this.divisionsInner = divisionsInner;
        this.initialize();
    }

    public ReferencePointNondominatedSortingPopulation(int numberOfObjectives, int divisionsOuter, int divisionsInner, DominanceComparator comparator) {
        super(comparator);
        this.numberOfObjectives = numberOfObjectives;
        this.divisionsOuter = divisionsOuter;
        this.divisionsInner = divisionsInner;
        this.initialize();
    }

    public ReferencePointNondominatedSortingPopulation(int numberOfObjectives, int divisionsOuter, int divisionsInner, Iterable<? extends Solution> iterable) {
        super(iterable);
        this.numberOfObjectives = numberOfObjectives;
        this.divisionsOuter = divisionsOuter;
        this.divisionsInner = divisionsInner;
        this.initialize();
    }

    private void initialize() {
        this.idealPoint = new double[this.numberOfObjectives];
        Arrays.fill(this.idealPoint, Double.POSITIVE_INFINITY);
        this.weights = new NormalBoundaryIntersectionGenerator(this.numberOfObjectives, this.divisionsOuter, this.divisionsInner).generate();
    }

    protected void updateIdealPoint() {
        for (Solution solution : this) {
            if (solution.getNumberOfObjectives() != this.numberOfObjectives) {
                throw new FrameworkException("incorrect number of objectives");
            }
            for (int i = 0; i < this.numberOfObjectives; ++i) {
                this.idealPoint[i] = Math.min(this.idealPoint[i], solution.getObjective(i));
            }
        }
    }

    protected void translateByIdealPoint() {
        for (Solution solution : this) {
            double[] objectives = solution.getObjectives();
            for (int i = 0; i < this.numberOfObjectives; ++i) {
                int n = i;
                objectives[n] = objectives[n] - this.idealPoint[i];
            }
            solution.setAttribute(NORMALIZED_OBJECTIVES, (Serializable)objectives);
        }
    }

    protected void normalizeByIntercepts(double[] intercepts) {
        for (Solution solution : this) {
            double[] objectives = (double[])solution.getAttribute(NORMALIZED_OBJECTIVES);
            for (int i = 0; i < solution.getNumberOfObjectives(); ++i) {
                int n = i;
                objectives[n] = objectives[n] / intercepts[i];
            }
        }
    }

    protected static double achievementScalarizingFunction(Solution solution, double[] weights) {
        double max = Double.NEGATIVE_INFINITY;
        double[] objectives = (double[])solution.getAttribute(NORMALIZED_OBJECTIVES);
        for (int i = 0; i < solution.getNumberOfObjectives(); ++i) {
            max = Math.max(max, objectives[i] / weights[i]);
        }
        return max;
    }

    protected Solution findExtremePoint(int objective) {
        double eps = 1.0E-6;
        double[] weights = new double[this.numberOfObjectives];
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            weights[i] = i == objective ? 1.0 : eps;
        }
        Solution result = null;
        double resultASF = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.size(); ++i) {
            Solution solution = this.get(i);
            double solutionASF = ReferencePointNondominatedSortingPopulation.achievementScalarizingFunction(solution, weights);
            if (!(solutionASF < resultASF)) continue;
            result = solution;
            resultASF = solutionASF;
        }
        return result;
    }

    private Solution[] extremePoints() {
        Solution[] result = new Solution[this.numberOfObjectives];
        for (int i = 0; i < this.numberOfObjectives; ++i) {
            result[i] = this.findExtremePoint(i);
        }
        return result;
    }

    protected double[] calculateIntercepts() {
        Solution[] extremePoints = this.extremePoints();
        boolean degenerate = false;
        double[] intercepts = new double[this.numberOfObjectives];
        try {
            double[] b = new double[this.numberOfObjectives];
            double[][] A = new double[this.numberOfObjectives][this.numberOfObjectives];
            for (int i = 0; i < this.numberOfObjectives; ++i) {
                double[] objectives = (double[])extremePoints[i].getAttribute(NORMALIZED_OBJECTIVES);
                b[i] = 1.0;
                for (int j = 0; j < this.numberOfObjectives; ++j) {
                    A[i][j] = objectives[j];
                }
            }
            double[] result = this.lsolve(A, b);
            for (int i = 0; i < this.numberOfObjectives; ++i) {
                intercepts[i] = 1.0 / result[i];
            }
        }
        catch (RuntimeException e) {
            degenerate = true;
        }
        if (!degenerate) {
            for (int i = 0; i < this.numberOfObjectives; ++i) {
                if (!(intercepts[i] < 0.001)) continue;
                degenerate = true;
                break;
            }
        }
        if (degenerate) {
            Arrays.fill(intercepts, Double.NEGATIVE_INFINITY);
            for (Solution solution : this) {
                for (int i = 0; i < this.numberOfObjectives; ++i) {
                    intercepts[i] = Math.max(Math.max(intercepts[i], 1.0E-10), solution.getObjective(i));
                }
            }
        }
        return intercepts;
    }

    private double[] lsolve(double[][] A, double[] b) {
        int N = b.length;
        for (int p = 0; p < N; ++p) {
            int max = p;
            for (int i = p + 1; i < N; ++i) {
                if (!(Math.abs(A[i][p]) > Math.abs(A[max][p]))) continue;
                max = i;
            }
            double[] temp = A[p];
            A[p] = A[max];
            A[max] = temp;
            double t = b[p];
            b[p] = b[max];
            b[max] = t;
            if (Math.abs(A[p][p]) <= 1.0E-10) {
                throw new RuntimeException("Matrix is singular or nearly singular");
            }
            for (int i = p + 1; i < N; ++i) {
                double alpha = A[i][p] / A[p][p];
                int n = i;
                b[n] = b[n] - alpha * b[p];
                for (int j = p; j < N; ++j) {
                    double[] dArray = A[i];
                    int n2 = j;
                    dArray[n2] = dArray[n2] - alpha * A[p][j];
                }
            }
        }
        double[] x = new double[N];
        for (int i = N - 1; i >= 0; --i) {
            double sum = 0.0;
            for (int j = i + 1; j < N; ++j) {
                sum += A[i][j] * x[j];
            }
            x[i] = (b[i] - sum) / A[i][i];
        }
        return x;
    }

    protected static double pointLineDistance(double[] line, double[] point) {
        return Vector.magnitude(Vector.subtract(Vector.multiply(Vector.dot(line, point) / Vector.dot(line, line), line), point));
    }

    protected List<List<Solution>> associateToReferencePoint(Population population) {
        ArrayList<List<Solution>> result = new ArrayList<List<Solution>>();
        for (int i = 0; i < this.weights.size(); ++i) {
            result.add(new ArrayList());
        }
        for (Solution solution : population) {
            double[] objectives = (double[])solution.getAttribute(NORMALIZED_OBJECTIVES);
            double minDistance = Double.POSITIVE_INFINITY;
            int minIndex = -1;
            for (int i = 0; i < this.weights.size(); ++i) {
                double distance = ReferencePointNondominatedSortingPopulation.pointLineDistance(this.weights.get(i), objectives);
                if (!(distance < minDistance)) continue;
                minDistance = distance;
                minIndex = i;
            }
            ((List)result.get(minIndex)).add(solution);
        }
        return result;
    }

    protected Solution findSolutionWithMinimumDistance(List<Solution> solutions, double[] weight) {
        double minDistance = Double.POSITIVE_INFINITY;
        Solution minSolution = null;
        for (int i = 0; i < solutions.size(); ++i) {
            double[] objectives = (double[])solutions.get(i).getAttribute(NORMALIZED_OBJECTIVES);
            double distance = ReferencePointNondominatedSortingPopulation.pointLineDistance(weight, objectives);
            if (!(distance < minDistance)) continue;
            minDistance = distance;
            minSolution = solutions.get(i);
        }
        return minSolution;
    }

    @Override
    public void truncate(int size, Comparator<? super Solution> comparator) {
        if (this.size() > size) {
            int rank;
            int i;
            this.sort(new RankComparator());
            int maxRank = (Integer)super.get(size - 1).getAttribute("rank");
            Population front = new Population();
            for (i = 0; i < this.size(); ++i) {
                rank = (Integer)this.get(i).getAttribute("rank");
                if (rank <= maxRank) continue;
                front.add(this.get(i));
            }
            this.removeAll(front);
            this.updateIdealPoint();
            this.translateByIdealPoint();
            this.normalizeByIntercepts(this.calculateIntercepts());
            front = new Population();
            for (i = 0; i < this.size(); ++i) {
                rank = (Integer)this.get(i).getAttribute("rank");
                if (rank != maxRank) continue;
                front.add(this.get(i));
            }
            this.removeAll(front);
            List<List<Solution>> members = this.associateToReferencePoint(this);
            List<List<Solution>> potentialMembers = this.associateToReferencePoint(front);
            HashSet<Integer> excluded = new HashSet<Integer>();
            while (this.size() < size) {
                ArrayList<Integer> minIndices = new ArrayList<Integer>();
                int minCount = Integer.MAX_VALUE;
                for (int i2 = 0; i2 < members.size(); ++i2) {
                    if (excluded.contains(i2) || members.get(i2).size() > minCount) continue;
                    if (members.get(i2).size() < minCount) {
                        minIndices.clear();
                        minCount = members.get(i2).size();
                    }
                    minIndices.add(i2);
                }
                int minIndex = (Integer)PRNG.nextItem(minIndices);
                if (minCount == 0) {
                    if (potentialMembers.get(minIndex).isEmpty()) {
                        excluded.add(minIndex);
                        continue;
                    }
                    Solution minSolution = this.findSolutionWithMinimumDistance(potentialMembers.get(minIndex), this.weights.get(minIndex));
                    this.add(minSolution);
                    members.get(minIndex).add(minSolution);
                    potentialMembers.get(minIndex).remove(minSolution);
                    continue;
                }
                if (potentialMembers.get(minIndex).isEmpty()) {
                    excluded.add(minIndex);
                    continue;
                }
                Solution randSolution = PRNG.nextItem(potentialMembers.get(minIndex));
                this.add(randSolution);
                members.get(minIndex).add(randSolution);
                potentialMembers.get(minIndex).remove(randSolution);
            }
        }
    }

    @Override
    public void truncate(int size) {
        this.truncate(size, new RankComparator());
    }
}

