/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.Population;
import org.moeaframework.core.Solution;
import org.moeaframework.util.Vector;
import org.moeaframework.util.weights.NormalBoundaryIntersectionGenerator;

public class ReferenceVectorGuidedPopulation
extends Population {
    private static final String NORMALIZED_OBJECTIVES = "Normalized Objectives";
    private final int numberOfObjectives;
    private final int divisionsOuter;
    private final int divisionsInner;
    double[] idealPoint;
    private List<double[]> originalWeights;
    List<double[]> weights;
    private double[] minAngles;
    private double scalingFactor = 0.0;
    private final double alpha;

    public ReferenceVectorGuidedPopulation(int numberOfObjectives, int divisions, double alpha) {
        this.numberOfObjectives = numberOfObjectives;
        this.divisionsOuter = divisions;
        this.divisionsInner = 0;
        this.alpha = alpha;
        this.initialize();
    }

    public ReferenceVectorGuidedPopulation(int numberOfObjectives, int divisions, double alpha, Iterable<? extends Solution> iterable) {
        super(iterable);
        this.numberOfObjectives = numberOfObjectives;
        this.divisionsOuter = divisions;
        this.divisionsInner = 0;
        this.alpha = alpha;
        this.initialize();
    }

    public ReferenceVectorGuidedPopulation(int numberOfObjectives, int divisionsOuter, int divisionsInner, double alpha) {
        this.numberOfObjectives = numberOfObjectives;
        this.divisionsOuter = divisionsOuter;
        this.divisionsInner = divisionsInner;
        this.alpha = alpha;
        this.initialize();
    }

    public ReferenceVectorGuidedPopulation(int numberOfObjectives, int divisionsOuter, int divisionsInner, double alpha, Iterable<? extends Solution> iterable) {
        super(iterable);
        this.numberOfObjectives = numberOfObjectives;
        this.divisionsOuter = divisionsOuter;
        this.divisionsInner = divisionsInner;
        this.alpha = alpha;
        this.initialize();
    }

    public void setScalingFactor(double scalingFactor) {
        if (scalingFactor < 0.0) {
            scalingFactor = 0.0;
        } else if (scalingFactor > 1.0) {
            scalingFactor = 1.0;
        }
        this.scalingFactor = scalingFactor;
    }

    public void adapt() {
        double[] zmin = new double[this.numberOfObjectives];
        double[] zmax = new double[this.numberOfObjectives];
        Arrays.fill(zmin, Double.POSITIVE_INFINITY);
        Arrays.fill(zmax, Double.NEGATIVE_INFINITY);
        for (Solution solution : this) {
            for (int i = 0; i < this.numberOfObjectives; ++i) {
                zmin[i] = Math.min(zmin[i], solution.getObjective(i));
                zmax[i] = Math.max(zmax[i], solution.getObjective(i));
            }
        }
        this.weights.clear();
        for (double[] weight : this.originalWeights) {
            double[] newWeight = (double[])weight.clone();
            for (int i = 0; i < this.numberOfObjectives; ++i) {
                int n = i;
                newWeight[n] = newWeight[n] * Math.max(0.01, zmax[i] - zmin[i]);
            }
            this.weights.add(Vector.normalize(newWeight));
        }
        this.minAngles = new double[this.weights.size()];
        for (int i = 0; i < this.weights.size(); ++i) {
            this.minAngles[i] = this.smallestAngleBetweenWeights(i);
        }
    }

    private void initialize() {
        if (this.numberOfObjectives < 2) {
            throw new FrameworkException("requires at least two objectives");
        }
        this.originalWeights = new NormalBoundaryIntersectionGenerator(this.numberOfObjectives, this.divisionsOuter, this.divisionsInner).generate();
        for (int i = 0; i < this.originalWeights.size(); ++i) {
            this.originalWeights.set(i, Vector.normalize(this.originalWeights.get(i)));
        }
        this.weights = new ArrayList<double[]>();
        for (double[] weight : this.originalWeights) {
            this.weights.add((double[])weight.clone());
        }
        this.minAngles = new double[this.weights.size()];
        for (int i = 0; i < this.weights.size(); ++i) {
            this.minAngles[i] = this.smallestAngleBetweenWeights(i);
        }
    }

    protected void calculateIdealPoint() {
        this.idealPoint = new double[this.numberOfObjectives];
        Arrays.fill(this.idealPoint, Double.POSITIVE_INFINITY);
        for (Solution solution : this) {
            if (solution.getNumberOfObjectives() != this.numberOfObjectives) {
                throw new FrameworkException("incorrect number of objectives");
            }
            for (int i = 0; i < this.numberOfObjectives; ++i) {
                this.idealPoint[i] = Math.min(this.idealPoint[i], solution.getObjective(i));
            }
        }
    }

    protected void translateByIdealPoint() {
        for (Solution solution : this) {
            double[] objectives = solution.getObjectives();
            for (int i = 0; i < this.numberOfObjectives; ++i) {
                int n = i;
                objectives[n] = objectives[n] - this.idealPoint[i];
            }
            solution.setAttribute(NORMALIZED_OBJECTIVES, (Serializable)objectives);
        }
    }

    protected static double cosine(double[] line, double[] point) {
        return Vector.dot(point, line) / Vector.magnitude(point);
    }

    protected static double acosine(double[] line, double[] point) {
        return Math.acos(ReferenceVectorGuidedPopulation.cosine(line, point));
    }

    protected List<List<Solution>> associateToReferencePoint(Population population) {
        ArrayList<List<Solution>> result = new ArrayList<List<Solution>>();
        for (int i = 0; i < this.weights.size(); ++i) {
            result.add(new ArrayList());
        }
        for (Solution solution : population) {
            double[] objectives = (double[])solution.getAttribute(NORMALIZED_OBJECTIVES);
            double maxDistance = Double.NEGATIVE_INFINITY;
            int maxIndex = -1;
            for (int i = 0; i < this.weights.size(); ++i) {
                double distance = ReferenceVectorGuidedPopulation.cosine(this.weights.get(i), objectives);
                if (!(distance > maxDistance)) continue;
                maxDistance = distance;
                maxIndex = i;
            }
            if (maxIndex < 0) {
                maxIndex = 0;
            }
            ((List)result.get(maxIndex)).add(solution);
        }
        return result;
    }

    protected double smallestAngleBetweenWeights(int index) {
        double smallestAngle = Double.POSITIVE_INFINITY;
        for (int i = 0; i < this.weights.size(); ++i) {
            if (i == index) continue;
            smallestAngle = Math.min(smallestAngle, ReferenceVectorGuidedPopulation.acosine(this.weights.get(index), this.weights.get(i)));
        }
        return smallestAngle;
    }

    protected Solution select(List<Solution> solutions, int index) {
        double[] weight = this.weights.get(index);
        double minDistance = Double.POSITIVE_INFINITY;
        Solution minSolution = null;
        for (Solution solution : solutions) {
            if (solution.violatesConstraints()) continue;
            double[] objectives = (double[])solution.getAttribute(NORMALIZED_OBJECTIVES);
            double penalty = (double)this.numberOfObjectives * Math.pow(this.scalingFactor, this.alpha) * ReferenceVectorGuidedPopulation.acosine(weight, objectives) / this.minAngles[index];
            double tempDistance = Vector.magnitude(objectives) * (1.0 + penalty);
            if (!(tempDistance < minDistance)) continue;
            minDistance = tempDistance;
            minSolution = solution;
        }
        if (minSolution == null) {
            for (Solution solution : solutions) {
                double tempDistance = 0.0;
                for (int i = 0; i < solution.getNumberOfConstraints(); ++i) {
                    tempDistance += Math.abs(solution.getConstraint(i));
                }
                if (!(tempDistance < minDistance)) continue;
                minDistance = tempDistance;
                minSolution = solution;
            }
        }
        return minSolution;
    }

    @Override
    public void truncate(int size, Comparator<? super Solution> comparator) {
        throw new UnsupportedOperationException("call truncate() instead");
    }

    public void truncate() {
        this.calculateIdealPoint();
        this.translateByIdealPoint();
        List<List<Solution>> members = this.associateToReferencePoint(this);
        this.clear();
        for (int i = 0; i < members.size(); ++i) {
            List<Solution> associations = members.get(i);
            if (associations.size() <= 0) continue;
            this.add(this.select(associations, i));
        }
    }

    protected ReferenceVectorGuidedPopulationState getState() {
        double[] idealPointClone = this.idealPoint == null ? null : (double[])this.idealPoint.clone();
        ArrayList<double[]> originalWeightsClone = new ArrayList<double[]>();
        ArrayList<double[]> weightsClone = new ArrayList<double[]>();
        double[] minAnglesClone = this.minAngles == null ? null : (double[])this.minAngles.clone();
        ArrayList<Solution> populationList = new ArrayList<Solution>();
        for (double[] weight : this.originalWeights) {
            originalWeightsClone.add((double[])weight.clone());
        }
        for (double[] weight : this.weights) {
            weightsClone.add((double[])weight.clone());
        }
        for (Solution solution : this) {
            populationList.add(solution);
        }
        return new ReferenceVectorGuidedPopulationState(populationList, idealPointClone, originalWeightsClone, weightsClone, minAnglesClone, this.scalingFactor);
    }

    protected void setState(ReferenceVectorGuidedPopulationState state) {
        this.idealPoint = state.getIdealPoint() == null ? null : (double[])state.getIdealPoint().clone();
        this.minAngles = state.getMinAngles() == null ? null : (double[])state.getMinAngles().clone();
        this.scalingFactor = state.getScalingFactor();
        this.originalWeights.clear();
        this.weights.clear();
        this.clear();
        for (double[] weight : state.getOriginalWeights()) {
            this.originalWeights.add((double[])weight.clone());
        }
        for (double[] weight : state.getWeights()) {
            this.weights.add((double[])weight.clone());
        }
        this.addAll(state.getPopulation());
    }

    protected static class ReferenceVectorGuidedPopulationState
    implements Serializable {
        private static final long serialVersionUID = 2967034665150122964L;
        private final List<Solution> population;
        private final double[] idealPoint;
        private final List<double[]> originalWeights;
        private final List<double[]> weights;
        private final double[] minAngles;
        private final double scalingFactor;

        public ReferenceVectorGuidedPopulationState(List<Solution> population, double[] idealPoint, List<double[]> originalWeights, List<double[]> weights, double[] minAngles, double scalingFactor) {
            this.population = population;
            this.idealPoint = idealPoint;
            this.originalWeights = originalWeights;
            this.weights = weights;
            this.minAngles = minAngles;
            this.scalingFactor = scalingFactor;
        }

        public List<Solution> getPopulation() {
            return this.population;
        }

        public double[] getIdealPoint() {
            return this.idealPoint;
        }

        public List<double[]> getOriginalWeights() {
            return this.originalWeights;
        }

        public List<double[]> getWeights() {
            return this.weights;
        }

        public double[] getMinAngles() {
            return this.minAngles;
        }

        public double getScalingFactor() {
            return this.scalingFactor;
        }
    }
}

