/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import java.io.Serializable;
import java.util.Comparator;
import org.moeaframework.algorithm.AbstractEvolutionaryAlgorithm;
import org.moeaframework.core.FastNondominatedSorting;
import org.moeaframework.core.FitnessEvaluator;
import org.moeaframework.core.Initialization;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Selection;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;
import org.moeaframework.core.comparator.ChainedComparator;
import org.moeaframework.core.comparator.FitnessComparator;
import org.moeaframework.core.comparator.NondominatedSortingComparator;
import org.moeaframework.core.comparator.RankComparator;
import org.moeaframework.core.operator.TournamentSelection;

public class SMSEMOA
extends AbstractEvolutionaryAlgorithm {
    private FitnessEvaluator fitnessEvaluator;
    private Selection selection;
    private Variation variation;

    public SMSEMOA(Problem problem, Initialization initialization, Variation variation, FitnessEvaluator fitnessEvaluator) {
        super(problem, new Population(), null, initialization);
        this.variation = variation;
        this.fitnessEvaluator = fitnessEvaluator;
        this.selection = fitnessEvaluator == null ? new TournamentSelection(new NondominatedSortingComparator()) : new TournamentSelection(new NondominatedFitnessComparator());
    }

    @Override
    protected void initialize() {
        super.initialize();
        new FastNondominatedSorting().evaluate(this.population);
        if (this.fitnessEvaluator != null) {
            this.fitnessEvaluator.evaluate(this.population);
        }
    }

    @Override
    protected void iterate() {
        int populationSize = this.population.size();
        Solution[] parents = this.selection.select(this.variation.getArity(), this.population);
        Solution[] offspring = this.variation.evolve(parents);
        this.evaluate(offspring[0]);
        this.population.add(offspring[0]);
        new FastNondominatedSorting().evaluate(this.population);
        if (this.fitnessEvaluator == null) {
            this.population.truncate(populationSize, new NondominatedSortingComparator());
        } else {
            this.computeFitnessForLastFront();
            this.population.truncate(populationSize, new NondominatedFitnessComparator());
        }
    }

    private void computeFitnessForLastFront() {
        Population front = new Population();
        int rank = 0;
        for (Solution solution : this.population) {
            int solutionRank = (Integer)solution.getAttribute("rank");
            if (solutionRank > rank) {
                front.clear();
                rank = solutionRank;
            }
            if (solutionRank == rank) {
                front.add(solution);
            }
            solution.setAttribute("fitness", Double.valueOf(0.0));
        }
        this.fitnessEvaluator.evaluate(front);
    }

    private class NondominatedFitnessComparator
    extends ChainedComparator
    implements Comparator<Solution>,
    Serializable {
        private static final long serialVersionUID = -4088873047790962685L;

        public NondominatedFitnessComparator() {
            super(new RankComparator(), new FitnessComparator(SMSEMOA.this.fitnessEvaluator.areLargerValuesPreferred()));
        }
    }
}

