/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.math3.util.KthSelector;
import org.apache.commons.math3.util.Pair;
import org.moeaframework.algorithm.AbstractEvolutionaryAlgorithm;
import org.moeaframework.core.FitnessEvaluator;
import org.moeaframework.core.Initialization;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Selection;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;
import org.moeaframework.core.comparator.DominanceComparator;
import org.moeaframework.core.comparator.FitnessComparator;
import org.moeaframework.core.comparator.ParetoDominanceComparator;
import org.moeaframework.core.indicator.IndicatorUtils;
import org.moeaframework.core.operator.TournamentSelection;

public class SPEA2
extends AbstractEvolutionaryAlgorithm {
    private final Selection selection;
    private final Variation variation;
    private final int numberOfOffspring;
    protected final StrengthFitnessEvaluator fitnessEvaluator;
    protected final FitnessComparator fitnessComparator;

    public SPEA2(Problem problem, Initialization initialization, Variation variation, int numberOfOffspring, int k) {
        super(problem, new Population(), null, initialization);
        this.variation = variation;
        this.numberOfOffspring = numberOfOffspring;
        this.fitnessEvaluator = new StrengthFitnessEvaluator(k);
        this.fitnessComparator = new FitnessComparator(this.fitnessEvaluator.areLargerValuesPreferred());
        this.selection = new TournamentSelection(this.fitnessComparator);
    }

    @Override
    protected void initialize() {
        super.initialize();
        this.fitnessEvaluator.evaluate(this.population);
    }

    @Override
    protected void iterate() {
        Population offspring = new Population();
        int populationSize = this.population.size();
        while (offspring.size() < this.numberOfOffspring) {
            Solution[] parents = this.selection.select(this.variation.getArity(), this.population);
            Solution[] children = this.variation.evolve(parents);
            offspring.addAll(children);
        }
        this.evaluateAll(offspring);
        offspring.addAll(this.population);
        this.fitnessEvaluator.evaluate(offspring);
        this.population.clear();
        this.population.addAll(this.truncate(offspring, populationSize));
    }

    protected Population truncate(Population offspring, int size) {
        Population survivors;
        block4: {
            block3: {
                survivors = new Population();
                Iterator<Solution> iterator = offspring.iterator();
                while (iterator.hasNext()) {
                    Solution solution = iterator.next();
                    double fitness = (Double)solution.getAttribute("fitness");
                    if (!(fitness < 1.0)) continue;
                    survivors.add(solution);
                    iterator.remove();
                }
                if (survivors.size() >= size) break block3;
                offspring.sort(this.fitnessComparator);
                while (survivors.size() < size) {
                    survivors.add(offspring.get(0));
                    offspring.remove(0);
                }
                break block4;
            }
            if (survivors.size() <= size) break block4;
            MutableDistanceMap map = new MutableDistanceMap(this.computeDistanceMatrix(survivors));
            while (survivors.size() > size) {
                int index = map.findMostCrowdedPoint();
                map.removePoint(index);
                survivors.remove(index);
            }
        }
        return survivors;
    }

    protected double[][] computeDistanceMatrix(Population population) {
        double[][] distances = new double[population.size()][population.size()];
        for (int i = 0; i < population.size(); ++i) {
            distances[i][i] = 0.0;
            for (int j = i + 1; j < population.size(); ++j) {
                double d = IndicatorUtils.euclideanDistance(this.problem, population.get(i), population.get(j));
                distances[j][i] = d;
                distances[i][j] = d;
            }
        }
        return distances;
    }

    public class StrengthFitnessEvaluator
    implements FitnessEvaluator {
        private final int k;
        private final DominanceComparator comparator;

        public StrengthFitnessEvaluator(int k) {
            this.k = k;
            this.comparator = new ParetoDominanceComparator();
        }

        @Override
        public void evaluate(Population population) {
            int comparison;
            int j;
            int i;
            int[] strength = new int[population.size()];
            double[] fitness = new double[population.size()];
            for (i = 0; i < population.size() - 1; ++i) {
                for (j = i + 1; j < population.size(); ++j) {
                    comparison = this.comparator.compare(population.get(i), population.get(j));
                    if (comparison < 0) {
                        int n = i;
                        strength[n] = strength[n] + 1;
                        continue;
                    }
                    if (comparison <= 0) continue;
                    int n = j;
                    strength[n] = strength[n] + 1;
                }
            }
            for (i = 0; i < population.size() - 1; ++i) {
                for (j = i + 1; j < population.size(); ++j) {
                    comparison = this.comparator.compare(population.get(i), population.get(j));
                    if (comparison < 0) {
                        int n = j;
                        fitness[n] = fitness[n] + (double)strength[i];
                        continue;
                    }
                    if (comparison <= 0) continue;
                    int n = i;
                    fitness[n] = fitness[n] + (double)strength[j];
                }
            }
            double[][] distances = SPEA2.this.computeDistanceMatrix(population);
            KthSelector selector = new KthSelector();
            int i2 = 0;
            while (i2 < population.size()) {
                double kdist = selector.select(distances[i2], null, this.k);
                int n = i2++;
                fitness[n] = fitness[n] + 1.0 / (kdist + 2.0);
            }
            for (i2 = 0; i2 < population.size(); ++i2) {
                population.get(i2).setAttribute("fitness", Double.valueOf(fitness[i2]));
            }
        }

        @Override
        public boolean areLargerValuesPreferred() {
            return false;
        }
    }

    public static class MutableDistanceMap {
        private List<List<Pair<Integer, Double>>> distanceMatrix;

        public MutableDistanceMap(double[][] rawDistanceMatrix) {
            this.initialize(rawDistanceMatrix);
        }

        protected void initialize(double[][] rawDistanceMatrix) {
            this.distanceMatrix = new LinkedList<List<Pair<Integer, Double>>>();
            for (int i = 0; i < rawDistanceMatrix.length; ++i) {
                LinkedList<Pair> distances = new LinkedList<Pair>();
                for (int j = 0; j < rawDistanceMatrix[i].length; ++j) {
                    if (i == j) continue;
                    distances.add(new Pair((Object)j, (Object)rawDistanceMatrix[i][j]));
                }
                Collections.sort(distances, new Comparator<Pair<Integer, Double>>(){

                    @Override
                    public int compare(Pair<Integer, Double> o1, Pair<Integer, Double> o2) {
                        return Double.compare((Double)o1.getSecond(), (Double)o2.getSecond());
                    }
                });
                this.distanceMatrix.add(distances);
            }
        }

        public int findMostCrowdedPoint() {
            double minimumDistance = Double.POSITIVE_INFINITY;
            int minimumIndex = -1;
            block0: for (int i = 0; i < this.distanceMatrix.size(); ++i) {
                List<Pair<Integer, Double>> distances = this.distanceMatrix.get(i);
                Pair<Integer, Double> point = distances.get(0);
                if ((Double)point.getSecond() < minimumDistance) {
                    minimumDistance = (Double)point.getSecond();
                    minimumIndex = i;
                    continue;
                }
                if ((Double)point.getSecond() != minimumDistance) continue;
                for (int k = 0; k < distances.size(); ++k) {
                    double kdist2;
                    double kdist1 = (Double)distances.get(k).getSecond();
                    if (kdist1 < (kdist2 = ((Double)this.distanceMatrix.get(minimumIndex).get(k).getSecond()).doubleValue())) {
                        minimumIndex = i;
                        continue block0;
                    }
                    if (kdist2 < kdist1) continue block0;
                }
            }
            return minimumIndex;
        }

        public void removePoint(int index) {
            this.distanceMatrix.remove(index);
            for (List<Pair<Integer, Double>> distances : this.distanceMatrix) {
                ListIterator<Pair<Integer, Double>> iterator = distances.listIterator();
                while (iterator.hasNext()) {
                    Pair<Integer, Double> point = iterator.next();
                    if ((Integer)point.getFirst() == index) {
                        iterator.remove();
                        continue;
                    }
                    if ((Integer)point.getFirst() <= index) continue;
                    iterator.set((Pair<Integer, Double>)new Pair((Object)((Integer)point.getFirst() - 1), point.getSecond()));
                }
            }
        }
    }
}

