/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import java.util.Properties;
import org.apache.commons.math3.util.CombinatoricsUtils;
import org.moeaframework.algorithm.AdaptiveTimeContinuation;
import org.moeaframework.algorithm.CMAES;
import org.moeaframework.algorithm.DBEA;
import org.moeaframework.algorithm.EpsilonMOEA;
import org.moeaframework.algorithm.GDE3;
import org.moeaframework.algorithm.IBEA;
import org.moeaframework.algorithm.MOEAD;
import org.moeaframework.algorithm.NSGAII;
import org.moeaframework.algorithm.PAES;
import org.moeaframework.algorithm.PESA2;
import org.moeaframework.algorithm.RVEA;
import org.moeaframework.algorithm.RandomSearch;
import org.moeaframework.algorithm.ReferencePointNondominatedSortingPopulation;
import org.moeaframework.algorithm.ReferenceVectorGuidedPopulation;
import org.moeaframework.algorithm.SMSEMOA;
import org.moeaframework.algorithm.SPEA2;
import org.moeaframework.algorithm.VEGA;
import org.moeaframework.algorithm.pso.OMOPSO;
import org.moeaframework.algorithm.pso.SMPSO;
import org.moeaframework.analysis.sensitivity.EpsilonHelper;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.EpsilonBoxDominanceArchive;
import org.moeaframework.core.FrameworkException;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.NondominatedSortingPopulation;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Selection;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.Variation;
import org.moeaframework.core.comparator.AggregateConstraintComparator;
import org.moeaframework.core.comparator.ChainedComparator;
import org.moeaframework.core.comparator.CrowdingComparator;
import org.moeaframework.core.comparator.DominanceComparator;
import org.moeaframework.core.comparator.ParetoDominanceComparator;
import org.moeaframework.core.fitness.AdditiveEpsilonIndicatorFitnessEvaluator;
import org.moeaframework.core.fitness.HypervolumeContributionFitnessEvaluator;
import org.moeaframework.core.fitness.HypervolumeFitnessEvaluator;
import org.moeaframework.core.fitness.IndicatorFitnessEvaluator;
import org.moeaframework.core.operator.RandomInitialization;
import org.moeaframework.core.operator.TournamentSelection;
import org.moeaframework.core.operator.UniformSelection;
import org.moeaframework.core.operator.real.DifferentialEvolution;
import org.moeaframework.core.operator.real.DifferentialEvolutionSelection;
import org.moeaframework.core.operator.real.UM;
import org.moeaframework.core.spi.AlgorithmProvider;
import org.moeaframework.core.spi.OperatorFactory;
import org.moeaframework.core.spi.ProviderLookupException;
import org.moeaframework.core.spi.ProviderNotFoundException;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.util.TypedProperties;

public class StandardAlgorithms
extends AlgorithmProvider {
    @Override
    public Algorithm getAlgorithm(String name, Properties properties, Problem problem) {
        TypedProperties typedProperties = new TypedProperties(properties);
        try {
            if (name.equalsIgnoreCase("MOEAD") || name.equalsIgnoreCase("MOEA/D")) {
                return this.newMOEAD(typedProperties, problem);
            }
            if (name.equalsIgnoreCase("GDE3")) {
                return this.newGDE3(typedProperties, problem);
            }
            if (name.equalsIgnoreCase("NSGAII") || name.equalsIgnoreCase("NSGA-II") || name.equalsIgnoreCase("NSGA2")) {
                return this.newNSGAII(typedProperties, problem);
            }
            if (name.equalsIgnoreCase("NSGAIII") || name.equalsIgnoreCase("NSGA-III") || name.equalsIgnoreCase("NSGA3")) {
                return this.newNSGAIII(typedProperties, problem);
            }
            if (name.equalsIgnoreCase("eNSGAII") || name.equalsIgnoreCase("e-NSGA-II") || name.equalsIgnoreCase("eNSGA2")) {
                return this.neweNSGAII(typedProperties, problem);
            }
            if (name.equalsIgnoreCase("eMOEA")) {
                return this.neweMOEA(typedProperties, problem);
            }
            if (name.equalsIgnoreCase("CMA-ES") || name.equalsIgnoreCase("CMAES") || name.equalsIgnoreCase("MO-CMA-ES")) {
                return this.newCMAES(typedProperties, problem);
            }
            if (name.equalsIgnoreCase("SPEA2")) {
                return this.newSPEA2(typedProperties, problem);
            }
            if (name.equalsIgnoreCase("PAES")) {
                return this.newPAES(typedProperties, problem);
            }
            if (name.equalsIgnoreCase("PESA2")) {
                return this.newPESA2(typedProperties, problem);
            }
            if (name.equalsIgnoreCase("OMOPSO")) {
                return this.newOMOPSO(typedProperties, problem);
            }
            if (name.equalsIgnoreCase("SMPSO")) {
                return this.newSMPSO(typedProperties, problem);
            }
            if (name.equalsIgnoreCase("IBEA")) {
                return this.newIBEA(typedProperties, problem);
            }
            if (name.equalsIgnoreCase("SMSEMOA") || name.equalsIgnoreCase("SMS-EMOA")) {
                return this.newSMSEMOA(typedProperties, problem);
            }
            if (name.equalsIgnoreCase("VEGA")) {
                return this.newVEGA(typedProperties, problem);
            }
            if (name.equalsIgnoreCase("DBEA") || name.equalsIgnoreCase("I-DBEA")) {
                return this.newDBEA(typedProperties, problem);
            }
            if (name.equalsIgnoreCase("RVEA")) {
                return this.newRVEA(typedProperties, problem);
            }
            if (name.equalsIgnoreCase("Random")) {
                return this.newRandomSearch(typedProperties, problem);
            }
            return null;
        }
        catch (FrameworkException e) {
            throw new ProviderNotFoundException(name, e);
        }
    }

    private boolean checkType(Class<? extends Variable> type, Problem problem) {
        Solution solution = problem.newSolution();
        for (int i = 0; i < solution.getNumberOfVariables(); ++i) {
            if (type.isInstance(solution.getVariable(i))) continue;
            return false;
        }
        return true;
    }

    private Algorithm neweMOEA(TypedProperties properties, Problem problem) {
        int populationSize = (int)properties.getDouble("populationSize", 100.0);
        RandomInitialization initialization = new RandomInitialization(problem, populationSize);
        Population population = new Population();
        ParetoDominanceComparator comparator = new ParetoDominanceComparator();
        EpsilonBoxDominanceArchive archive = new EpsilonBoxDominanceArchive(properties.getDoubleArray("epsilon", new double[]{EpsilonHelper.getEpsilon(problem)}));
        TournamentSelection selection = new TournamentSelection(2, comparator);
        Variation variation = OperatorFactory.getInstance().getVariation(null, properties, problem);
        EpsilonMOEA emoea = new EpsilonMOEA(problem, population, archive, selection, variation, initialization, comparator);
        return emoea;
    }

    private Algorithm newNSGAII(TypedProperties properties, Problem problem) {
        int populationSize = (int)properties.getDouble("populationSize", 100.0);
        RandomInitialization initialization = new RandomInitialization(problem, populationSize);
        NondominatedSortingPopulation population = new NondominatedSortingPopulation();
        TournamentSelection selection = null;
        if (properties.getBoolean("withReplacement", true)) {
            selection = new TournamentSelection(2, new ChainedComparator(new ParetoDominanceComparator(), new CrowdingComparator()));
        }
        Variation variation = OperatorFactory.getInstance().getVariation(null, properties, problem);
        return new NSGAII(problem, population, null, selection, variation, initialization);
    }

    private Algorithm newNSGAIII(TypedProperties properties, Problem problem) {
        int populationSize;
        int divisionsOuter = 4;
        int divisionsInner = 0;
        if (properties.contains("divisionsOuter") && properties.contains("divisionsInner")) {
            divisionsOuter = (int)properties.getDouble("divisionsOuter", 4.0);
            divisionsInner = (int)properties.getDouble("divisionsInner", 0.0);
        } else if (properties.contains("divisions")) {
            divisionsOuter = (int)properties.getDouble("divisions", 4.0);
        } else if (problem.getNumberOfObjectives() == 1) {
            divisionsOuter = 100;
        } else if (problem.getNumberOfObjectives() == 2) {
            divisionsOuter = 99;
        } else if (problem.getNumberOfObjectives() == 3) {
            divisionsOuter = 12;
        } else if (problem.getNumberOfObjectives() == 4) {
            divisionsOuter = 8;
        } else if (problem.getNumberOfObjectives() == 5) {
            divisionsOuter = 6;
        } else if (problem.getNumberOfObjectives() == 6) {
            divisionsOuter = 4;
            divisionsInner = 1;
        } else if (problem.getNumberOfObjectives() == 7) {
            divisionsOuter = 3;
            divisionsInner = 2;
        } else if (problem.getNumberOfObjectives() == 8) {
            divisionsOuter = 3;
            divisionsInner = 2;
        } else if (problem.getNumberOfObjectives() == 9) {
            divisionsOuter = 3;
            divisionsInner = 2;
        } else if (problem.getNumberOfObjectives() == 10) {
            divisionsOuter = 3;
            divisionsInner = 2;
        } else {
            divisionsOuter = 2;
            divisionsInner = 1;
        }
        if (properties.contains("populationSize")) {
            populationSize = (int)properties.getDouble("populationSize", 100.0);
        } else {
            populationSize = (int)(CombinatoricsUtils.binomialCoefficient((int)(problem.getNumberOfObjectives() + divisionsOuter - 1), (int)divisionsOuter) + (divisionsInner == 0 ? 0L : CombinatoricsUtils.binomialCoefficient((int)(problem.getNumberOfObjectives() + divisionsInner - 1), (int)divisionsInner)));
            populationSize = (int)Math.ceil((double)populationSize / 4.0) * 4;
        }
        RandomInitialization initialization = new RandomInitialization(problem, populationSize);
        ReferencePointNondominatedSortingPopulation population = new ReferencePointNondominatedSortingPopulation(problem.getNumberOfObjectives(), divisionsOuter, divisionsInner);
        Selection selection = null;
        selection = problem.getNumberOfConstraints() == 0 ? new Selection(){

            @Override
            public Solution[] select(int arity, Population population) {
                Solution[] result = new Solution[arity];
                for (int i = 0; i < arity; ++i) {
                    result[i] = population.get(PRNG.nextInt(population.size()));
                }
                return result;
            }
        } : new TournamentSelection(2, new ChainedComparator(new AggregateConstraintComparator(), new DominanceComparator(){

            @Override
            public int compare(Solution solution1, Solution solution2) {
                return PRNG.nextBoolean() ? -1 : 1;
            }
        }));
        if (!properties.contains("sbx.swap")) {
            properties.setBoolean("sbx.swap", false);
        }
        if (!properties.contains("sbx.distributionIndex")) {
            properties.setDouble("sbx.distributionIndex", 30.0);
        }
        if (!properties.contains("pm.distributionIndex")) {
            properties.setDouble("pm.distributionIndex", 20.0);
        }
        Variation variation = OperatorFactory.getInstance().getVariation(null, properties, problem);
        return new NSGAII(problem, population, null, selection, variation, initialization);
    }

    private Algorithm newMOEAD(TypedProperties properties, Problem problem) {
        if (!this.checkType(RealVariable.class, problem)) {
            throw new FrameworkException("unsupported decision variable type");
        }
        int populationSize = (int)properties.getDouble("populationSize", 100.0);
        if (populationSize < problem.getNumberOfObjectives()) {
            System.err.println("increasing MOEA/D population size");
            populationSize = problem.getNumberOfObjectives();
        }
        RandomInitialization initialization = new RandomInitialization(problem, populationSize);
        Variation variation = OperatorFactory.getInstance().getVariation("de+pm", properties, problem);
        int neighborhoodSize = 20;
        int eta = 2;
        if (properties.contains("neighborhoodSize")) {
            neighborhoodSize = Math.max(2, (int)(properties.getDouble("neighborhoodSize", 0.1) * (double)populationSize));
        }
        if (neighborhoodSize > populationSize) {
            neighborhoodSize = populationSize;
        }
        if (properties.contains("eta")) {
            eta = Math.max(2, (int)(properties.getDouble("eta", 0.01) * (double)populationSize));
        }
        MOEAD algorithm = new MOEAD(problem, neighborhoodSize, initialization, variation, properties.getDouble("delta", 0.9), (double)eta, (int)properties.getDouble("updateUtility", -1.0));
        return algorithm;
    }

    private Algorithm newGDE3(TypedProperties properties, Problem problem) {
        if (!this.checkType(RealVariable.class, problem)) {
            throw new FrameworkException("unsupported decision variable type");
        }
        int populationSize = (int)properties.getDouble("populationSize", 100.0);
        ParetoDominanceComparator comparator = new ParetoDominanceComparator();
        NondominatedSortingPopulation population = new NondominatedSortingPopulation(comparator);
        RandomInitialization initialization = new RandomInitialization(problem, populationSize);
        DifferentialEvolutionSelection selection = new DifferentialEvolutionSelection();
        DifferentialEvolution variation = (DifferentialEvolution)OperatorFactory.getInstance().getVariation("de", properties, problem);
        return new GDE3(problem, population, comparator, selection, variation, initialization);
    }

    private Algorithm neweNSGAII(TypedProperties properties, Problem problem) {
        int populationSize = (int)properties.getDouble("populationSize", 100.0);
        RandomInitialization initialization = new RandomInitialization(problem, populationSize);
        NondominatedSortingPopulation population = new NondominatedSortingPopulation(new ParetoDominanceComparator());
        EpsilonBoxDominanceArchive archive = new EpsilonBoxDominanceArchive(properties.getDoubleArray("epsilon", new double[]{EpsilonHelper.getEpsilon(problem)}));
        TournamentSelection selection = new TournamentSelection(2, new ChainedComparator(new ParetoDominanceComparator(), new CrowdingComparator()));
        Variation variation = OperatorFactory.getInstance().getVariation(null, properties, problem);
        NSGAII nsgaii = new NSGAII(problem, population, archive, selection, variation, initialization);
        AdaptiveTimeContinuation algorithm = new AdaptiveTimeContinuation(nsgaii, properties.getInt("windowSize", 100), Math.max(properties.getInt("windowSize", 100), properties.getInt("maxWindowSize", 100)), 1.0 / properties.getDouble("injectionRate", 0.25), properties.getInt("minimumPopulationSize", 100), properties.getInt("maximumPopulationSize", 10000), new UniformSelection(), new UM(1.0));
        return algorithm;
    }

    private Algorithm newCMAES(TypedProperties properties, Problem problem) {
        if (!this.checkType(RealVariable.class, problem)) {
            throw new FrameworkException("unsupported decision variable type");
        }
        int lambda = (int)properties.getDouble("lambda", 100.0);
        double cc = properties.getDouble("cc", -1.0);
        double cs = properties.getDouble("cs", -1.0);
        double damps = properties.getDouble("damps", -1.0);
        double ccov = properties.getDouble("ccov", -1.0);
        double ccovsep = properties.getDouble("ccovsep", -1.0);
        double sigma = properties.getDouble("sigma", -1.0);
        int diagonalIterations = (int)properties.getDouble("diagonalIterations", 0.0);
        String indicator = properties.getString("indicator", "crowding");
        double[] initialSearchPoint = properties.getDoubleArray("initialSearchPoint", null);
        NondominatedPopulation archive = null;
        IndicatorFitnessEvaluator fitnessEvaluator = null;
        archive = problem.getNumberOfObjectives() == 1 ? new NondominatedPopulation() : new EpsilonBoxDominanceArchive(properties.getDoubleArray("epsilon", new double[]{EpsilonHelper.getEpsilon(problem)}));
        if ("hypervolume".equals(indicator)) {
            fitnessEvaluator = new HypervolumeFitnessEvaluator(problem);
        } else if ("epsilon".equals(indicator)) {
            fitnessEvaluator = new AdditiveEpsilonIndicatorFitnessEvaluator(problem);
        }
        CMAES cmaes = new CMAES(problem, lambda, fitnessEvaluator, archive, initialSearchPoint, false, cc, cs, damps, ccov, ccovsep, sigma, diagonalIterations);
        return cmaes;
    }

    private Algorithm newSPEA2(TypedProperties properties, Problem problem) {
        int populationSize = (int)properties.getDouble("populationSize", 100.0);
        int offspringSize = (int)properties.getDouble("offspringSize", 100.0);
        int k = (int)properties.getDouble("k", 1.0);
        RandomInitialization initialization = new RandomInitialization(problem, populationSize);
        Variation variation = OperatorFactory.getInstance().getVariation(null, properties, problem);
        return new SPEA2(problem, initialization, variation, offspringSize, k);
    }

    private Algorithm newPAES(TypedProperties properties, Problem problem) {
        int archiveSize = (int)properties.getDouble("archiveSize", 100.0);
        int bisections = (int)properties.getDouble("bisections", 8.0);
        Variation variation = OperatorFactory.getInstance().getVariation(OperatorFactory.getInstance().getDefaultMutation(problem), properties, problem);
        return new PAES(problem, variation, bisections, archiveSize);
    }

    private Algorithm newPESA2(TypedProperties properties, Problem problem) {
        int populationSize = (int)properties.getDouble("populationSize", 100.0);
        int archiveSize = (int)properties.getDouble("archiveSize", 100.0);
        int bisections = (int)properties.getDouble("bisections", 8.0);
        RandomInitialization initialization = new RandomInitialization(problem, populationSize);
        Variation variation = OperatorFactory.getInstance().getVariation(null, properties, problem);
        return new PESA2(problem, variation, initialization, bisections, archiveSize);
    }

    private Algorithm newOMOPSO(TypedProperties properties, Problem problem) {
        if (!this.checkType(RealVariable.class, problem)) {
            throw new FrameworkException("unsupported decision variable type");
        }
        int populationSize = (int)properties.getDouble("populationSize", 100.0);
        int archiveSize = (int)properties.getDouble("archiveSize", 100.0);
        int maxIterations = (int)properties.getDouble("maxEvaluations", 25000.0) / populationSize;
        double mutationProbability = properties.getDouble("mutationProbability", 1.0 / (double)problem.getNumberOfVariables());
        double perturbationIndex = properties.getDouble("perturbationIndex", 0.5);
        double[] epsilon = properties.getDoubleArray("epsilon", new double[]{EpsilonHelper.getEpsilon(problem)});
        return new OMOPSO(problem, populationSize, archiveSize, epsilon, mutationProbability, perturbationIndex, maxIterations);
    }

    private Algorithm newSMPSO(TypedProperties properties, Problem problem) {
        if (!this.checkType(RealVariable.class, problem)) {
            throw new FrameworkException("unsupported decision variable type");
        }
        int populationSize = (int)properties.getDouble("populationSize", 100.0);
        int archiveSize = (int)properties.getDouble("archiveSize", 100.0);
        double mutationProbability = properties.getDouble("pm.rate", 1.0 / (double)problem.getNumberOfVariables());
        double distributionIndex = properties.getDouble("pm.distributionIndex", 20.0);
        return new SMPSO(problem, populationSize, archiveSize, mutationProbability, distributionIndex);
    }

    private Algorithm newIBEA(TypedProperties properties, Problem problem) {
        if (problem.getNumberOfConstraints() > 0) {
            throw new ProviderNotFoundException("IBEA", new ProviderLookupException("constraints not supported"));
        }
        int populationSize = (int)properties.getDouble("populationSize", 100.0);
        String indicator = properties.getString("indicator", "hypervolume");
        IndicatorFitnessEvaluator fitnessEvaluator = null;
        RandomInitialization initialization = new RandomInitialization(problem, populationSize);
        Variation variation = OperatorFactory.getInstance().getVariation(null, properties, problem);
        if ("hypervolume".equals(indicator)) {
            fitnessEvaluator = new HypervolumeFitnessEvaluator(problem);
        } else if ("epsilon".equals(indicator)) {
            fitnessEvaluator = new AdditiveEpsilonIndicatorFitnessEvaluator(problem);
        } else {
            throw new IllegalArgumentException("invalid indicator: " + indicator);
        }
        return new IBEA(problem, null, initialization, variation, fitnessEvaluator);
    }

    private Algorithm newSMSEMOA(TypedProperties properties, Problem problem) {
        int populationSize = (int)properties.getDouble("populationSize", 100.0);
        double offset = properties.getDouble("offset", 100.0);
        String indicator = properties.getString("indicator", "hypervolume");
        HypervolumeContributionFitnessEvaluator fitnessEvaluator = null;
        RandomInitialization initialization = new RandomInitialization(problem, populationSize);
        Variation variation = OperatorFactory.getInstance().getVariation(null, properties, problem);
        if ("hypervolume".equals(indicator)) {
            fitnessEvaluator = new HypervolumeContributionFitnessEvaluator(problem, offset);
        }
        return new SMSEMOA(problem, initialization, variation, fitnessEvaluator);
    }

    private Algorithm newVEGA(TypedProperties properties, Problem problem) {
        int populationSize = (int)properties.getDouble("populationSize", 100.0);
        RandomInitialization initialization = new RandomInitialization(problem, populationSize);
        Variation variation = OperatorFactory.getInstance().getVariation(null, properties, problem);
        return new VEGA(problem, new Population(), null, initialization, variation);
    }

    private Algorithm newDBEA(TypedProperties properties, Problem problem) {
        int divisionsOuter = 4;
        int divisionsInner = 0;
        if (properties.contains("divisionsOuter") && properties.contains("divisionsInner")) {
            divisionsOuter = (int)properties.getDouble("divisionsOuter", 4.0);
            divisionsInner = (int)properties.getDouble("divisionsInner", 0.0);
        } else if (properties.contains("divisions")) {
            divisionsOuter = (int)properties.getDouble("divisions", 4.0);
        } else if (problem.getNumberOfObjectives() == 1) {
            divisionsOuter = 100;
        } else if (problem.getNumberOfObjectives() == 2) {
            divisionsOuter = 99;
        } else if (problem.getNumberOfObjectives() == 3) {
            divisionsOuter = 12;
        } else if (problem.getNumberOfObjectives() == 4) {
            divisionsOuter = 8;
        } else if (problem.getNumberOfObjectives() == 5) {
            divisionsOuter = 6;
        } else if (problem.getNumberOfObjectives() == 6) {
            divisionsOuter = 4;
            divisionsInner = 1;
        } else if (problem.getNumberOfObjectives() == 7) {
            divisionsOuter = 3;
            divisionsInner = 2;
        } else if (problem.getNumberOfObjectives() == 8) {
            divisionsOuter = 3;
            divisionsInner = 2;
        } else if (problem.getNumberOfObjectives() == 9) {
            divisionsOuter = 3;
            divisionsInner = 2;
        } else if (problem.getNumberOfObjectives() == 10) {
            divisionsOuter = 3;
            divisionsInner = 2;
        } else {
            divisionsOuter = 2;
            divisionsInner = 1;
        }
        int populationSize = (int)(CombinatoricsUtils.binomialCoefficient((int)(problem.getNumberOfObjectives() + divisionsOuter - 1), (int)divisionsOuter) + (divisionsInner == 0 ? 0L : CombinatoricsUtils.binomialCoefficient((int)(problem.getNumberOfObjectives() + divisionsInner - 1), (int)divisionsInner)));
        RandomInitialization initialization = new RandomInitialization(problem, populationSize);
        Variation variation = OperatorFactory.getInstance().getVariation(null, properties, problem);
        return new DBEA(problem, initialization, variation, divisionsOuter, divisionsInner);
    }

    private Algorithm newRVEA(TypedProperties properties, Problem problem) {
        int divisionsOuter = 4;
        int divisionsInner = 0;
        if (problem.getNumberOfObjectives() < 2) {
            throw new FrameworkException("RVEA requires at least two objectives");
        }
        if (properties.contains("divisionsOuter") && properties.contains("divisionsInner")) {
            divisionsOuter = (int)properties.getDouble("divisionsOuter", 4.0);
            divisionsInner = (int)properties.getDouble("divisionsInner", 0.0);
        } else if (properties.contains("divisions")) {
            divisionsOuter = (int)properties.getDouble("divisions", 4.0);
        } else if (problem.getNumberOfObjectives() == 1) {
            divisionsOuter = 100;
        } else if (problem.getNumberOfObjectives() == 2) {
            divisionsOuter = 99;
        } else if (problem.getNumberOfObjectives() == 3) {
            divisionsOuter = 12;
        } else if (problem.getNumberOfObjectives() == 4) {
            divisionsOuter = 8;
        } else if (problem.getNumberOfObjectives() == 5) {
            divisionsOuter = 6;
        } else if (problem.getNumberOfObjectives() == 6) {
            divisionsOuter = 4;
            divisionsInner = 1;
        } else if (problem.getNumberOfObjectives() == 7) {
            divisionsOuter = 3;
            divisionsInner = 2;
        } else if (problem.getNumberOfObjectives() == 8) {
            divisionsOuter = 3;
            divisionsInner = 2;
        } else if (problem.getNumberOfObjectives() == 9) {
            divisionsOuter = 3;
            divisionsInner = 2;
        } else if (problem.getNumberOfObjectives() == 10) {
            divisionsOuter = 3;
            divisionsInner = 2;
        } else {
            divisionsOuter = 2;
            divisionsInner = 1;
        }
        int populationSize = (int)(CombinatoricsUtils.binomialCoefficient((int)(problem.getNumberOfObjectives() + divisionsOuter - 1), (int)divisionsOuter) + (divisionsInner == 0 ? 0L : CombinatoricsUtils.binomialCoefficient((int)(problem.getNumberOfObjectives() + divisionsInner - 1), (int)divisionsInner)));
        RandomInitialization initialization = new RandomInitialization(problem, populationSize);
        ReferenceVectorGuidedPopulation population = new ReferenceVectorGuidedPopulation(problem.getNumberOfObjectives(), divisionsOuter, divisionsInner, properties.getDouble("alpha", 2.0));
        if (!properties.contains("sbx.swap")) {
            properties.setBoolean("sbx.swap", false);
        }
        if (!properties.contains("sbx.distributionIndex")) {
            properties.setDouble("sbx.distributionIndex", 30.0);
        }
        if (!properties.contains("pm.distributionIndex")) {
            properties.setDouble("pm.distributionIndex", 20.0);
        }
        Variation variation = OperatorFactory.getInstance().getVariation(null, properties, problem);
        int maxGenerations = (int)(properties.getDouble("maxEvaluations", 10000.0) / (double)populationSize);
        int adaptFrequency = (int)properties.getDouble("adaptFrequency", maxGenerations / 10);
        return new RVEA(problem, population, variation, initialization, maxGenerations, adaptFrequency);
    }

    private Algorithm newRandomSearch(TypedProperties properties, Problem problem) {
        int populationSize = (int)properties.getDouble("populationSize", 100.0);
        RandomInitialization generator = new RandomInitialization(problem, populationSize);
        NondominatedPopulation archive = null;
        archive = properties.contains("epsilon") ? new EpsilonBoxDominanceArchive(properties.getDoubleArray("epsilon", new double[]{EpsilonHelper.getEpsilon(problem)})) : new NondominatedPopulation();
        return new RandomSearch(problem, generator, archive);
    }
}

