/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm;

import org.moeaframework.algorithm.AbstractEvolutionaryAlgorithm;
import org.moeaframework.core.Initialization;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Population;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Selection;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;
import org.moeaframework.core.comparator.ObjectiveComparator;
import org.moeaframework.core.operator.TournamentSelection;

public class VEGA
extends AbstractEvolutionaryAlgorithm {
    private Selection selection;
    private Variation variation;

    public VEGA(Problem problem, Population population, NondominatedPopulation archive, Initialization initialization, Variation variation) {
        super(problem, population, archive, initialization);
        this.variation = variation;
        this.selection = new VEGASelection();
    }

    @Override
    protected void iterate() {
        int populationSize = this.population.size();
        Solution[] parents = this.selection.select(populationSize, this.population);
        PRNG.shuffle(parents);
        int index = 0;
        boolean filled = false;
        this.population.clear();
        while (!filled) {
            Solution[] offspring = this.variation.evolve(this.select(parents, index, this.variation.getArity()));
            for (int i = 0; i < offspring.length; ++i) {
                this.population.add(offspring[i]);
                if (this.population.size() < populationSize) continue;
                filled = true;
                break;
            }
            index += this.variation.getArity() % populationSize;
        }
        this.evaluateAll(this.population);
    }

    private Solution[] select(Solution[] parents, int index, int size) {
        Solution[] result = new Solution[size];
        for (int i = 0; i < size; ++i) {
            result[i] = parents[(index + i) % parents.length];
        }
        return result;
    }

    private class VEGASelection
    implements Selection {
        private Selection[] selectors;

        public VEGASelection() {
            this.selectors = new Selection[VEGA.this.problem.getNumberOfObjectives()];
            for (int i = 0; i < VEGA.this.problem.getNumberOfObjectives(); ++i) {
                this.selectors[i] = new TournamentSelection(new ObjectiveComparator(i));
            }
        }

        @Override
        public Solution[] select(int arity, Population population) {
            Solution[] result = new Solution[arity];
            for (int i = 0; i < arity; ++i) {
                Selection selector = this.selectors[i % VEGA.this.problem.getNumberOfObjectives()];
                result[i] = selector.select(1, population)[0];
            }
            return result;
        }
    }
}

