/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm.jmetal;

import java.io.NotSerializableException;
import java.io.Serializable;
import jmetal.core.SolutionSet;
import org.moeaframework.algorithm.AlgorithmException;
import org.moeaframework.algorithm.jmetal.JMetalProblemAdapter;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;

public class JMetalAlgorithmAdapter
implements Algorithm {
    private final jmetal.core.Algorithm algorithm;
    private final JMetalProblemAdapter problem;
    private SolutionSet solutionSet;

    public JMetalAlgorithmAdapter(jmetal.core.Algorithm algorithm, JMetalProblemAdapter problem) {
        this.algorithm = algorithm;
        this.problem = problem;
    }

    @Override
    public void evaluate(Solution solution) {
        this.problem.getProblem().evaluate(solution);
    }

    @Override
    public int getNumberOfEvaluations() {
        if (this.solutionSet == null) {
            return 0;
        }
        Integer result = (Integer)this.algorithm.getInputParameter("maxEvaluations");
        if (result == null) {
            Integer maxIterations = (Integer)this.algorithm.getInputParameter("maxIterations");
            Integer populationSize = (Integer)this.algorithm.getInputParameter("populationSize");
            if (populationSize == null) {
                populationSize = (Integer)this.algorithm.getInputParameter("swarmSize");
            }
            result = maxIterations * populationSize;
        }
        return result;
    }

    @Override
    public Problem getProblem() {
        return this.problem.getProblem();
    }

    @Override
    public NondominatedPopulation getResult() {
        NondominatedPopulation result = new NondominatedPopulation();
        if (this.solutionSet != null) {
            for (int i = 0; i < this.solutionSet.size(); ++i) {
                result.add(this.problem.translate(this.solutionSet.get(i)));
            }
        }
        return result;
    }

    @Override
    public void step() {
        if (this.solutionSet == null) {
            try {
                this.solutionSet = this.algorithm.execute();
            }
            catch (Exception e) {
                throw new AlgorithmException((Algorithm)this, (Throwable)e);
            }
        }
    }

    @Override
    public boolean isTerminated() {
        return this.solutionSet != null;
    }

    @Override
    public void terminate() {
        if (this.solutionSet == null) {
            this.solutionSet = new SolutionSet();
        }
    }

    @Override
    public Serializable getState() throws NotSerializableException {
        throw new NotSerializableException(this.getClass().getName());
    }

    @Override
    public void setState(Object state) throws NotSerializableException {
        throw new NotSerializableException(this.getClass().getName());
    }
}

