/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm.jmetal;

import java.util.HashMap;
import java.util.Properties;
import jmetal.core.SolutionType;
import jmetal.encodings.solutionType.BinaryRealSolutionType;
import jmetal.encodings.solutionType.BinarySolutionType;
import jmetal.encodings.solutionType.PermutationSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.metaheuristics.abyss.AbYSS;
import jmetal.metaheuristics.cellde.CellDE;
import jmetal.metaheuristics.densea.DENSEA;
import jmetal.metaheuristics.fastPGA.FastPGA;
import jmetal.metaheuristics.gde3.GDE3;
import jmetal.metaheuristics.ibea.IBEA;
import jmetal.metaheuristics.mocell.MOCell;
import jmetal.metaheuristics.mochc.MOCHC;
import jmetal.metaheuristics.nsgaII.NSGAII;
import jmetal.metaheuristics.omopso.OMOPSO;
import jmetal.metaheuristics.paes.PAES;
import jmetal.metaheuristics.pesa2.PESA2;
import jmetal.metaheuristics.smpso.SMPSO;
import jmetal.metaheuristics.smsemoa.SMSEMOA;
import jmetal.metaheuristics.spea2.SPEA2;
import jmetal.operators.crossover.Crossover;
import jmetal.operators.crossover.DifferentialEvolutionCrossover;
import jmetal.operators.crossover.HUXCrossover;
import jmetal.operators.crossover.PMXCrossover;
import jmetal.operators.crossover.SBXCrossover;
import jmetal.operators.crossover.SinglePointCrossover;
import jmetal.operators.localSearch.MutationLocalSearch;
import jmetal.operators.mutation.BitFlipMutation;
import jmetal.operators.mutation.Mutation;
import jmetal.operators.mutation.NonUniformMutation;
import jmetal.operators.mutation.PolynomialMutation;
import jmetal.operators.mutation.SwapMutation;
import jmetal.operators.mutation.UniformMutation;
import jmetal.operators.selection.BinaryTournament;
import jmetal.operators.selection.BinaryTournament2;
import jmetal.operators.selection.DifferentialEvolutionSelection;
import jmetal.operators.selection.RandomSelection;
import jmetal.operators.selection.RankingAndCrowdingSelection;
import jmetal.util.JMException;
import jmetal.util.comparators.FPGAFitnessComparator;
import jmetal.util.comparators.FitnessComparator;
import org.moeaframework.algorithm.jmetal.JMetalAlgorithmAdapter;
import org.moeaframework.algorithm.jmetal.JMetalProblemAdapter;
import org.moeaframework.analysis.sensitivity.EpsilonHelper;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.Problem;
import org.moeaframework.core.spi.AlgorithmProvider;
import org.moeaframework.core.spi.ProviderNotFoundException;
import org.moeaframework.util.TypedProperties;

public class JMetalAlgorithms
extends AlgorithmProvider {
    @Override
    public Algorithm getAlgorithm(String name, Properties properties, Problem problem) {
        TypedProperties typedProperties = new TypedProperties(properties);
        JMetalProblemAdapter adapter = new JMetalProblemAdapter(problem);
        jmetal.core.Algorithm algorithm = null;
        try {
            if (name.equalsIgnoreCase("AbYSS") || name.equalsIgnoreCase("AbYSS-JMetal")) {
                algorithm = this.newAbYSS(typedProperties, adapter);
            } else if (name.equalsIgnoreCase("CellDE") || name.equalsIgnoreCase("CellDE-JMetal")) {
                algorithm = this.newCellDE(typedProperties, adapter);
            } else if (name.equalsIgnoreCase("DENSEA") || name.equalsIgnoreCase("DENSEA-JMetal")) {
                algorithm = this.newDENSEA(typedProperties, adapter);
            } else if (name.equalsIgnoreCase("FastPGA") || name.equalsIgnoreCase("FastPGA-JMetal")) {
                algorithm = this.newFastPGA(typedProperties, adapter);
            } else if (name.equalsIgnoreCase("GDE3") || name.equalsIgnoreCase("GDE3-JMetal")) {
                algorithm = this.newGDE3(typedProperties, adapter);
            } else if (name.equalsIgnoreCase("IBEA") || name.equalsIgnoreCase("IBEA-JMetal")) {
                algorithm = this.newIBEA(typedProperties, adapter);
            } else if (name.equalsIgnoreCase("MOCell") || name.equalsIgnoreCase("MOCell-JMetal")) {
                algorithm = this.newMOCell(typedProperties, adapter);
            } else if (name.equalsIgnoreCase("MOCHC") || name.equalsIgnoreCase("MOCHC-JMetal")) {
                algorithm = this.newMOCHC(typedProperties, adapter);
            } else if (name.equalsIgnoreCase("NSGAII") || name.equalsIgnoreCase("NSGAII-JMetal")) {
                algorithm = this.newNSGAII(typedProperties, adapter);
            } else if (name.equalsIgnoreCase("OMOPSO") || name.equalsIgnoreCase("OMOPSO-JMetal")) {
                algorithm = this.newOMOPSO(typedProperties, adapter);
            } else if (name.equalsIgnoreCase("PAES") || name.equalsIgnoreCase("PAES-JMetal")) {
                algorithm = this.newPAES(typedProperties, adapter);
            } else if (name.equalsIgnoreCase("PESA2") || name.equalsIgnoreCase("PESA2-JMetal")) {
                algorithm = this.newPESA2(typedProperties, adapter);
            } else if (name.equalsIgnoreCase("SMPSO") || name.equalsIgnoreCase("SMPSO-JMetal")) {
                algorithm = this.newSMPSO(typedProperties, adapter);
            } else if (name.equalsIgnoreCase("SMSEMOA") || name.equalsIgnoreCase("SMSEMOA-JMetal")) {
                algorithm = this.newSMSEMOA(typedProperties, adapter);
            } else if (name.equalsIgnoreCase("SPEA2") || name.equalsIgnoreCase("SPEA2-JMetal")) {
                algorithm = this.newSPEA2(typedProperties, adapter);
            }
        }
        catch (JMException e) {
            throw new ProviderNotFoundException(name, e);
        }
        if (algorithm == null) {
            return null;
        }
        return new JMetalAlgorithmAdapter(algorithm, adapter);
    }

    private void setupVariationOperators(jmetal.core.Algorithm algorithm, TypedProperties properties, JMetalProblemAdapter problem) throws JMException {
        Crossover crossover = null;
        Mutation mutation = null;
        HashMap<String, Object> parameters = null;
        SolutionType solutionType = problem.getSolutionType();
        if (solutionType instanceof BinarySolutionType || solutionType instanceof BinaryRealSolutionType) {
            parameters = new HashMap<String, Object>();
            parameters.put("probability", properties.getDouble("1x.rate", 0.9));
            crossover = new SinglePointCrossover(parameters);
            parameters = new HashMap();
            parameters.put("probability", properties.getDouble("bf.rate", 1.0 / (double)problem.getLength(0)));
            mutation = new BitFlipMutation(parameters);
        } else if (solutionType instanceof RealSolutionType) {
            parameters = new HashMap();
            parameters.put("probability", properties.getDouble("sbx.rate", 1.0));
            parameters.put("distributionIndex", properties.getDouble("sbx.distributionIndex", 15.0));
            crossover = new SBXCrossover(parameters);
            parameters = new HashMap();
            parameters.put("probability", properties.getDouble("pm.rate", 1.0 / (double)problem.getNumberOfVariables()));
            parameters.put("distributionIndex", properties.getDouble("pm.distributionIndex", 20.0));
            mutation = new PolynomialMutation(parameters);
        } else if (solutionType instanceof PermutationSolutionType) {
            parameters = new HashMap();
            parameters.put("probability", properties.getDouble("pmx.rate", 1.0));
            crossover = new PMXCrossover(parameters);
            parameters = new HashMap();
            parameters.put("probability", properties.getDouble("swap.rate", 0.35));
            mutation = new SwapMutation(parameters);
        } else {
            throw new JMException("solution type not supported");
        }
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("mutation", mutation);
    }

    private AbYSS newAbYSS(TypedProperties properties, JMetalProblemAdapter problem) throws JMException {
        if (!(problem.getSolutionType() instanceof RealSolutionType)) {
            throw new JMException("unsupported solution type");
        }
        AbYSS algorithm = new AbYSS(problem);
        algorithm.setInputParameter("populationSize", (int)properties.getDouble("populationSize", 20.0));
        algorithm.setInputParameter("refSet1Size", (int)properties.getDouble("refSet1Size", 10.0));
        algorithm.setInputParameter("refSet2Size", (int)properties.getDouble("refSet2Size", 10.0));
        algorithm.setInputParameter("archiveSize", (int)properties.getDouble("archiveSize", 100.0));
        algorithm.setInputParameter("maxEvaluations", (int)properties.getDouble("maxEvaluations", 25000.0));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("probability", properties.getDouble("sbx.rate", 1.0));
        parameters.put("distributionIndex", properties.getDouble("sbx.distributionIndex", 15.0));
        SBXCrossover crossover = new SBXCrossover(parameters);
        parameters = new HashMap();
        parameters.put("probability", properties.getDouble("pm.rate", 1.0 / (double)problem.getNumberOfVariables()));
        parameters.put("distributionIndex", properties.getDouble("pm.distributionIndex", 20.0));
        PolynomialMutation mutation = new PolynomialMutation(parameters);
        parameters = new HashMap();
        parameters.put("problem", problem);
        parameters.put("improvementRounds", (int)properties.getDouble("improvementRounds", 1.0));
        parameters.put("mutation", mutation);
        MutationLocalSearch improvement = new MutationLocalSearch(parameters);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("improvement", improvement);
        return algorithm;
    }

    private CellDE newCellDE(TypedProperties properties, JMetalProblemAdapter problem) throws JMException {
        if (!(problem.getSolutionType() instanceof RealSolutionType)) {
            throw new JMException("unsupported solution type");
        }
        CellDE algorithm = new CellDE(problem);
        algorithm.setInputParameter("populationSize", (int)properties.getDouble("populationSize", 100.0));
        algorithm.setInputParameter("archiveSize", (int)properties.getDouble("archiveSize", 100.0));
        algorithm.setInputParameter("maxEvaluations", (int)properties.getDouble("maxEvaluations", 25000.0));
        algorithm.setInputParameter("feedBack", (int)properties.getDouble("feedBack", 20.0));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("CR", properties.getDouble("de.crossoverRate", 0.1));
        parameters.put("F", properties.getDouble("de.stepSize", 0.5));
        DifferentialEvolutionCrossover crossover = new DifferentialEvolutionCrossover(parameters);
        BinaryTournament selection = new BinaryTournament(null);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }

    private DENSEA newDENSEA(TypedProperties properties, JMetalProblemAdapter problem) throws JMException {
        DENSEA algorithm = new DENSEA(problem);
        algorithm.setInputParameter("populationSize", (int)properties.getDouble("populationSize", 100.0));
        algorithm.setInputParameter("maxEvaluations", (int)properties.getDouble("maxEvaluations", 25000.0));
        this.setupVariationOperators(algorithm, properties, problem);
        BinaryTournament selection = new BinaryTournament(null);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }

    private FastPGA newFastPGA(TypedProperties properties, JMetalProblemAdapter problem) throws JMException {
        FastPGA algorithm = new FastPGA(problem);
        algorithm.setInputParameter("maxPopSize", (int)properties.getDouble("maxPopSize", 100.0));
        algorithm.setInputParameter("initialPopulationSize", (int)properties.getDouble("initialPopulationSize", 100.0));
        algorithm.setInputParameter("maxEvaluations", (int)properties.getDouble("maxEvaluations", 25000.0));
        algorithm.setInputParameter("a", properties.getDouble("a", 20.0));
        algorithm.setInputParameter("b", properties.getDouble("b", 1.0));
        algorithm.setInputParameter("c", properties.getDouble("c", 20.0));
        algorithm.setInputParameter("d", properties.getDouble("d", 0.0));
        algorithm.setInputParameter("termination", (int)properties.getDouble("termination", 1.0));
        this.setupVariationOperators(algorithm, properties, problem);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("comparator", new FPGAFitnessComparator());
        BinaryTournament selection = new BinaryTournament(parameters);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }

    private GDE3 newGDE3(TypedProperties properties, JMetalProblemAdapter problem) throws JMException {
        if (!(problem.getSolutionType() instanceof RealSolutionType)) {
            throw new JMException("unsupported solution type");
        }
        GDE3 algorithm = new GDE3(problem);
        int populationSize = (int)properties.getDouble("populationSize", 100.0);
        algorithm.setInputParameter("populationSize", populationSize);
        algorithm.setInputParameter("maxIterations", (int)properties.getDouble("maxEvaluations", 25000.0) / populationSize);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("CR", properties.getDouble("de.crossoverRate", 0.1));
        parameters.put("F", properties.getDouble("de.stepSize", 0.5));
        DifferentialEvolutionCrossover crossover = new DifferentialEvolutionCrossover(parameters);
        DifferentialEvolutionSelection selection = new DifferentialEvolutionSelection(null);
        algorithm.addOperator("crossover", crossover);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }

    private IBEA newIBEA(TypedProperties properties, JMetalProblemAdapter problem) throws JMException {
        IBEA algorithm = new IBEA(problem);
        algorithm.setInputParameter("populationSize", (int)properties.getDouble("populationSize", 100.0));
        algorithm.setInputParameter("archiveSize", (int)properties.getDouble("archiveSize", 100.0));
        algorithm.setInputParameter("maxEvaluations", (int)properties.getDouble("maxEvaluations", 25000.0));
        this.setupVariationOperators(algorithm, properties, problem);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("comparator", new FitnessComparator());
        BinaryTournament selection = new BinaryTournament(parameters);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }

    private MOCell newMOCell(TypedProperties properties, JMetalProblemAdapter problem) throws JMException {
        MOCell algorithm = new MOCell(problem);
        algorithm.setInputParameter("populationSize", (int)properties.getDouble("populationSize", 100.0));
        algorithm.setInputParameter("archiveSize", (int)properties.getDouble("archiveSize", 100.0));
        algorithm.setInputParameter("maxEvaluations", (int)properties.getDouble("maxEvaluations", 25000.0));
        algorithm.setInputParameter("feedBack", (int)properties.getDouble("feedBack", 20.0));
        this.setupVariationOperators(algorithm, properties, problem);
        BinaryTournament selection = new BinaryTournament(null);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }

    private MOCHC newMOCHC(TypedProperties properties, JMetalProblemAdapter problem) throws JMException {
        if (!(problem.getSolutionType() instanceof BinarySolutionType)) {
            throw new JMException("unsupported solution type");
        }
        MOCHC algorithm = new MOCHC(problem);
        algorithm.setInputParameter("initialConvergenceCount", properties.getDouble("initialConvergenceCount", 0.25));
        algorithm.setInputParameter("preservedPopulation", properties.getDouble("preservedPopulation", 0.05));
        algorithm.setInputParameter("convergenceValue", (int)properties.getDouble("convergenceValue", 3.0));
        algorithm.setInputParameter("populationSize", (int)properties.getDouble("populationSize", 100.0));
        algorithm.setInputParameter("maxEvaluations", (int)properties.getDouble("maxEvaluations", 25000.0));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("probability", properties.getDouble("hux.rate", 1.0));
        HUXCrossover crossoverOperator = new HUXCrossover(parameters);
        parameters = new HashMap();
        parameters.put("probability", properties.getDouble("bf.rate", 0.35));
        BitFlipMutation mutationOperator = new BitFlipMutation(parameters);
        RandomSelection parentsSelection = new RandomSelection(null);
        parameters = new HashMap();
        parameters.put("problem", problem);
        RankingAndCrowdingSelection newGenerationSelection = new RankingAndCrowdingSelection(parameters);
        algorithm.addOperator("crossover", crossoverOperator);
        algorithm.addOperator("cataclysmicMutation", mutationOperator);
        algorithm.addOperator("parentSelection", parentsSelection);
        algorithm.addOperator("newGenerationSelection", newGenerationSelection);
        return algorithm;
    }

    private NSGAII newNSGAII(TypedProperties properties, JMetalProblemAdapter problem) throws JMException {
        NSGAII algorithm = new NSGAII(problem);
        algorithm.setInputParameter("populationSize", (int)properties.getDouble("populationSize", 100.0));
        algorithm.setInputParameter("maxEvaluations", (int)properties.getDouble("maxEvaluations", 25000.0));
        this.setupVariationOperators(algorithm, properties, problem);
        BinaryTournament2 selection = new BinaryTournament2(null);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }

    private OMOPSO newOMOPSO(TypedProperties properties, JMetalProblemAdapter problem) throws JMException {
        if (!(problem.getSolutionType() instanceof RealSolutionType)) {
            throw new JMException("unsupported solution type");
        }
        OMOPSO algorithm = new OMOPSO(problem);
        int populationSize = (int)properties.getDouble("populationSize", 100.0);
        int maxIterations = (int)properties.getDouble("maxEvaluations", 25000.0) / populationSize;
        double mutationProbability = 1.0 / (double)problem.getNumberOfVariables();
        algorithm.setInputParameter("swarmSize", populationSize);
        algorithm.setInputParameter("archiveSize", (int)properties.getDouble("archiveSize", 100.0));
        algorithm.setInputParameter("maxIterations", maxIterations);
        algorithm.setInputParameter("epsilon", properties.getDoubleArray("epsilon", new double[]{EpsilonHelper.getEpsilon(problem.getProblem())}));
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("probability", properties.getDouble("mutationProbability", mutationProbability));
        parameters.put("perturbation", properties.getDouble("perturbationIndex", 0.5));
        UniformMutation uniformMutation = new UniformMutation(parameters);
        parameters = new HashMap();
        parameters.put("probability", properties.getDouble("mutationProbability", mutationProbability));
        parameters.put("perturbation", properties.getDouble("perturbationIndex", 0.5));
        parameters.put("maxIterations", maxIterations);
        NonUniformMutation nonUniformMutation = new NonUniformMutation(parameters);
        algorithm.addOperator("uniformMutation", uniformMutation);
        algorithm.addOperator("nonUniformMutation", nonUniformMutation);
        return algorithm;
    }

    private PAES newPAES(TypedProperties properties, JMetalProblemAdapter problem) throws JMException {
        PAES algorithm = new PAES(problem);
        algorithm.setInputParameter("archiveSize", (int)properties.getDouble("archiveSize", 100.0));
        algorithm.setInputParameter("biSections", (int)properties.getDouble("bisections", 8.0));
        algorithm.setInputParameter("maxEvaluations", (int)properties.getDouble("maxEvaluations", 25000.0));
        this.setupVariationOperators(algorithm, properties, problem);
        return algorithm;
    }

    private PESA2 newPESA2(TypedProperties properties, JMetalProblemAdapter problem) throws JMException {
        PESA2 algorithm = new PESA2(problem);
        algorithm.setInputParameter("populationSize", (int)properties.getDouble("populationSize", 10.0));
        algorithm.setInputParameter("archiveSize", (int)properties.getDouble("archiveSize", 100.0));
        algorithm.setInputParameter("bisections", (int)properties.getDouble("bisections", 8.0));
        algorithm.setInputParameter("maxEvaluations", (int)properties.getDouble("maxEvaluations", 25000.0));
        this.setupVariationOperators(algorithm, properties, problem);
        return algorithm;
    }

    private SMPSO newSMPSO(TypedProperties properties, JMetalProblemAdapter problem) throws JMException {
        if (!(problem.getSolutionType() instanceof RealSolutionType)) {
            throw new JMException("unsupported solution type");
        }
        SMPSO algorithm = new SMPSO(problem);
        int populationSize = (int)properties.getDouble("populationSize", 100.0);
        int maxIterations = (int)properties.getDouble("maxEvaluations", 25000.0) / populationSize;
        algorithm.setInputParameter("swarmSize", populationSize);
        algorithm.setInputParameter("archiveSize", (int)properties.getDouble("archiveSize", 100.0));
        algorithm.setInputParameter("maxIterations", maxIterations);
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("probability", properties.getDouble("pm.rate", 1.0 / (double)problem.getNumberOfVariables()));
        parameters.put("distributionIndex", properties.getDouble("pm.distributionIndex", 20.0));
        PolynomialMutation mutation = new PolynomialMutation(parameters);
        algorithm.addOperator("mutation", mutation);
        return algorithm;
    }

    private SPEA2 newSPEA2(TypedProperties properties, JMetalProblemAdapter problem) throws JMException {
        SPEA2 algorithm = new SPEA2(problem);
        algorithm.setInputParameter("populationSize", (int)properties.getDouble("populationSize", 100.0));
        algorithm.setInputParameter("archiveSize", (int)properties.getDouble("archiveSize", 100.0));
        algorithm.setInputParameter("maxEvaluations", (int)properties.getDouble("maxEvaluations", 25000.0));
        this.setupVariationOperators(algorithm, properties, problem);
        BinaryTournament selection = new BinaryTournament(null);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }

    private SMSEMOA newSMSEMOA(TypedProperties properties, JMetalProblemAdapter problem) throws JMException {
        SMSEMOA algorithm = new SMSEMOA(problem);
        algorithm.setInputParameter("populationSize", (int)properties.getDouble("populationSize", 100.0));
        algorithm.setInputParameter("maxEvaluations", (int)properties.getDouble("maxEvaluations", 25000.0));
        algorithm.setInputParameter("offset", properties.getDouble("offset", 100.0));
        this.setupVariationOperators(algorithm, properties, problem);
        RandomSelection selection = new RandomSelection(null);
        algorithm.addOperator("selection", selection);
        return algorithm;
    }
}

