/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm.jmetal;

import jmetal.core.SolutionType;
import jmetal.encodings.solutionType.BinarySolutionType;
import jmetal.encodings.solutionType.PermutationSolutionType;
import jmetal.encodings.solutionType.RealSolutionType;
import jmetal.encodings.variable.Binary;
import jmetal.encodings.variable.Permutation;
import jmetal.encodings.variable.Real;
import jmetal.util.JMException;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variable;
import org.moeaframework.core.variable.BinaryVariable;
import org.moeaframework.core.variable.RealVariable;
import org.moeaframework.problem.ProblemException;

public class JMetalProblemAdapter
extends jmetal.core.Problem {
    private static final long serialVersionUID = 668044250314229409L;
    private final Problem problem;

    public JMetalProblemAdapter(Problem problem) {
        this.problem = problem;
        if (problem.getNumberOfConstraints() > 1) {
            System.err.println("multiple constraints not supported, aggregating into first constraint");
        }
        this.numberOfVariables_ = problem.getNumberOfVariables();
        this.numberOfObjectives_ = problem.getNumberOfObjectives();
        this.numberOfConstraints_ = problem.getNumberOfConstraints();
        this.problemName_ = problem.getName();
        this.lowerLimit_ = new double[this.numberOfVariables_];
        this.upperLimit_ = new double[this.numberOfVariables_];
        this.length_ = new int[this.numberOfVariables_];
        Solution solution = problem.newSolution();
        SolutionType solutionType = null;
        try {
            for (int i = 0; i < this.numberOfVariables_; ++i) {
                Variable variable = solution.getVariable(i);
                if (variable instanceof RealVariable) {
                    RealVariable real = (RealVariable)variable;
                    this.lowerLimit_[i] = real.getLowerBound();
                    this.upperLimit_[i] = real.getUpperBound();
                    if (solutionType == null) {
                        solutionType = new RealSolutionType(this);
                        continue;
                    }
                    if (solutionType instanceof RealSolutionType) continue;
                    throw new ProblemException(problem, "mixed types not supported");
                }
                if (variable instanceof BinaryVariable) {
                    BinaryVariable binary = (BinaryVariable)variable;
                    this.length_[i] = binary.getNumberOfBits();
                    if (solutionType == null) {
                        solutionType = new BinarySolutionType(this);
                        continue;
                    }
                    if (solutionType instanceof BinarySolutionType) continue;
                    throw new ProblemException(problem, "mixed types not supported");
                }
                if (variable instanceof org.moeaframework.core.variable.Permutation) {
                    org.moeaframework.core.variable.Permutation permutation = (org.moeaframework.core.variable.Permutation)variable;
                    this.length_[i] = permutation.size();
                    if (solutionType == null) {
                        solutionType = new PermutationSolutionType(this);
                        continue;
                    }
                    if (solutionType instanceof PermutationSolutionType) continue;
                    throw new ProblemException(problem, "mixed types not supported");
                }
                throw new ProblemException(problem, "type not supported");
            }
        }
        catch (ClassNotFoundException e) {
            throw new ProblemException(problem, (Throwable)e);
        }
        this.solutionType_ = solutionType;
    }

    @Override
    public void evaluate(jmetal.core.Solution solution) throws JMException {
        Solution result = this.translate(solution);
        this.problem.evaluate(result);
        for (int i = 0; i < result.getNumberOfObjectives(); ++i) {
            solution.setObjective(i, result.getObjective(i));
        }
        double overallConstraintViolation = 0.0;
        int numberOfViolations = 0;
        for (int i = 0; i < result.getNumberOfConstraints(); ++i) {
            if (result.getConstraint(i) == 0.0) continue;
            ++numberOfViolations;
            overallConstraintViolation -= Math.abs(result.getConstraint(i));
        }
        solution.setOverallConstraintViolation(overallConstraintViolation);
        solution.setNumberOfViolatedConstraint(numberOfViolations);
    }

    public Solution translate(jmetal.core.Solution solution) {
        int i;
        Solution result = this.problem.newSolution();
        for (i = 0; i < solution.numberOfVariables(); ++i) {
            jmetal.core.Variable variable = solution.getDecisionVariables()[i];
            if (variable instanceof Real) {
                Real real = (Real)variable;
                result.setVariable(i, new RealVariable(real.getValue(), real.getLowerBound(), real.getUpperBound()));
                continue;
            }
            if (variable instanceof Binary) {
                Binary binary = (Binary)variable;
                BinaryVariable bv = new BinaryVariable(binary.getNumberOfBits());
                for (int j = 0; j < binary.getNumberOfBits(); ++j) {
                    bv.set(j, binary.getIth(j));
                }
                result.setVariable(i, bv);
                continue;
            }
            if (variable instanceof Permutation) {
                Permutation permutation = (Permutation)variable;
                org.moeaframework.core.variable.Permutation p = new org.moeaframework.core.variable.Permutation(permutation.vector_);
                result.setVariable(i, p);
                continue;
            }
            throw new IllegalStateException();
        }
        for (i = 0; i < solution.numberOfObjectives(); ++i) {
            result.setObjective(i, solution.getObjective(i));
        }
        if (this.problem.getNumberOfConstraints() == 1) {
            result.setConstraint(0, solution.getOverallConstraintViolation());
        }
        return result;
    }

    public Problem getProblem() {
        return this.problem;
    }
}

