/*
 * Decompiled with CFR 0.152.
 */
package org.moeaframework.algorithm.pisa;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang3.ArrayUtils;
import org.moeaframework.algorithm.AbstractAlgorithm;
import org.moeaframework.algorithm.AlgorithmException;
import org.moeaframework.algorithm.pisa.State;
import org.moeaframework.core.Algorithm;
import org.moeaframework.core.NondominatedPopulation;
import org.moeaframework.core.PRNG;
import org.moeaframework.core.Problem;
import org.moeaframework.core.Settings;
import org.moeaframework.core.Solution;
import org.moeaframework.core.Variation;
import org.moeaframework.core.operator.RandomInitialization;
import org.moeaframework.util.TypedProperties;
import org.moeaframework.util.io.FileUtils;
import org.moeaframework.util.io.RedirectStream;

public class PISAAlgorithm
extends AbstractAlgorithm {
    private final String filePrefix;
    private final ProcessBuilder selector;
    private final State state;
    private final int alpha;
    private final int mu;
    private final int lambda;
    private final Map<Integer, Solution> solutions;
    private final Variation variation;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PISAAlgorithm(String name, Problem problem, Variation variation, Properties properties) throws IOException {
        super(problem);
        this.variation = variation;
        TypedProperties typedProperties = new TypedProperties(properties);
        String command = Settings.getPISACommand(name);
        String configuration = Settings.getPISAConfiguration(name);
        int pollRate = Settings.getPISAPollRate();
        if (command == null) {
            throw new IllegalArgumentException("missing command");
        }
        this.filePrefix = File.createTempFile("pisa", "").getCanonicalPath();
        if (!properties.containsKey("seed")) {
            properties.setProperty("seed", Integer.toString(PRNG.nextInt()));
        }
        if (configuration == null) {
            PrintWriter writer = null;
            configuration = new File(this.filePrefix + "par").getCanonicalPath();
            try {
                writer = new PrintWriter(new BufferedWriter(new FileWriter(configuration)));
                for (String parameter : Settings.getPISAParameters(name)) {
                    writer.print(parameter);
                    writer.print(' ');
                    writer.println(typedProperties.getString(parameter, Settings.getPISAParameterDefaultValue(name, parameter)));
                }
            }
            finally {
                if (writer != null) {
                    writer.close();
                }
            }
        }
        this.selector = new ProcessBuilder((String[])ArrayUtils.addAll((Object[])Settings.parseCommand(command), (Object[])new String[]{configuration, this.filePrefix, Double.toString((double)pollRate / 1000.0)}));
        int populationSize = (int)typedProperties.getDouble("populationSize", 100.0);
        while (populationSize % variation.getArity() != 0) {
            ++populationSize;
        }
        this.alpha = populationSize;
        this.mu = (int)typedProperties.getDouble("mu", this.alpha);
        this.lambda = (int)typedProperties.getDouble("lambda", this.alpha);
        this.state = new State(new File(this.filePrefix + "sta"));
        this.solutions = new HashMap<Integer, Solution>();
    }

    @Override
    public void initialize() {
        super.initialize();
        try {
            this.configure();
            this.state.set(0);
            this.state0();
            this.state.set(1);
            Process process = this.selector.start();
            RedirectStream.redirect(process.getInputStream(), System.out);
            RedirectStream.redirect(process.getErrorStream(), System.err);
        }
        catch (Exception e) {
            throw new AlgorithmException((Algorithm)this, (Throwable)e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void terminate() {
        super.terminate();
        if (!this.isInitialized()) {
            return;
        }
        try {
            int currentState = this.state.get();
            while (true) {
                if (currentState == 2) {
                    this.state.set(4);
                    this.state4();
                    this.state.set(5);
                    return;
                }
                if (currentState == 4 || currentState == 7) return;
                if (currentState >= 8) throw new AlgorithmException((Algorithm)this, "restart not supported");
                currentState = this.state.waitWhile(currentState);
            }
        }
        catch (Exception e) {
            throw new AlgorithmException((Algorithm)this, (Throwable)e);
        }
    }

    @Override
    public void iterate() {
        block5: {
            try {
                int currentState = this.state.get();
                while (true) {
                    if (currentState == 2) {
                        this.state2();
                        this.state.set(3);
                        break block5;
                    }
                    if (currentState == 4 || currentState == 7) {
                        this.terminate();
                        break block5;
                    }
                    if (currentState >= 8) break;
                    currentState = this.state.waitWhile(currentState);
                }
                throw new AlgorithmException((Algorithm)this, "restart not supported");
            }
            catch (Exception e) {
                throw new AlgorithmException((Algorithm)this, (Throwable)e);
            }
        }
    }

    @Override
    public NondominatedPopulation getResult() {
        NondominatedPopulation result = new NondominatedPopulation();
        result.addAll(this.solutions.values());
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearFile(File file) throws IOException {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            writer.println('0');
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    private void updatePopulation(int[] ids) {
        ArrayList<Integer> archivedIds = new ArrayList<Integer>();
        for (int id : ids) {
            archivedIds.add(id);
        }
        this.solutions.keySet().retainAll(archivedIds);
    }

    private int addToPopulation(Solution solution) {
        int id = this.nextFreeId();
        this.solutions.put(id, solution);
        return id;
    }

    private int nextFreeId() {
        int id = 0;
        Set<Integer> ids = this.solutions.keySet();
        while (ids.contains(id)) {
            ++id;
        }
        return id;
    }

    private void state0() throws IOException {
        RandomInitialization initialization = new RandomInitialization(this.problem, this.alpha);
        Solution[] initialPopulation = initialization.initialize();
        int[] initialIds = new int[this.alpha];
        this.evaluateAll(initialPopulation);
        for (int i = 0; i < this.alpha; ++i) {
            initialIds[i] = this.addToPopulation(initialPopulation[i]);
        }
        this.writePopulation(new File(this.filePrefix + "ini"), initialIds);
    }

    private void state4() throws IOException {
        int[] archivedIds = this.readList(new File(this.filePrefix + "arc"));
        this.updatePopulation(archivedIds);
    }

    private void state2() throws IOException {
        int i;
        int[] selectionIds = this.readList(new File(this.filePrefix + "sel"));
        int[] archivedIds = this.readList(new File(this.filePrefix + "arc"));
        int[] variationIds = new int[this.lambda];
        if (selectionIds.length != this.mu) {
            throw new IOException("invalid selection length");
        }
        this.updatePopulation(archivedIds);
        this.clearFile(new File(this.filePrefix + "sel"));
        this.clearFile(new File(this.filePrefix + "arc"));
        ArrayList<Solution> offspring = new ArrayList<Solution>();
        for (i = 0; i < this.mu; i += this.variation.getArity()) {
            Solution[] parents = new Solution[this.variation.getArity()];
            for (int j = 0; j < this.variation.getArity(); ++j) {
                parents[j] = this.solutions.get(selectionIds[i + j]);
            }
            offspring.addAll(Arrays.asList(this.variation.evolve(parents)));
        }
        if (offspring.size() != this.lambda) {
            throw new IOException("invalid variation length");
        }
        this.evaluateAll(offspring);
        for (i = 0; i < this.lambda; ++i) {
            variationIds[i] = this.addToPopulation((Solution)offspring.get(i));
        }
        this.writePopulation(new File(this.filePrefix + "var"), variationIds);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int[] readList(File file) throws IOException {
        BufferedReader reader = null;
        String line = null;
        try {
            reader = new BufferedReader(new FileReader(file));
            line = reader.readLine();
            if (line == null) {
                throw new IOException("unexpected end of file");
            }
            int size = Integer.parseInt(line);
            int[] result = new int[size];
            for (int i = 0; i < size; ++i) {
                line = reader.readLine();
                if (line == null) {
                    throw new IOException("unexpected end of file");
                }
                result[i] = Integer.parseInt(line);
            }
            if (!"END".equals(reader.readLine())) {
                throw new IOException("expected END on last line");
            }
            int[] nArray = result;
            return nArray;
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writePopulation(File file, int[] ids) throws IOException {
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(file)));
            writer.println(ids.length * (this.problem.getNumberOfObjectives() + 1));
            for (int i = 0; i < ids.length; ++i) {
                writer.print(ids[i]);
                for (int j = 0; j < this.problem.getNumberOfObjectives(); ++j) {
                    writer.print(' ');
                    writer.print(this.solutions.get(ids[i]).getObjective(j));
                }
                writer.println();
            }
            writer.println("END");
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configure() throws IOException {
        FileUtils.delete(new File(this.filePrefix + "arc"));
        FileUtils.delete(new File(this.filePrefix + "cfg"));
        FileUtils.delete(new File(this.filePrefix + "ini"));
        FileUtils.delete(new File(this.filePrefix + "sel"));
        FileUtils.delete(new File(this.filePrefix + "sta"));
        PrintWriter writer = null;
        try {
            writer = new PrintWriter(new BufferedWriter(new FileWriter(new File(this.filePrefix + "cfg"))));
            writer.print("alpha ");
            writer.println(this.alpha);
            writer.print("mu ");
            writer.println(this.mu);
            writer.print("lambda ");
            writer.println(this.lambda);
            writer.print("dim ");
            writer.print(this.problem.getNumberOfObjectives());
        }
        finally {
            if (writer != null) {
                writer.close();
            }
        }
    }
}

